/*
 * Decompiled with CFR 0.152.
 */
package xyz.crazyh.fabrictweaker.gui;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.config.IHotkeyTogglable;
import fi.dy.masa.malilib.config.options.BooleanHotkeyGuiWrapper;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiConfigsBase;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetListConfigOptions;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_437;
import xyz.crazyh.fabrictweaker.Reference;
import xyz.crazyh.fabrictweaker.config.Configs;
import xyz.crazyh.fabrictweaker.config.DisableToggle;
import xyz.crazyh.fabrictweaker.config.FeatureToggle;
import xyz.crazyh.fabrictweaker.config.Hotkeys;

public class GuiConfigs
extends GuiConfigsBase {
    public static ImmutableList<FeatureToggle> TWEAK_LIST = FeatureToggle.VALUES;
    private static ImmutableList<DisableToggle> DISABLE_LIST = DisableToggle.VALUES;
    private static ConfigGuiTab tab = ConfigGuiTab.TWEAKS;

    public GuiConfigs() {
        super(10, 50, "fabrictweaker", null, "fabrictweaker.gui.title.configs", new Object[]{String.format("%s", Reference.MOD_VERSION)});
    }

    public void initGui() {
        super.initGui();
        this.clearOptions();
        int x = 10;
        int y = 26;
        for (ConfigGuiTab tab : ConfigGuiTab.values()) {
            x += this.createButton(x, y, -1, tab);
        }
    }

    protected int getConfigWidth() {
        ConfigGuiTab tab = GuiConfigs.tab;
        if (tab == ConfigGuiTab.GENERIC) {
            return 120;
        }
        if (tab == ConfigGuiTab.LISTS) {
            return 200;
        }
        return 260;
    }

    private int createButton(int x, int y, int width, ConfigGuiTab tab) {
        ButtonGeneric button = new ButtonGeneric(x, y, width, 20, tab.getDisplayName(), new String[0]);
        button.setEnabled(GuiConfigs.tab != tab);
        this.addButton((ButtonBase)button, new ButtonListener(tab, this));
        return button.getWidth() + 2;
    }

    public static void openGui() {
        GuiBase.openGui((class_437)new GuiConfigs());
    }

    public List<GuiConfigsBase.ConfigOptionWrapper> getConfigs() {
        Object configs;
        ConfigGuiTab tab = GuiConfigs.tab;
        if (tab == ConfigGuiTab.GENERIC) {
            configs = Configs.General.OPTIONS;
        } else if (tab == ConfigGuiTab.LISTS) {
            configs = Configs.Lists.OPTIONS;
        } else if (tab == ConfigGuiTab.HOTKEYS) {
            configs = Hotkeys.HOTKEY_LIST;
        } else {
            if (tab == ConfigGuiTab.TWEAKS) {
                return GuiConfigsBase.ConfigOptionWrapper.createFor(TWEAK_LIST.stream().map(this::wrapConfig).toList());
            }
            if (tab == ConfigGuiTab.DISABLES) {
                return GuiConfigsBase.ConfigOptionWrapper.createFor(DISABLE_LIST.stream().map(this::wrapConfig).toList());
            }
            return Collections.emptyList();
        }
        return GuiConfigsBase.ConfigOptionWrapper.createFor(configs);
    }

    protected BooleanHotkeyGuiWrapper wrapConfig(IHotkeyTogglable config) {
        return new BooleanHotkeyGuiWrapper(config.getName(), (IConfigBoolean)config, config.getKeybind());
    }

    protected boolean useKeybindSearch() {
        return tab == ConfigGuiTab.TWEAKS || tab == ConfigGuiTab.HOTKEYS || tab == ConfigGuiTab.DISABLES;
    }

    public static enum ConfigGuiTab {
        GENERIC("fabrictweaker.gui.button.config_gui.generic"),
        LISTS("fabrictweaker.gui.button.config_gui.lists"),
        TWEAKS("fabrictweaker.gui.button.config_gui.tweaks"),
        DISABLES("fabrictweaker.gui.button.config_gui.disables"),
        HOTKEYS("fabrictweaker.gui.button.config_gui.hotkeys");

        private final String translationKey;

        private ConfigGuiTab(String translationKey) {
            this.translationKey = translationKey;
        }

        public String getDisplayName() {
            return StringUtils.translate((String)this.translationKey, (Object[])new Object[0]);
        }
    }

    private static class ButtonListener
    implements IButtonActionListener {
        private final GuiConfigs parent;
        private final ConfigGuiTab tab;

        public ButtonListener(ConfigGuiTab tab, GuiConfigs parent) {
            this.tab = tab;
            this.parent = parent;
        }

        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            tab = this.tab;
            this.parent.reCreateListWidget();
            ((WidgetListConfigOptions)this.parent.getListWidget()).resetScrollbarPosition();
            this.parent.initGui();
        }
    }
}

