/*
 * Decompiled with CFR 0.152.
 */
package xyz.crazyh.fabrictweaker.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.config.ConfigType;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.config.IConfigNotifiable;
import fi.dy.masa.malilib.config.IHotkeyTogglable;
import fi.dy.masa.malilib.hotkeys.IHotkeyCallback;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeyCallbackToggleBooleanConfigWithMessage;
import fi.dy.masa.malilib.hotkeys.KeybindMulti;
import fi.dy.masa.malilib.hotkeys.KeybindSettings;
import fi.dy.masa.malilib.interfaces.IValueChangeCallback;
import fi.dy.masa.malilib.util.StringUtils;
import xyz.crazyh.fabrictweaker.FabricTweaker;

public enum FeatureToggle implements IHotkeyTogglable,
IConfigNotifiable<IConfigBoolean>
{
    ADDITIONAL_BLOCK_BREAKING_COOLDOWN("Additional Block Breaking Cooldown", false, "Add additional delay between breaking two blocks"),
    AUTO_PLACE_SHULKER_AFTER_PICK("Auto Place ShulkerBox After Pick", false, "Will try to place down shulkerbox after pickBlockShulker"),
    EASY_PLACE_ALLOW_LEVER_USE("Easy Place Allow Lever Use", false, "Will allow flicking lever when easy place is enabled."),
    EASY_PLACE_ALLOW_SHULKER("Easy Place Allow ShulkerBox", false, "Easy place mode's placement restriction will not check for shulkerbox"),
    FENCE_JUMPER("Fence Jumper", false, "You can jump over fence and wall."),
    PREVENT_DIG_BELOW("Prevent Dig Below", false, "Prevents you from digging blocks that are lower than you, sneak to override"),
    PREVENT_PLACE_BELOW("Prevent Place Below", false, "Prevents you from placing blocks that are lower than you, sneak to override"),
    STEP_UP("Step Up", false, "Increase player step up height: 0.6 -> 1.1"),
    STRICT_FAKE_SNEAKING("Strict Fake Sneaking", false, "Fake sneaking but you wont fall from edge at all."),
    THREADED_LITEMATICA_UPDATE("Threaded Litematica Update", false, "TEMP FEATURE, will make schem update on another thread, USE WITH CAUTION");

    public static final ImmutableList<FeatureToggle> VALUES;
    private final String name;
    private final String comment;
    private final String prettyName;
    private final IKeybind keybind;
    private final boolean defaultValueBoolean;
    private final boolean singlePlayer;
    private boolean valueBoolean;
    private IValueChangeCallback<IConfigBoolean> callback;

    private FeatureToggle(String name, boolean defaultValueBoolean, String comment) {
        this(name, defaultValueBoolean, "", comment);
    }

    private FeatureToggle(String name, boolean defaultValue, String defaultHotkey, String comment) {
        this(name, defaultValue, false, defaultHotkey, KeybindSettings.DEFAULT, comment);
    }

    private FeatureToggle(String name, boolean defaultValue, boolean singlePlayer, String defaultHotkey, String comment) {
        this(name, defaultValue, singlePlayer, defaultHotkey, KeybindSettings.DEFAULT, comment);
    }

    private FeatureToggle(String name, boolean defaultValue, String defaultHotkey, KeybindSettings settings, String comment) {
        this(name, defaultValue, false, defaultHotkey, settings, comment);
    }

    private FeatureToggle(String name, boolean defaultValue, boolean singlePlayer, String defaultHotkey, KeybindSettings settings, String comment) {
        this(name, defaultValue, singlePlayer, defaultHotkey, settings, comment, StringUtils.splitCamelCase((String)name.substring(5)));
    }

    private FeatureToggle(String name, boolean defaultValue, String defaultHotkey, String comment, String prettyName) {
        this(name, defaultValue, false, defaultHotkey, comment, prettyName);
    }

    private FeatureToggle(String name, boolean defaultValue, boolean singlePlayer, String defaultHotkey, String comment, String prettyName) {
        this(name, defaultValue, singlePlayer, defaultHotkey, KeybindSettings.DEFAULT, comment, prettyName);
    }

    private FeatureToggle(String name, boolean defaultValue, boolean singlePlayer, String defaultHotkey, KeybindSettings settings, String comment, String prettyName) {
        this.name = name;
        this.valueBoolean = defaultValue;
        this.defaultValueBoolean = defaultValue;
        this.singlePlayer = singlePlayer;
        this.comment = comment;
        this.prettyName = prettyName;
        this.keybind = KeybindMulti.fromStorageString((String)defaultHotkey, (KeybindSettings)settings);
        this.keybind.setCallback((IHotkeyCallback)new KeyCallbackToggleBooleanConfigWithMessage((IConfigBoolean)this));
    }

    public boolean getBooleanValue() {
        return this.valueBoolean;
    }

    public boolean getDefaultBooleanValue() {
        return this.defaultValueBoolean;
    }

    public void setBooleanValue(boolean value) {
        boolean oldValue = this.valueBoolean;
        this.valueBoolean = value;
        if (oldValue != this.valueBoolean) {
            this.onValueChanged();
        }
    }

    public void onValueChanged() {
        if (this.callback != null) {
            this.callback.onValueChanged((IConfigBase)this);
        }
    }

    public void setValueChangeCallback(IValueChangeCallback<IConfigBoolean> callback) {
        this.callback = callback;
    }

    public IKeybind getKeybind() {
        return this.keybind;
    }

    public ConfigType getType() {
        return ConfigType.HOTKEY;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        String comment = StringUtils.getTranslatedOrFallback((String)("config.comment." + this.getName().toLowerCase()), (String)this.comment);
        if (comment != null && this.singlePlayer) {
            return comment + "\n" + StringUtils.translate((String)"tweakeroo.label.config_comment.single_player_only", (Object[])new Object[0]);
        }
        return comment;
    }

    public void setValueFromJsonElement(JsonElement element) {
        try {
            if (element.isJsonPrimitive()) {
                this.valueBoolean = element.getAsBoolean();
            } else {
                FabricTweaker.LOGGER.warn("Failed to set config value for '{}' from the JSON element '{}'", (Object)this.getName(), (Object)element);
            }
        }
        catch (Exception e) {
            FabricTweaker.LOGGER.warn("Failed to set config value for '{}' from the JSON element '{}'", (Object)this.getName(), (Object)element, (Object)e);
        }
    }

    public JsonElement getAsJsonElement() {
        return new JsonPrimitive(Boolean.valueOf(this.valueBoolean));
    }

    static {
        VALUES = ImmutableList.copyOf((Object[])FeatureToggle.values());
    }
}

