/*
 * Decompiled with CFR 0.152.
 */
package xyz.crazyh.fabrictweaker.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.config.ConfigUtils;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigHandler;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.config.options.ConfigInteger;
import fi.dy.masa.malilib.config.options.ConfigOptionList;
import fi.dy.masa.malilib.config.options.ConfigStringList;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.restrictions.UsageRestriction;
import java.io.File;
import xyz.crazyh.fabrictweaker.config.DisableToggle;
import xyz.crazyh.fabrictweaker.config.FeatureToggle;
import xyz.crazyh.fabrictweaker.config.Hotkeys;
import xyz.crazyh.fabrictweaker.utils.InventoryUtils;

public class Configs
implements IConfigHandler {
    private static final String CONFIG_FILE_NAME = "fabrictweaker.json";

    public static void loadFromFile() {
        JsonElement element;
        File configFile = new File(FileUtils.getConfigDirectory(), CONFIG_FILE_NAME);
        if (configFile.exists() && configFile.isFile() && configFile.canRead() && (element = JsonUtils.parseJsonFile((File)configFile)) != null && element.isJsonObject()) {
            JsonObject root = element.getAsJsonObject();
            ConfigUtils.readConfigBase((JsonObject)root, (String)"General", General.OPTIONS);
            ConfigUtils.readConfigBase((JsonObject)root, (String)"Lists", Lists.OPTIONS);
            ConfigUtils.readConfigBase((JsonObject)root, (String)"HotKeys", Hotkeys.HOTKEY_LIST);
            ConfigUtils.readHotkeyToggleOptions((JsonObject)root, (String)"TweakHotkeys", (String)"Tweaks", FeatureToggle.VALUES);
            ConfigUtils.readHotkeyToggleOptions((JsonObject)root, (String)"DisableHotkeys", (String)"Disables", DisableToggle.VALUES);
        }
    }

    public static void updateLists() {
        InventoryUtils.ITEM_DROP_LIST.setListType((UsageRestriction.ListType)Lists.DROP_INV_LIST_TYPE.getOptionListValue());
        InventoryUtils.ITEM_DROP_LIST.setListContents(Lists.DROP_INV_BLACKLIST.getStrings(), Lists.DROP_INV_WHITELIST.getStrings());
    }

    public static void saveToFile() {
        File dir = FileUtils.getConfigDirectory();
        if (dir.exists() && dir.isDirectory() || dir.mkdirs()) {
            JsonObject root = new JsonObject();
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"General", General.OPTIONS);
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"Lists", Lists.OPTIONS);
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"HotKeys", Hotkeys.HOTKEY_LIST);
            ConfigUtils.writeHotkeyToggleOptions((JsonObject)root, (String)"TweakHotkeys", (String)"Tweaks", FeatureToggle.VALUES);
            ConfigUtils.writeHotkeyToggleOptions((JsonObject)root, (String)"DisableHotkeys", (String)"Disables", DisableToggle.VALUES);
            JsonUtils.writeJsonToFile((JsonObject)root, (File)new File(dir, CONFIG_FILE_NAME));
        }
    }

    public void load() {
        Configs.loadFromFile();
        Configs.updateLists();
    }

    public void save() {
        Configs.saveToFile();
    }

    public static class General {
        public static final ConfigInteger ADDITIONAL_COOLDOWN_VALUE = new ConfigInteger("Additional Cooldown Value", 3, 1, 20, "The time in gametick added to block breaking cooldown");
        public static final ConfigInteger CHUNK_RENDER_DISTANCE = new ConfigInteger("Chunk Render Distance", 0, 0, 512, "The chunk render distance that are kept to render. Default=0 will use vanilla setting.");
        public static final ConfigInteger FIXED_LAN_PORT = new ConfigInteger("Fixed Lan Port", 25565, 1025, 65534, false, "The default port used by \"Open to Lan\".");
        public static final ConfigInteger MAX_CHAT_WIDTH = new ConfigInteger("Max Chat Width", 280, 280, 1000, "Width of chat ofc");
        public static final ConfigInteger PREVENT_DIG_DEPTH = new ConfigInteger("Prevent Dig Depth", 0, 0, 16, "The amount of blocks allowed by tweak PreventDigBelow, default=0 won't allow any block below you get dug");
        public static final ConfigInteger PREVENT_PLACE_DEPTH = new ConfigInteger("Prevent Place Depth", 0, 0, 16, "The amount of blocks allowed by tweak PreventPlaceBelow, default=0 won't allow any block below you get placed");
        public static final ImmutableList<IConfigBase> OPTIONS = ImmutableList.of((Object)ADDITIONAL_COOLDOWN_VALUE, (Object)CHUNK_RENDER_DISTANCE, (Object)FIXED_LAN_PORT, (Object)MAX_CHAT_WIDTH, (Object)PREVENT_DIG_DEPTH, (Object)PREVENT_PLACE_DEPTH);
    }

    public static class Lists {
        public static final ConfigOptionList DROP_INV_LIST_TYPE = new ConfigOptionList("Drop Inventory List Type", (IConfigOptionListEntry)UsageRestriction.ListType.WHITELIST, "The list type of dropping inventory");
        public static final ConfigStringList DROP_INV_BLACKLIST = new ConfigStringList("Drop Inventory Blacklist", ImmutableList.of((Object)"minecraft:diamond_pickaxe"), "Items that will not allowed to be dropped, wildcard \"*\" is supported, e.g. *_ore");
        public static final ConfigStringList DROP_INV_WHITELIST = new ConfigStringList("Drop Inventory Whitelist", ImmutableList.of((Object)"minecraft:stone", (Object)"minecraft:deepslate"), "Items that will be dropped, wildcard \"*\" is supported, e.g. *_ore");
        public static final ImmutableList<IConfigBase> OPTIONS = ImmutableList.of((Object)DROP_INV_LIST_TYPE, (Object)DROP_INV_BLACKLIST, (Object)DROP_INV_WHITELIST);
    }
}

