/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.lmspaster.network;

import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedHashSet;
import java.util.function.Consumer;
import me.fallenbreath.fanetlib.api.event.FanetlibClientEvents;
import me.fallenbreath.fanetlib.api.packet.FanetlibPackets;
import me.fallenbreath.fanetlib.api.packet.PacketCodec;
import me.fallenbreath.fanetlib.api.packet.PacketId;
import me.fallenbreath.lmspaster.LitematicaServerPasterMod;
import me.fallenbreath.lmspaster.network.ClientNetworkHandler;
import me.fallenbreath.lmspaster.network.LmsPasterPacket;
import me.fallenbreath.lmspaster.network.ServerNetworkHandler;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2487;
import net.minecraft.class_2658;
import net.minecraft.class_2817;

public class LmsNetwork {
    private static final PacketId<LmsPasterPacket> PACKET_ID = PacketId.of((String)"litematica-server-paster", (String)"network_v2");

    public static void init() {
        FanetlibPackets.registerDual(PACKET_ID, (PacketCodec)PacketCodec.of(LmsPasterPacket::write, LmsPasterPacket::new), (p, c) -> ServerNetworkHandler.handleClientPacket(p, c.getPlayer()), (p, c) -> ClientNetworkHandler.handleServerPacket(p, c.getPlayer()));
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            LmsNetwork.initClient();
        }
    }

    private static void initClient() {
        FanetlibClientEvents.registerGameJoinListener((client, networkHandler) -> ClientNetworkHandler.sendHiToTheServer(networkHandler));
        FanetlibClientEvents.registerPlayerRespawnListener((client, networkHandler) -> ClientNetworkHandler.sendHiToTheServer(networkHandler));
    }

    public static class S2C {
        public static final int HI = 0;
        public static final int ACCEPT_PACKETS = 1;

        public static class_2658 packet(int packetId, Consumer<class_2487> payloadBuilder) {
            class_2487 nbt = new class_2487();
            payloadBuilder.accept(nbt);
            return FanetlibPackets.createS2C(PACKET_ID, (Object)new LmsPasterPacket(packetId, nbt));
        }
    }

    public static class C2S {
        public static final int HI = 0;
        public static final int CHAT = 1;
        public static final int VERY_LONG_CHAT_START = 2;
        public static final int VERY_LONG_CHAT_CONTENT = 3;
        public static final int VERY_LONG_CHAT_END = 4;
        public static final int[] ALL_PACKET_IDS;

        public static class_2817 packet(int packetId, Consumer<class_2487> payloadBuilder) {
            class_2487 nbt = new class_2487();
            payloadBuilder.accept(nbt);
            return FanetlibPackets.createC2S(PACKET_ID, (Object)new LmsPasterPacket(packetId, nbt));
        }

        static {
            LinkedHashSet allPacketIds = Sets.newLinkedHashSet();
            for (Field field : C2S.class.getFields()) {
                if (field.getType() != Integer.TYPE || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
                try {
                    int id = (Integer)field.get(null);
                    boolean notExists = allPacketIds.add(id);
                    if (notExists) continue;
                    LitematicaServerPasterMod.LOGGER.error("Duplicated packet id {} ({})", (Object)id, (Object)field.getName());
                }
                catch (Exception e) {
                    LitematicaServerPasterMod.LOGGER.error("Failed to access field {}: {}", (Object)field, (Object)e);
                }
            }
            ALL_PACKET_IDS = new int[allPacketIds.size()];
            int i = 0;
            for (Integer id : allPacketIds) {
                C2S.ALL_PACKET_IDS[i++] = id;
            }
        }
    }
}

