/*
 * Decompiled with CFR 0.152.
 */
package com.plusls.MasaGadget.util;

import com.plusls.MasaGadget.SharedConstants;
import com.plusls.MasaGadget.game.Configs;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.renderer.shapes.ShapeBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeDespawnSphere;
import fi.dy.masa.minihud.renderer.shapes.ShapeManager;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1317;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3568;
import net.minecraft.class_4538;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.api.compat.minecraft.network.chat.MutableComponentCompat;
import top.hendrixshen.magiclib.api.compat.minecraft.resources.ResourceLocationCompat;
import top.hendrixshen.magiclib.api.compat.minecraft.world.level.LevelCompat;
import top.hendrixshen.magiclib.util.minecraft.ComponentUtil;
import top.hendrixshen.magiclib.util.minecraft.InfoUtil;

public class SearchMobSpawnPointUtil {
    @Nullable
    private static ShapeDespawnSphere getShapeDespawnSphere() {
        ShapeDespawnSphere ret = null;
        for (ShapeBase shapeBase : ShapeManager.INSTANCE.getAllShapes()) {
            if (!shapeBase.isEnabled() || !(shapeBase instanceof ShapeDespawnSphere)) continue;
            if (ret == null) {
                ret = (ShapeDespawnSphere)shapeBase;
                continue;
            }
            InfoUtil.displayChatMessage((class_2561)ComponentUtil.tr((String)"masa_gadget_mod.message.onlySupportOneDespawnShape", (Object[])new Object[0]).withStyle(new class_124[]{class_124.field_1061}).get());
            return null;
        }
        if (ret == null) {
            InfoUtil.displayChatMessage((class_2561)ComponentUtil.tr((String)"masa_gadget_mod.message.canNotFindDespawnShape", (Object[])new Object[0]).withStyle(new class_124[]{class_124.field_1061}).get());
        }
        return ret;
    }

    public static void search() {
        MutableComponentCompat text;
        class_638 level = class_310.method_1551().field_1687;
        class_746 player = class_310.method_1551().field_1724;
        if (level == null || player == null) {
            return;
        }
        LevelCompat levelCompat = LevelCompat.of((class_1937)level);
        ShapeDespawnSphere shapeDespawnSphere = SearchMobSpawnPointUtil.getShapeDespawnSphere();
        if (shapeDespawnSphere == null) {
            return;
        }
        class_243 centerPos = shapeDespawnSphere.getCenter();
        class_2338 pos = new class_2338((int)centerPos.field_1352, (int)centerPos.field_1351, (int)centerPos.field_1350);
        SharedConstants.getLogger().warn("shape: {}", (Object)shapeDespawnSphere.getCenter());
        class_2338 spawnPos = null;
        int maxX = pos.method_10263() + 129;
        int maxZ = pos.method_10260() + 129;
        class_2338.class_2339 currentPos = new class_2338.class_2339();
        int maxSpawnLightLevel = Configs.Generic.LIGHT_LEVEL_THRESHOLD_SAFE.getIntegerValue();
        class_3568 lightingProvider = level.method_2935().method_12130();
        class_1299 entityType = levelCompat.getDimensionLocation().equals((Object)ResourceLocationCompat.withDefaultNamespace((String)"the_nether")) ? class_1299.field_6050 : class_1299.field_6046;
        class_1299 entityType2 = levelCompat.getDimensionLocation().equals((Object)ResourceLocationCompat.withDefaultNamespace((String)"the_nether")) ? null : class_1299.field_6079;
        for (int x = pos.method_10263() - 129; x <= maxX; ++x) {
            block1: for (int z = pos.method_10260() - 129; z <= maxZ; ++z) {
                class_2818 chunk = level.method_8497(x >> 4, z >> 4);
                if (chunk == null) continue;
                int maxY = Math.min(pos.method_10264() + 129, chunk.method_12005(class_2902.class_2903.field_13202, x, z) + 1);
                for (int y = Math.max(pos.method_10264() - 129, levelCompat.getMinBuildHeight() + 1); y <= maxY; ++y) {
                    if (SearchMobSpawnPointUtil.squaredDistanceTo(x, y, z, centerPos) > 16384.0) {
                        if (!((double)y > centerPos.field_1351)) continue;
                        continue block1;
                    }
                    if (spawnPos != null && player.method_5649((double)x, (double)y, (double)z) > player.method_5649((double)spawnPos.method_10263(), (double)spawnPos.method_10264(), (double)spawnPos.method_10260())) continue;
                    currentPos.method_10103(x, y, z);
                    if (!class_1317.method_56558((class_1299)entityType, (class_4538)level, (class_2338)currentPos) || lightingProvider.method_15562(class_1944.field_9282).method_15543((class_2338)currentPos) >= maxSpawnLightLevel) continue;
                    class_2248 block = level.method_8320(currentPos.method_10074()).method_26204();
                    String blockId = class_7923.field_41175.method_10221((Object)level.method_8320(currentPos.method_10074()).method_26204()).toString();
                    String blockName = block.method_9518().getString();
                    if (!Configs.searchMobSpawnPointBlackList.getStrings().stream().noneMatch(s -> blockId.contains((CharSequence)s) || blockName.contains((CharSequence)s))) continue;
                    if (level.method_18026(entityType.method_58629((double)currentPos.method_10263() + 0.5, (double)currentPos.method_10264(), (double)currentPos.method_10260() + 0.5))) {
                        spawnPos = currentPos.method_10062();
                        continue;
                    }
                    if (entityType2 == null || !level.method_18026(entityType.method_58629((double)currentPos.method_10263() + 0.5, (double)currentPos.method_10264(), (double)currentPos.method_10260() + 0.5))) continue;
                    spawnPos = currentPos.method_10062();
                }
            }
        }
        if (spawnPos == null) {
            text = ComponentUtil.tr((String)"masa_gadget_mod.message.noBlockCanSpawn", (Object[])new Object[0]).withStyle(new class_124[]{class_124.field_1060});
        } else {
            text = ComponentUtil.tr((String)"masa_gadget_mod.message.spawnPos", (Object[])new Object[]{spawnPos.method_10263(), spawnPos.method_10264(), spawnPos.method_10260()});
            if (MagicLib.getInstance().getCurrentPlatform().isModLoaded("ommc")) {
                InfoUtil.sendCommand((String)String.format("highlightWaypoint %d %d %d", spawnPos.method_10263(), spawnPos.method_10264(), spawnPos.method_10260()));
            }
        }
        InfoUtil.displayChatMessage((class_2561)((class_2561)text.get()));
    }

    private static double squaredDistanceTo(int x, int y, int z, class_243 vec3d) {
        double d = vec3d.field_1352 - (double)x;
        double e = vec3d.field_1351 - (double)y;
        double f = vec3d.field_1350 - (double)z;
        return d * d + e * e + f * f;
    }
}

