/*
 * Decompiled with CFR 0.152.
 */
package com.plusls.MasaGadget.impl.mod_tweak.malilib.fastSwitchMasaConfigGui;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.plusls.MasaGadget.SharedConstants;
import com.plusls.MasaGadget.util.MiscUtil;
import fi.dy.masa.malilib.gui.GuiConfigsBase;
import fi.dy.masa.malilib.interfaces.IStringValue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.ApiStatus;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.api.compat.modmenu.ModMenuApiCompat;
import top.hendrixshen.magiclib.util.ReflectionUtil;
import top.hendrixshen.magiclib.util.collect.ValueContainer;

public class FastMasaGuiSwitcher {
    private static final AtomicReference<Object> instance = new AtomicReference();
    private final BiMap<ModMenuApiCompat.ConfigScreenFactoryCompat<?>, IStringValue> guiModName = HashBiMap.create();
    private final Map<Class<?>, ModMenuApiCompat.ConfigScreenFactoryCompat<?>> guiClass = Maps.newHashMap();
    private final ValueContainer<Class<?>> modMenuApiClass;
    private final ValueContainer<Method> getModConfigScreenFactoryMethod;
    private final ValueContainer<Method> createMethod;
    private final ValueContainer<Class<?>> legacyModMenuApiClass;
    private final ValueContainer<Method> legacyGetModConfigScreenFactoryMethod;
    private final ValueContainer<Method> legacyCreateMethod;
    private final ValueContainer<Method> legacyGetConfigScreenFactory;
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    private FastMasaGuiSwitcher() {
        this.modMenuApiClass = ReflectionUtil.getClass((String)"com.terraformersmc.modmenu.api.ModMenuApi");
        this.getModConfigScreenFactoryMethod = ReflectionUtil.getMethod(this.modMenuApiClass, (String)"getModConfigScreenFactory", (Class[])new Class[0]);
        this.createMethod = ReflectionUtil.getMethod((String)"com.terraformersmc.modmenu.api.ConfigScreenFactory", (String)"create", (Class[])new Class[]{class_437.class});
        this.legacyModMenuApiClass = ReflectionUtil.getClass((String)"io.github.prospector.modmenu.api.ModMenuApi");
        this.legacyGetConfigScreenFactory = ReflectionUtil.getMethod(this.legacyModMenuApiClass, (String)"getConfigScreenFactory", (Class[])new Class[0]);
        this.legacyCreateMethod = ReflectionUtil.getMethod((String)"io.github.prospector.modmenu.api.ConfigScreenFactory", (String)"create", (Class[])new Class[]{class_437.class});
        this.legacyGetModConfigScreenFactoryMethod = ReflectionUtil.getMethod(this.legacyModMenuApiClass, (String)"getModConfigScreenFactory", (Class[])new Class[0]);
    }

    @ApiStatus.Internal
    public void init() {
        if (this.initialized.get()) {
            throw new IllegalStateException("Re-trigger initialize.");
        }
        if (!MagicLib.getInstance().getCurrentPlatform().isModLoaded("modmenu")) {
            return;
        }
        class_310 client = class_310.method_1551();
        FabricLoader.getInstance().getEntrypointContainers("modmenu", Object.class).forEach(entrypoint -> {
            ModMetadata metadata = entrypoint.getProvider().getMetadata();
            try {
                ModMenuApiCompat.ConfigScreenFactoryCompat configScreenFactoryCompat;
                Object api = entrypoint.getEntrypoint();
                if (this.modMenuApiClass.isPresent() && ((Class)this.modMenuApiClass.get()).isAssignableFrom(api.getClass()) && this.getModConfigScreenFactoryMethod.isPresent() && this.createMethod.isPresent()) {
                    Object modConfigScreenFactory = ((Method)this.getModConfigScreenFactoryMethod.get()).invoke(api, new Object[0]);
                    configScreenFactoryCompat = screen -> {
                        try {
                            return (class_437)((Method)this.createMethod.get()).invoke(modConfigScreenFactory, screen);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    };
                } else if (this.legacyModMenuApiClass.isPresent() && ((Class)this.legacyModMenuApiClass.get()).isAssignableFrom(api.getClass())) {
                    if (this.legacyGetModConfigScreenFactoryMethod.isPresent()) {
                        Object legacyModConfigScreenFactory = ((Method)this.legacyGetModConfigScreenFactoryMethod.get()).invoke(api, new Object[0]);
                        configScreenFactoryCompat = screen -> {
                            try {
                                return (class_437)((Method)this.legacyCreateMethod.get()).invoke(legacyModConfigScreenFactory, screen);
                            }
                            catch (IllegalAccessException | InvocationTargetException e) {
                                throw new RuntimeException(e);
                            }
                        };
                    } else {
                        Function f = (Function)MiscUtil.cast((Object)((Method)this.legacyGetConfigScreenFactory.get()).invoke(api, new Object[0]));
                        configScreenFactoryCompat = f::apply;
                    }
                } else {
                    SharedConstants.getLogger().error("Mod {} provides a unknown type {} of ModMenuApi", (Object)metadata.getId(), api.getClass());
                    return;
                }
                class_437 screen2 = configScreenFactoryCompat.create(client.field_1755);
                if (!(screen2 instanceof GuiConfigsBase)) {
                    return;
                }
                String modName = metadata.getName();
                if (!this.guiClass.containsKey(screen2.getClass())) {
                    this.guiModName.put((Object)configScreenFactoryCompat, () -> modName);
                    this.guiClass.put(screen2.getClass(), configScreenFactoryCompat);
                } else {
                    ModMenuApiCompat.ConfigScreenFactoryCompat<?> savedConfigScreenFactoryCompat = this.guiClass.get(screen2.getClass());
                    String savedName = ((IStringValue)this.guiModName.get(savedConfigScreenFactoryCompat)).getStringValue();
                    if (savedName.length() > modName.length()) {
                        this.guiModName.put(savedConfigScreenFactoryCompat, () -> modName);
                    }
                }
            }
            catch (Throwable e) {
                SharedConstants.getLogger().error("Mod {} provides a broken implementation of ModMenuApi", (Object)metadata.getId(), (Object)e);
            }
        });
        this.initialized.set(true);
    }

    public List<IStringValue> getModNameList() {
        return this.guiModName.values().stream().sorted(Comparator.comparing(IStringValue::getStringValue)).collect(Collectors.toList());
    }

    public IStringValue getModName(Class<?> clazz) {
        return this.getModName(this.getConfigScreenFactory(clazz));
    }

    public IStringValue getModName(ModMenuApiCompat.ConfigScreenFactoryCompat<?> configScreenFactory) {
        return (IStringValue)this.guiModName.get(configScreenFactory);
    }

    public ModMenuApiCompat.ConfigScreenFactoryCompat<?> getConfigScreenFactory(Class<?> clazz) {
        return this.guiClass.get(clazz);
    }

    public ModMenuApiCompat.ConfigScreenFactoryCompat<?> getConfigScreenFactory(IStringValue modName) {
        return (ModMenuApiCompat.ConfigScreenFactoryCompat)this.guiModName.inverse().get((Object)modName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static FastMasaGuiSwitcher getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    FastMasaGuiSwitcher actualValue = new FastMasaGuiSwitcher();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (FastMasaGuiSwitcher)($value == instance ? null : $value);
    }
}

