/*
 * Decompiled with CFR 0.152.
 */
package com.plusls.MasaGadget.game;

import com.google.common.collect.ImmutableList;
import com.plusls.MasaGadget.SharedConstants;
import com.plusls.MasaGadget.game.ConfigGui;
import com.plusls.MasaGadget.util.PcaSyncProtocol;
import com.plusls.MasaGadget.util.SearchMobSpawnPointUtil;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.api.dependency.annotation.CompositeDependencies;
import top.hendrixshen.magiclib.api.dependency.annotation.Dependencies;
import top.hendrixshen.magiclib.api.dependency.annotation.Dependency;
import top.hendrixshen.magiclib.api.malilib.annotation.Config;
import top.hendrixshen.magiclib.api.malilib.config.MagicConfigManager;
import top.hendrixshen.magiclib.impl.malilib.config.MagicConfigFactory;
import top.hendrixshen.magiclib.impl.malilib.config.gui.MagicConfigGui;
import top.hendrixshen.magiclib.impl.malilib.config.option.MagicConfigBoolean;
import top.hendrixshen.magiclib.impl.malilib.config.option.MagicConfigBooleanHotkeyed;
import top.hendrixshen.magiclib.impl.malilib.config.option.MagicConfigColor;
import top.hendrixshen.magiclib.impl.malilib.config.option.MagicConfigDouble;
import top.hendrixshen.magiclib.impl.malilib.config.option.MagicConfigHotkey;
import top.hendrixshen.magiclib.impl.malilib.config.option.MagicConfigStringList;
import top.hendrixshen.magiclib.util.minecraft.ComponentUtil;
import top.hendrixshen.magiclib.util.minecraft.InfoUtil;

public class Configs {
    private static final MagicConfigManager cm = SharedConstants.getConfigManager();
    private static final MagicConfigFactory cf = cm.getConfigFactory();
    @Config(category="generic")
    public static MagicConfigBoolean autoSyncEntityData = cf.newConfigBoolean("autoSyncEntityData", false);
    @Config(category="generic")
    public static MagicConfigBoolean cacheContainerMenu = cf.newConfigBoolean("cacheContainerMenu", true);
    @Config(category="generic")
    public static MagicConfigBoolean debug = cf.newConfigBoolean("debug", false);
    @Config(category="generic")
    public static MagicConfigHotkey openConfigGui = cf.newConfigHotkey("openConfigGui", "G,C");
    @Config(category="generic")
    public static MagicConfigBooleanHotkeyed renderNextRestockTime = cf.newConfigBooleanHotkeyed("renderNextRestockTime", false);
    @Config(category="generic")
    public static MagicConfigBooleanHotkeyed renderTradeEnchantedBook = cf.newConfigBooleanHotkeyed("renderTradeEnchantedBook", false);
    @Config(category="generic")
    public static MagicConfigBooleanHotkeyed renderVillageHomeTracer = cf.newConfigBooleanHotkeyed("renderVillageHomeTracer", false);
    @Config(category="generic")
    public static MagicConfigColor renderVillageHomeTracerColor = cf.newConfigColor("renderVillageHomeTracerColor", "#500000FF");
    @Config(category="generic")
    public static MagicConfigBooleanHotkeyed renderVillageJobSiteTracer = cf.newConfigBooleanHotkeyed("renderVillageJobSiteTracer", false);
    @Config(category="generic")
    public static MagicConfigColor renderVillageJobSiteTracerColor = cf.newConfigColor("renderVillageJobSiteTracerColor", "#5000FF00");
    @Config(category="generic")
    public static MagicConfigBooleanHotkeyed renderZombieVillagerConvertTime = cf.newConfigBooleanHotkeyed("renderZombieVillagerConvertTime", false);
    @Dependencies(require={@Dependency(value="minihud")})
    @Config(category="generic")
    public static MagicConfigHotkey searchMobSpawnPoint = cf.newConfigHotkey("searchMobSpawnPoint");
    @Dependencies(require={@Dependency(value="minihud")})
    @Config(category="generic")
    public static MagicConfigStringList searchMobSpawnPointBlackList = cf.newConfigStringList("searchMobSpawnPointBlackList", ImmutableList.of());
    @Config(category="generic")
    public static MagicConfigHotkey syncAllEntityData = cf.newConfigHotkey("syncAllEntityData");
    @Dependencies(require={@Dependency(value="litematica")})
    @Config(category="litematica")
    public static MagicConfigBooleanHotkeyed betterEasyPlaceMode = cf.newConfigBooleanHotkeyed("betterEasyPlaceMode", false);
    @Dependencies(require={@Dependency(value="litematica")})
    @Config(category="litematica")
    public static MagicConfigBooleanHotkeyed disableLitematicaEasyPlaceFailTip = cf.newConfigBooleanHotkeyed("disableLitematicaEasyPlaceFailTip", false);
    @Dependencies(require={@Dependency(value="litematica")})
    @Config(category="litematica")
    public static MagicConfigBooleanHotkeyed fixAccurateProtocol = cf.newConfigBooleanHotkeyed("fixAccurateProtocol", false);
    @Dependencies(require={@Dependency(value="litematica", versionPredicates={"<0.0.0-dev.20210917.192300"}), @Dependency(value="tweakeroo")})
    @Config(category="litematica")
    public static MagicConfigBoolean nudgeSelectionSupportFreeCamera = cf.newConfigBoolean("nudgeSelectionSupportFreeCamera", false);
    @Dependencies(require={@Dependency(value="litematica")})
    @Config(category="litematica")
    public static MagicConfigBoolean saveInventoryToSchematicInServer = cf.newConfigBoolean("saveInventoryToSchematicInServer", false);
    @Dependencies(require={@Dependency(value="litematica")})
    @Config(category="litematica")
    public static MagicConfigBoolean useRelativePath = cf.newConfigBoolean("useRelativePath", false);
    @CompositeDependencies(value={@Dependencies(require={@Dependency(value="malilib", versionPredicates={"<0.11.0"})}), @Dependencies(require={@Dependency(value="minihud", versionPredicates={"<0.20.0"})}), @Dependencies(require={@Dependency(value="tweakeroo", versionPredicates={"<0.11.1"})})})
    @Config(category="malilib")
    public static MagicConfigBoolean backportI18nSupport = cf.newConfigBoolean("backportI18nSupport", false);
    @Dependencies(require={@Dependency(value="modmenu")})
    @Config(category="malilib")
    public static MagicConfigBoolean fastSwitchMasaConfigGui = cf.newConfigBoolean("fastSwitchMasaConfigGui", false);
    @Config(category="malilib")
    public static MagicConfigBooleanHotkeyed favoritesSupport = cf.newConfigBooleanHotkeyed("favoritesSupport", false);
    @Dependencies(require={@Dependency(value="malilib")})
    @Config(category="malilib")
    public static MagicConfigBoolean fixConfigWidgetWidth = cf.newConfigBoolean("fixConfigWidgetWidth", false);
    @Dependencies(require={@Dependency(value="malilib")})
    @Config(category="malilib")
    public static MagicConfigBoolean fixConfigWidgetWidthExpand = cf.newConfigBoolean("fixConfigWidgetWidthExpand", false);
    @Dependencies(require={@Dependency(value="malilib", versionPredicates={"<0.11.0"})})
    @Config(category="malilib")
    public static MagicConfigBoolean fixGetInventoryType = cf.newConfigBoolean("fixGetInventoryType", false);
    @Dependencies(require={@Dependency(value="malilib", versionPredicates={"<0.11.6"})})
    @Config(category="malilib")
    public static MagicConfigBoolean fixSearchbarHotkeyInput = cf.newConfigBoolean("fixSearchbarHotkeyInput", false);
    @Dependencies(require={@Dependency(value="malilib", versionPredicates={"<0.11.0"})})
    @Config(category="malilib")
    public static MagicConfigBoolean optimizeConfigWidgetSearch = cf.newConfigBoolean("optimizeConfigWidgetSearch", false);
    @Config(category="malilib")
    public static MagicConfigBoolean showOriginalConfigName = cf.newConfigBoolean("showOriginalConfigName", false);
    @Config(category="malilib")
    public static MagicConfigDouble showOriginalConfigNameScale = cf.newConfigDouble("showOriginalConfigNameScale", 0.65, 0.0, 2.0);
    @Dependencies(require={@Dependency(value="minihud")})
    @Config(category="minihud")
    public static MagicConfigBoolean minihudI18n = cf.newConfigBoolean("minihudI18n", false);
    @Dependencies(require={@Dependency(value="minihud"), @Dependency(value="tweakeroo"), @Dependency(value="minecraft", versionPredicates={">1.14.4"})})
    @Config(category="minihud")
    public static MagicConfigBoolean pcaSyncProtocolSyncBeehive = cf.newConfigBoolean("pcaSyncProtocolSyncBeehive", false);
    @Dependencies(require={@Dependency(value="tweakeroo")})
    @Config(category="tweakeroo")
    public static MagicConfigBoolean inventoryPreviewSupportComparator = cf.newConfigBoolean("inventoryPreviewSupportComparator", false);
    @Dependencies(require={@Dependency(value="tweakeroo")})
    @Config(category="tweakeroo")
    public static MagicConfigBoolean inventoryPreviewSupportPlayer = cf.newConfigBoolean("inventoryPreviewSupportPlayer", false);
    @Dependencies(require={@Dependency(value="tweakeroo")})
    @Config(category="tweakeroo")
    public static MagicConfigBoolean inventoryPreviewSupportSelect = cf.newConfigBoolean("inventoryPreviewSupportSelect", false);
    @Dependencies(require={@Dependency(value="tweakeroo")})
    @Config(category="tweakeroo")
    public static MagicConfigBoolean inventoryPreviewSupportShulkerBoxItemEntity = cf.newConfigBoolean("inventoryPreviewSupportShulkerBoxItemEntity", false);
    @Dependencies(require={@Dependency(value="tweakeroo")})
    @Config(category="tweakeroo")
    public static MagicConfigBoolean inventoryPreviewSupportTradeOfferList = cf.newConfigBoolean("inventoryPreviewSupportTradeOfferList", false);
    @Dependencies(require={@Dependency(value="tweakeroo")})
    @Config(category="tweakeroo")
    public static MagicConfigBoolean inventoryPreviewSyncData = cf.newConfigBoolean("inventoryPreviewSyncData", false);
    @Dependencies(require={@Dependency(value="tweakeroo")})
    @Config(category="tweakeroo")
    public static MagicConfigBoolean inventoryPreviewSyncDataClientOnly = cf.newConfigBoolean("inventoryPreviewSyncDataClientOnly", false);
    @Dependencies(require={@Dependency(value="tweakeroo")})
    @Config(category="tweakeroo")
    public static MagicConfigBoolean inventoryPreviewUseCache = cf.newConfigBoolean("inventoryPreviewUseCache", false);
    @Dependencies(require={@Dependency(value="tweakeroo"), @Dependency(value="tweakeroo")})
    @Config(category="tweakeroo")
    public static MagicConfigBoolean restockWithCrafting = cf.newConfigBoolean("restockWithCrafting", false);
    @Dependencies(require={@Dependency(value="tweakeroo"), @Dependency(value="itemscroller")})
    @Config(category="tweakeroo")
    public static MagicConfigStringList restockWithCraftingRecipes = cf.newConfigStringList("restockWithCraftingRecipes", ImmutableList.of());

    public static void init() {
        cm.parseConfigClass(Configs.class);
        MagicConfigManager.setHotkeyCallback((MagicConfigHotkey)openConfigGui, ConfigGui::openGui, (boolean)true);
        searchMobSpawnPoint.getKeybind().setCallback((keyAction, iKeybind) -> {
            if (MagicLib.getInstance().getCurrentPlatform().isModLoaded("minihud")) {
                SearchMobSpawnPointUtil.search();
            }
            return true;
        });
        syncAllEntityData.getKeybind().setCallback((keyAction, iKeybind) -> {
            if (!PcaSyncProtocol.enable) {
                return true;
            }
            class_310 mc = class_310.method_1551();
            for (class_1297 entity : Objects.requireNonNull(mc.field_1687).method_18112()) {
                PcaSyncProtocol.syncEntity(entity.method_5628());
            }
            InfoUtil.displayChatMessage((class_2561)ComponentUtil.tr((String)"masa_gadget_mod.message.syncAllEntityDataSuccess", (Object[])new Object[0]).withStyle(new class_124[]{class_124.field_1060}).get());
            return true;
        });
        favoritesSupport.setValueChangeCallback(Configs::redrawConfigGui);
        showOriginalConfigName.setValueChangeCallback(Configs::redrawConfigGui);
        showOriginalConfigNameScale.setValueChangeCallback(Configs::redrawConfigGui);
    }

    private static void redrawConfigGui(Object object) {
        ConfigGui.getCurrentInstance().ifPresent(MagicConfigGui::reDraw);
    }

    public static class ConfigCategory {
        public static final String GENERIC = "generic";
        public static final String LITEMATICA = "litematica";
        public static final String MALILIB = "malilib";
        public static final String MINIHUD = "minihud";
        public static final String TWEAKEROO = "tweakeroo";
    }
}

