/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.classicminecrafticon;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import me.fallenbreath.classicminecrafticon.ClassicMinecraftIconMod;
import net.minecraft.class_7367;
import org.apache.commons.io.IOUtils;

public class ClassicMinecraftIconStorage {
    private static final String RESOURCES_ROOT = "assets/classicminecrafticon/icons/";
    private static final Map<String, byte[]> STORAGE = Maps.newLinkedHashMap();
    private static final List<String> PNG_PATHS = Lists.newArrayList();
    private static boolean inited = false;

    public static synchronized void init() {
        if (inited) {
            return;
        }
        ClassicMinecraftIconStorage.loadResource("icon_16x16.png", true);
        ClassicMinecraftIconStorage.loadResource("icon_32x32.png", true);
        ClassicMinecraftIconStorage.loadResource("icon_48x48.png", true);
        ClassicMinecraftIconStorage.loadResource("icon_128x128.png", true);
        ClassicMinecraftIconStorage.loadResource("icon_256x256.png", true);
        ClassicMinecraftIconStorage.loadResource("minecraft.icns", false);
        ClassicMinecraftIconMod.LOGGER.info("{} initialized", (Object)ClassicMinecraftIconStorage.class.getSimpleName());
        inited = true;
    }

    private static void loadResource(String path, boolean isPng) {
        String fullPath = RESOURCES_ROOT + path;
        ClassLoader classLoader = ClassicMinecraftIconStorage.class.getClassLoader();
        try (InputStream stream = classLoader.getResourceAsStream(fullPath);){
            if (stream == null) {
                throw new IOException("getResourceAsStream failed");
            }
            byte[] data = IOUtils.toByteArray((InputStream)stream);
            STORAGE.put(path, data);
            if (isPng) {
                PNG_PATHS.add(path);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to load resource %s: %s", fullPath, e));
        }
    }

    public static class_7367<InputStream> getResource(String path) {
        ClassicMinecraftIconStorage.init();
        byte[] data = STORAGE.get(path);
        if (data == null) {
            throw new RuntimeException("Unexpected resource path " + path);
        }
        return () -> new ByteArrayInputStream(data);
    }

    public static List<class_7367<InputStream>> getAllPngResources() {
        ClassicMinecraftIconStorage.init();
        return PNG_PATHS.stream().map(ClassicMinecraftIconStorage::getResource).toList();
    }
}

