/*
 * Decompiled with CFR 0.152.
 */
package fr.loxoz.csearcher.gui.layout;

import fr.loxoz.csearcher.gui.layout.Padding;
import java.util.function.Consumer;

public class LayoutRect {
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected Padding padding = new Padding();

    public LayoutRect() {
        this(0, 0, 0, 0);
    }

    public LayoutRect(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public Padding getPadding() {
        return this.padding;
    }

    public LayoutRect withPadding(Consumer<Padding> consumer) {
        consumer.accept(this.padding);
        return this;
    }

    public int x() {
        return this.x;
    }

    public void setX(int n) {
        this.x = n;
    }

    public int y() {
        return this.y;
    }

    public void setY(int n) {
        this.y = n;
    }

    public int width() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setInnerWidth(int n) {
        this.setWidth(n + this.padding.left + this.padding.right);
    }

    public int height() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void setInnerHeight(int n) {
        this.setHeight(n + this.padding.top + this.padding.bottom);
    }

    public int innerX() {
        return this.x() + this.getPadding().left;
    }

    public int innerY() {
        return this.y() + this.getPadding().top;
    }

    public int innerWidth() {
        return Math.max(0, this.width - this.getPadding().left - this.getPadding().right);
    }

    public int innerHeight() {
        return Math.max(0, this.height - this.getPadding().top - this.getPadding().bottom);
    }

    public void setPos(int n, int n2) {
        this.setX(n);
        this.setY(n2);
    }

    public void setSize(int n, int n2) {
        this.setWidth(n);
        this.setHeight(n2);
    }

    public void centerIn(int n, int n2) {
        this.setPos((n - this.width()) / 2, (n2 - this.height()) / 2);
    }

    public boolean contains(int n, int n2) {
        return n >= this.x() && n <= this.x() + this.width() && n2 >= this.y() && n2 <= this.y() + this.height();
    }
}

