/*
 * Decompiled with CFR 0.152.
 */
package fr.loxoz.csearcher.gui;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import fr.loxoz.csearcher.CSearcher;
import fr.loxoz.csearcher.compat.CText;
import fr.loxoz.csearcher.config.CSConfig;
import fr.loxoz.csearcher.config.CSConfig$DistanceMode;
import fr.loxoz.csearcher.config.CSConfig$SortMode;
import fr.loxoz.csearcher.core.CacheEntry;
import fr.loxoz.csearcher.core.CachedStack;
import fr.loxoz.csearcher.core.Container;
import fr.loxoz.csearcher.gui.ContainerEntry;
import fr.loxoz.csearcher.gui.WorldOptionsScreen;
import fr.loxoz.csearcher.gui.layout.LayoutRect;
import fr.loxoz.csearcher.gui.util.GuiUtils;
import fr.loxoz.csearcher.gui.util.ScalableSlot;
import fr.loxoz.csearcher.gui.widget.ClearableTextFieldWidget;
import fr.loxoz.csearcher.gui.widget.EnumButtonWidget;
import fr.loxoz.csearcher.gui.widget.EnumSliderWidget;
import fr.loxoz.csearcher.gui.widget.ScrollableContainerWidget;
import fr.loxoz.csearcher.gui.widget.TexturedEnumButtonWidget;
import fr.loxoz.csearcher.gui.widget.UVTexturedButtonWidget;
import fr.loxoz.csearcher.util.StrFormatting;
import fr.loxoz.csearcher.util.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3544;
import net.minecraft.class_364;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.apache.commons.lang3.StringUtils;

public class SearchScreen
extends class_437 {
    public static final class_2960 GUI_TEXTURE = class_2960.method_60655((String)"csearcher", (String)"textures/gui/search_menu.png");
    public static final class_2960 DIMENSION_CURRENT = class_2960.method_60655((String)"csearcher", (String)"current");
    public static final class_2960 DIMENSION_ALL = class_2960.method_60655((String)"csearcher", (String)"all");
    public static int GAP_SM = 4;
    public static int GAP_MD = 8;
    public static int SLOT_GAP = GAP_SM;
    public static int HOVER_COLOR = 0x30FFFFFF;
    public static int MAX_GUI_WIDTH = 600;
    public static int GUI_MARGIN_SMALL = 8;
    public static int GUI_MARGIN_LARGE = 32;
    public static int SCREEN_SMALL_SIZE = 400;
    public static String lastSearch = "";
    private final List<class_2960> a = new ArrayList<class_2960>();
    private boolean b = true;
    protected final LayoutRect layout = new LayoutRect().withPadding(padding -> padding.set(12, GAP_MD));
    protected class_342 search = null;
    protected class_4286 lookCheck = null;
    protected EnumButtonWidget<class_2960> dimFilter = null;
    protected TexturedEnumButtonWidget<CSConfig$SortMode> sortModeBtn = null;
    protected EnumSliderWidget<CSConfig$DistanceMode> distSlider = null;
    protected ScrollableContainerWidget scrollable;
    protected List<ContainerEntry> visibleEntries = new ArrayList<ContainerEntry>();
    protected ContainerEntry hoveredEntry = null;

    public static class_2561 getDimFilterText(class_2960 class_29602) {
        if (class_29602.method_12836().equals("csearcher")) {
            return CText.translatable("text.csearcher.dim_filter." + class_29602.method_12832());
        }
        return CText.literal(Utils.idToString(class_29602));
    }

    public SearchScreen() {
        super((class_2561)CText.translatable("gui.csearcher.search.title"));
    }

    private CSConfig a() {
        return CSearcher.getConfig();
    }

    private int a(int n) {
        return n <= SCREEN_SMALL_SIZE ? GUI_MARGIN_SMALL : GUI_MARGIN_LARGE;
    }

    protected void method_25426() {
        Objects.requireNonNull(this.field_22787);
        this.layout.setWidth(Math.min(MAX_GUI_WIDTH, this.field_22789 - this.a(this.field_22789) * 2));
        this.layout.setHeight(this.field_22790 - this.a(this.field_22790) * 2);
        this.layout.centerIn(this.field_22789, this.field_22790);
        int n = this.layout.innerY();
        Objects.requireNonNull(this.field_22793);
        int n2 = n + 9 + 4;
        int n3 = Math.min(this.layout.innerWidth() - 4 * (20 + GAP_SM), 300);
        if (this.search == null) {
            this.search = new ClearableTextFieldWidget(this.field_22793, 0, 0, 0, 20, (class_2561)CText.translatable("gui.csearcher.search.search"));
            this.search.method_1863(this::a);
        }
        this.search.method_48229(this.layout.innerX() + (this.layout.innerWidth() - n3) / 2, n2);
        this.search.method_25358(n3);
        this.method_37063((class_364)this.search);
        if (this.sortModeBtn == null) {
            this.sortModeBtn = new TexturedEnumButtonWidget<CSConfig$SortMode>(0, 0, 20, 20, CSConfig$SortMode.values(), this.a().sortMode, cSConfig$SortMode -> CText.translatable("gui.csearcher.search.sort_mode", CText.translatable("text.csearcher.sort_modes." + cSConfig$SortMode.name())), GUI_TEXTURE, 0, 40, 256, 256);
        }
        this.sortModeBtn.method_48229(this.search.method_46426() - 4 - this.sortModeBtn.method_25368(), n2);
        this.method_37063((class_364)this.sortModeBtn);
        UVTexturedButtonWidget uVTexturedButtonWidget = (UVTexturedButtonWidget)this.method_37063((class_364)GuiUtils.withAutoTooltip(new UVTexturedButtonWidget(this.search.method_46426() + this.search.method_25368() + GAP_SM, n2, 20, 20, 0, 0, 20, GUI_TEXTURE, 256, 256, class_41852 -> this.field_22787.method_1507(CSConfig.getConfigScreen(this)), (class_2561)CText.translatable("config.csearcher.title"))));
        this.method_37063((class_364)GuiUtils.withAutoTooltip(new UVTexturedButtonWidget(uVTexturedButtonWidget.method_46426() + uVTexturedButtonWidget.method_25368() + GAP_SM, n2, 20, 20, 20, 0, 20, GUI_TEXTURE, 256, 256, class_41852 -> this.field_22787.method_1507((class_437)new WorldOptionsScreen(this)), (class_2561)CText.translatable("gui.csearcher.world_options.title"))));
        n2 += 20 + GAP_MD;
        if (this.scrollable == null) {
            this.scrollable = new ScrollableContainerWidget(0, 0, 0, 0).withPadding(padding -> padding.set(SLOT_GAP));
            this.scrollable.scrollbarBg = 0x66000000;
        }
        this.scrollable.method_48229(this.layout.innerX(), n2);
        int n4 = this.layout.innerY() + this.layout.innerHeight() - (20 + GAP_MD) - this.scrollable.method_46427();
        this.scrollable.setSize(this.layout.innerWidth(), n4);
        this.method_37063((class_364)this.scrollable);
        if (this.dimFilter == null) {
            this.dimFilter = new EnumButtonWidget<class_2960>(0, 0, 140, 20, this.a, DIMENSION_CURRENT, class_29602 -> CText.translatable("gui.csearcher.search.dimension_mode", SearchScreen.getDimFilterText(class_29602))).onChange(class_29602 -> this.updateSlots());
        }
        this.dimFilter.method_48229(this.layout.innerX(), this.layout.innerY() + this.layout.innerHeight() - this.dimFilter.method_25364());
        this.method_37063((class_364)this.dimFilter);
        if (this.distSlider == null) {
            this.distSlider = new EnumSliderWidget<CSConfig$DistanceMode>(0, 0, 150, 20, CSConfig$DistanceMode.values(), this.a().distanceMode, cSConfig$DistanceMode -> CText.translatable("gui.csearcher.search.search_distance", CText.translatable("text.csearcher.modes." + cSConfig$DistanceMode.name())));
        }
        this.distSlider.method_48229(this.dimFilter.method_46426() + this.dimFilter.method_25368() + GAP_SM, this.layout.innerY() + this.layout.innerHeight() - this.distSlider.method_25364());
        this.method_37063((class_364)this.distSlider);
        if (this.lookCheck == null) {
            this.lookCheck = class_4286.method_54787((class_2561)CText.translatable("gui.csearcher.search.look_target"), (class_327)this.field_22793).method_54794(this.a().lookAtTarget).method_54788();
        }
        this.lookCheck.method_48229(this.distSlider.method_46426() + this.distSlider.method_25368() + GAP_SM, this.layout.innerY() + this.layout.innerHeight() - this.lookCheck.method_25364() - 2);
        this.method_37063((class_364)this.lookCheck);
        this.populateDimensionsFilter();
        if (this.b) {
            if (!lastSearch.isBlank()) {
                this.search.method_1852(lastSearch);
                this.search.method_1872(false);
                this.search.method_1884(0);
            }
            if (this.a().autoFocusSearch) {
                this.method_48265((class_364)this.search);
            }
            this.b = false;
            this.updateSlots();
        } else {
            this.updateSlotsPosSize();
        }
    }

    private void a(String string) {
        lastSearch = this.search.method_1882();
        this.updateSlots();
    }

    protected String getItemNaming(class_1792 class_17922) {
        return class_1074.method_4662((String)class_17922.method_7876(), (Object[])new Object[0]);
    }

    private String b(String string) {
        return string.toLowerCase(Locale.ROOT);
    }

    protected boolean stackSearch(CachedStack cachedStack, String string) {
        String string2 = this.b(string.trim());
        if (cachedStack.display != null && this.b(cachedStack.display.getString()).contains(string2)) {
            return true;
        }
        if (this.b(cachedStack.asStack().method_7964().getString()).contains(string2)) {
            return true;
        }
        if (this.b(this.getItemNaming(cachedStack.method_8389())).contains(string2)) {
            return true;
        }
        if (this.a().searchInsideBE && cachedStack.contents != null) {
            for (CachedStack cachedStack2 : cachedStack.contents) {
                if (!this.stackSearch(cachedStack2, string)) continue;
                return true;
            }
        }
        return false;
    }

    protected void populateDimensionsFilter() {
        this.a.clear();
        this.a.addAll(List.of(DIMENSION_CURRENT));
        this.a.addAll(List.of(DIMENSION_ALL));
        CacheEntry cacheEntry = CSearcher.inst().getCache().current();
        if (cacheEntry == null || cacheEntry.isDisabled()) {
            return;
        }
        HashSet<class_2960> hashSet = new HashSet<class_2960>();
        for (Container container : cacheEntry.containers.values()) {
            hashSet.add(container.getDimId());
        }
        this.a.addAll(hashSet);
    }

    protected boolean isContainerShown(Container container) {
        Object object;
        if (!this.dimFilter.getValue().equals((Object)DIMENSION_ALL)) {
            object = this.dimFilter.getValue();
            if (object == DIMENSION_CURRENT) {
                object = this.field_22787.field_1687.method_27983().method_29177();
            }
            if (!container.isIn((class_2960)object)) {
                return false;
            }
        }
        return (object = this.distSlider.getEnumValue()) == CSConfig$DistanceMode.NONE || !(this.getDist(container) > (double)((CSConfig$DistanceMode)((Object)object)).getBlocks());
    }

    protected void updateSlots() {
        this.visibleEntries.clear();
        CacheEntry cacheEntry = CSearcher.inst().getCache().current();
        if (cacheEntry == null || cacheEntry.isDisabled()) {
            return;
        }
        for (Container container : cacheEntry.containers.values()) {
            if (!this.isContainerShown(container)) continue;
            for (CachedStack cachedStack : container.getFlattenContent()) {
                if (!this.search.method_1882().isBlank() && !this.stackSearch(cachedStack, this.search.method_1882())) continue;
                ContainerEntry containerEntry = ContainerEntry.create(container, cachedStack);
                containerEntry.getSlot().withPadding(padding -> padding.set(2));
                this.visibleEntries.add(containerEntry);
            }
        }
        this.sortSlots();
        this.updateSlotsPosSize();
    }

    protected void updateSlotsPosSize() {
        int n = this.scrollable.getInnerX();
        int n2 = this.scrollable.getInnerY();
        for (ContainerEntry containerEntry : this.visibleEntries) {
            ScalableSlot scalableSlot = containerEntry.getSlot();
            scalableSlot.setScale(this.field_22789 > 600 ? 1.4 : 1.2);
            scalableSlot.setPos(n, n2);
            n = scalableSlot.getX() + scalableSlot.getWidth() + SLOT_GAP;
            if (n + scalableSlot.getWidth() <= this.scrollable.getInnerX() + this.scrollable.getInnerWidth()) continue;
            n = this.scrollable.getInnerX();
            n2 = scalableSlot.getY() + scalableSlot.getHeight() + SLOT_GAP;
        }
    }

    protected void sortSlots() {
        CSConfig$SortMode cSConfig$SortMode = this.a().sortMode;
        this.visibleEntries.sort((containerEntry, containerEntry2) -> {
            int n = (int)this.getDist(containerEntry.getContainer()) - (int)this.getDist(containerEntry2.getContainer());
            int n2 = containerEntry2.getStack().method_7947() - containerEntry.getStack().method_7947();
            int n3 = String.CASE_INSENSITIVE_ORDER.compare(this.getItemNaming(containerEntry.getStack().method_7909()), this.getItemNaming(containerEntry2.getStack().method_7909()));
            return switch (cSConfig$SortMode) {
                default -> throw new IncompatibleClassChangeError();
                case CSConfig$SortMode.NAME -> {
                    if (n3 == 0) {
                        yield n;
                    }
                    yield n3;
                }
                case CSConfig$SortMode.COUNT -> {
                    if (n2 == 0) {
                        yield n3;
                    }
                    yield n2;
                }
                case CSConfig$SortMode.DISTANCE -> n == 0 ? n3 : n;
            };
        });
    }

    public void method_25393() {
        if (this.lookCheck.method_20372() != this.a().lookAtTarget) {
            this.a().lookAtTarget = this.lookCheck.method_20372();
            CSConfig.save();
        }
        if (this.distSlider.getEnumValue() != this.a().distanceMode) {
            this.a().distanceMode = this.distSlider.getEnumValue();
            this.updateSlots();
            CSConfig.save();
        }
        if (this.sortModeBtn.getValue() != this.a().sortMode) {
            this.a().sortMode = (CSConfig$SortMode)((Object)this.sortModeBtn.getValue());
            this.updateSlots();
            CSConfig.save();
        }
        this.lookCheck.field_22764 = this.field_22789 > 480;
    }

    public void method_25420(class_332 class_3322, int n, int n2, float f) {
        super.method_25420(class_3322, n, n2, f);
        class_3322.method_25294(this.layout.x(), this.layout.y(), this.layout.x() + this.layout.width(), this.layout.y() + this.layout.height(), -2146825718);
        class_3322.method_27534(this.field_22793, this.field_22785, this.layout.innerX() + this.layout.innerWidth() / 2, this.layout.innerY(), -1);
    }

    public void method_25394(class_332 class_3322, int n, int n2, float f) {
        Object object;
        ContainerEntry containerEntry = this.hoveredEntry;
        this.hoveredEntry = null;
        super.method_25394(class_3322, n, n2, f);
        GuiUtils.drawOutline(class_3322, this.scrollable.method_46426() - 1, this.scrollable.method_46427() - 1, this.scrollable.method_46426() + this.scrollable.method_25368() + 1, this.scrollable.method_46427() + this.scrollable.method_25364() + 1, 0xDFFFFFF);
        int n3 = 0;
        class_3322.method_51448().method_22903();
        this.scrollable.enableContentScissor(class_3322);
        this.scrollable.applyTranslate(class_3322.method_51448(), false);
        for (ContainerEntry object22 : this.visibleEntries) {
            object = object22.getSlot();
            int n4 = ((ScalableSlot)object).getY() - this.scrollable.getInnerY() + ((ScalableSlot)object).getHeight();
            if (n4 > n3) {
                n3 = n4;
            }
            if (!this.scrollable.isElementVisible(((ScalableSlot)object).getY(), ((ScalableSlot)object).getY() + ((ScalableSlot)object).getHeight())) continue;
            boolean bl = n2 > this.scrollable.method_46427() && n2 < this.scrollable.method_46427() + this.scrollable.getInnerHeight() && ((ScalableSlot)object).isMouseInside(n, (int)((double)n2 + this.scrollable.getScrollY()));
            class_3322.method_25294(((ScalableSlot)object).getX(), ((ScalableSlot)object).getY(), ((ScalableSlot)object).getX() + ((ScalableSlot)object).getWidth(), ((ScalableSlot)object).getY() + ((ScalableSlot)object).getHeight(), 0x30BBBBBB);
            ((ScalableSlot)object).render(class_3322, this.field_22793, this.field_22787);
            if (bl) {
                class_3322.method_51448().method_22903();
                class_3322.method_51448().method_46416(0.0f, 0.0f, 200.0f);
                class_3322.method_25294(((ScalableSlot)object).getX(), ((ScalableSlot)object).getY(), ((ScalableSlot)object).getX() + ((ScalableSlot)object).getWidth(), ((ScalableSlot)object).getY() + ((ScalableSlot)object).getHeight(), HOVER_COLOR);
                GuiUtils.drawOutline(class_3322, ((ScalableSlot)object).getX(), ((ScalableSlot)object).getY(), ((ScalableSlot)object).getX() + ((ScalableSlot)object).getWidth(), ((ScalableSlot)object).getY() + ((ScalableSlot)object).getHeight(), -1);
                class_3322.method_51448().method_22909();
                this.hoveredEntry = object22;
                continue;
            }
            if (!SearchScreen.method_25442() || containerEntry == null || containerEntry.getContainer() != object22.getContainer()) continue;
            GuiUtils.drawOutline(class_3322, ((ScalableSlot)object).getX(), ((ScalableSlot)object).getY(), ((ScalableSlot)object).getX() + ((ScalableSlot)object).getWidth(), ((ScalableSlot)object).getY() + ((ScalableSlot)object).getHeight(), 0x66FFFFFF);
        }
        this.scrollable.setContentHeight(n3);
        class_3322.method_44380();
        class_3322.method_51448().method_22909();
        class_5250 class_52502 = null;
        CacheEntry cacheEntry = CSearcher.inst().getCache().current();
        if (cacheEntry != null && !cacheEntry.isDisabled()) {
            object = cacheEntry.containers;
            if (this.visibleEntries.size() < 1 && object.size() < 1) {
                class_52502 = CText.translatable("gui.csearcher.search.nothing");
            }
        } else if (cacheEntry != null && cacheEntry.isDisabled() || CSearcher.inst().getCache().isCurrentBlacklisted()) {
            class_52502 = CText.translatable("gui.csearcher.search.disabled");
        }
        if (class_52502 != null) {
            class_3322.method_27534(this.field_22793, (class_2561)class_52502, this.scrollable.getInnerX() + this.scrollable.getInnerWidth() / 2, this.scrollable.method_46427() + 8, 0x40FFFFFF);
        }
        if (this.hoveredEntry != null) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
            class_3322.method_51437(this.field_22793, this.getEntryTooltip(this.hoveredEntry), this.hoveredEntry.getStack().method_32347(), n, n2);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public boolean method_25402(double d, double d2, int n) {
        if (n == 0 && this.hoveredEntry != null) {
            this.method_25419();
            if (!this.hoveredEntry.getContainer().isIn((class_1937)this.field_22787.field_1687)) {
                Utils.postMessage((class_2561)CText.translatable("text.csearcher.wrong_dimension").method_27692(class_124.field_1080));
                return true;
            }
            boolean bl = CSearcher.inst().targetContainedStack(this.field_22787, this.hoveredEntry.asContained());
            if ((this.a().automation.sendOnClickIfNear || !bl) && SearchScreen.method_25441()) {
                this.sendHovered();
            }
            return true;
        }
        if (super.method_25402(d, d2, n)) {
            return true;
        }
        this.method_25395(null);
        return false;
    }

    protected void sendHovered() {
        String string = this.a().automation.sendOnClick;
        if (string == null) {
            return;
        }
        if ((string = string.trim()).isEmpty()) {
            return;
        }
        class_2338 class_23382 = this.hoveredEntry.getContainer().getPos();
        ImmutableMap immutableMap = ImmutableMap.builder().put((Object)"x", (Object)("" + class_23382.method_10263())).put((Object)"y", (Object)("" + class_23382.method_10264())).put((Object)"z", (Object)("" + class_23382.method_10260())).put((Object)"item", (Object)class_7923.field_41178.method_10221((Object)this.hoveredEntry.getStack().method_7909()).toString()).build();
        for (Map.Entry entry : immutableMap.entrySet()) {
            string = string.replaceAll("\\{\\{" + (String)entry.getKey() + "}}", (String)entry.getValue());
        }
        String string2 = class_3544.method_43681((String)StringUtils.normalizeSpace((String)string));
        if (!string2.isBlank() && this.field_22787.field_1724 != null) {
            if (string2.startsWith("/")) {
                this.field_22787.field_1724.field_3944.method_45731(string2.substring(1));
            } else {
                this.field_22787.field_1724.field_3944.method_45729(string2);
            }
        }
    }

    public boolean method_25404(int n, int n2, int n3) {
        if (super.method_25404(n, n2, n3)) {
            return true;
        }
        if (CSearcher.inst().keySearchMenu.method_1417(n, n2) && !this.search.method_25370()) {
            this.method_25419();
            return true;
        }
        return false;
    }

    public boolean method_25421() {
        return false;
    }

    public List<class_2561> getEntryTooltip(ContainerEntry containerEntry) {
        boolean bl;
        Long l;
        List list = SearchScreen.method_25408((class_310)Objects.requireNonNull(this.field_22787), (class_1799)containerEntry.getStack());
        Container container = containerEntry.getContainer();
        class_124 class_1242 = class_124.field_1080;
        list.add(CText.translatable("gui.csearcher.search.entry_info.container_type", container.getBlock().method_9518().method_27692(class_124.field_1067)).method_27692(class_1242));
        list.add(CText.translatable("gui.csearcher.search.entry_info.distance", class_2561.method_43470((String)StrFormatting.distance.format(this.getDist(container))).method_27692(class_124.field_1067)).method_27692(class_1242));
        if (!this.a().streamerMode) {
            list.add(CText.translatable("gui.csearcher.search.entry_info.at", container.getPos().method_23854(), Utils.idToString(container.getDimId())).method_27692(class_1242));
        }
        if ((l = container.getTime()) != null) {
            list.add(CText.translatable("gui.csearcher.search.entry_info.time_ago", Utils.millisToStr(System.currentTimeMillis() - l)).method_27692(class_1242));
        }
        if (bl = container.isFull()) {
            list.add(CText.translatable("gui.csearcher.search.entry_info.full").method_27692(class_1242).method_27692(class_124.field_1056));
        }
        list.add(CText.empty());
        list.add(CText.translatable("gui.csearcher.search.entry_info.click_to_show").method_27692(class_124.field_1063));
        list.add(CText.translatable("gui.csearcher.search.entry_info.shift_info").method_27692(class_124.field_1063));
        if (this.a().automation.sendOnClick != null && !this.a().automation.sendOnClick.isBlank()) {
            list.add(CText.translatable("gui.csearcher.search.entry_info.ctrl_send").method_27692(class_124.field_1063));
        }
        return list;
    }

    public double getDist(Container container) {
        class_243 class_2432 = Objects.requireNonNull(this.field_22787).field_1724 != null ? this.field_22787.field_1724.method_19538() : class_243.field_1353;
        return container.distanceTo(class_2432);
    }
}

