/*
 * Decompiled with CFR 0.152.
 */
package fr.loxoz.csearcher.file;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import fr.loxoz.csearcher.core.CachedStack;
import fr.loxoz.csearcher.file.GameProfileSerializer;
import fr.loxoz.csearcher.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class StackSerializer {
    private static final Gson a = new GsonBuilder().disableHtmlEscaping().registerTypeHierarchyAdapter(class_2561.class, (Object)new class_2561.class_8822((class_7225.class_7874)class_5455.field_40585)).create();

    public static JsonElement serialize(CachedStack cachedStack) {
        JsonObject jsonObject;
        JsonArray jsonArray = new JsonArray();
        jsonArray.add(Utils.idToString(class_7923.field_41178.method_10221((Object)cachedStack.method_8389())));
        if (cachedStack.getCount() != 1) {
            jsonArray.add((Number)cachedStack.getCount());
        }
        JsonObject jsonObject2 = new JsonObject();
        if (cachedStack.display != null) {
            jsonObject2.add("disp", a.toJsonTree((Object)cachedStack.display));
        }
        if (cachedStack.enchants != null) {
            jsonObject = new JsonObject();
            for (class_2960 class_29602 : cachedStack.enchants.keySet()) {
                jsonObject.addProperty(Utils.idToString(class_29602), (Number)cachedStack.enchants.get(class_29602));
            }
            jsonObject2.add("enchs", (JsonElement)jsonObject);
        }
        if (cachedStack.hasCustomModel()) {
            jsonObject2.addProperty("model", (Number)cachedStack.customModel);
        }
        if (cachedStack.skullProfile != null) {
            jsonObject2.add("skull", GameProfileSerializer.serialize(cachedStack.skullProfile));
        }
        if (cachedStack.contents != null) {
            jsonObject = new JsonArray();
            cachedStack.contents.forEach(arg_0 -> StackSerializer.a((JsonArray)jsonObject, arg_0));
            jsonObject2.add("be_items", (JsonElement)jsonObject);
        }
        if (!jsonObject2.isEmpty()) {
            jsonArray.add((JsonElement)jsonObject2);
        }
        return jsonArray;
    }

    public static CachedStack deserialize(JsonElement jsonElement) throws JsonParseException {
        JsonArray jsonArray;
        if (jsonElement instanceof JsonArray && !(jsonArray = (JsonArray)jsonElement).isEmpty()) {
            int n;
            Optional optional = class_7923.field_41178.method_17966(class_2960.method_60654((String)jsonArray.get(0).getAsString()));
            boolean bl = jsonArray.size() > 1 && jsonArray.get(1) instanceof JsonObject;
            int n2 = n = jsonArray.size() > 1 && !bl ? jsonArray.get(1).getAsInt() : 1;
            if (optional.isPresent()) {
                JsonElement jsonElement2;
                CachedStack cachedStack = new CachedStack((class_1792)optional.get(), n);
                if (jsonArray.size() > (bl ? 1 : 2) && (jsonElement2 = jsonArray.get(bl ? 1 : 2)) instanceof JsonObject) {
                    Object object;
                    JsonObject jsonObject = (JsonObject)jsonElement2;
                    if (jsonObject.has("disp")) {
                        cachedStack.display = (class_2561)a.fromJson(jsonObject.get("disp"), class_2561.class);
                    }
                    if (jsonObject.has("model")) {
                        cachedStack.customModel = jsonObject.get("model").getAsInt();
                    }
                    if (jsonObject.has("enchs")) {
                        object = jsonObject.get("enchs");
                        if (object instanceof JsonObject) {
                            jsonElement2 = (JsonObject)object;
                            for (String string : jsonElement2.keySet()) {
                                if (cachedStack.enchants == null) {
                                    cachedStack.enchants = new HashMap<class_2960, Integer>();
                                }
                                cachedStack.enchants.put(class_2960.method_60654((String)string), jsonElement2.get(string).getAsInt());
                            }
                        } else {
                            throw new JsonParseException("invalid CachedStack at enchants");
                        }
                    }
                    if (jsonObject.has("skull")) {
                        cachedStack.skullProfile = GameProfileSerializer.deserialize(jsonObject.get("skull"));
                    }
                    if (jsonObject.has("be_items")) {
                        object = jsonObject.get("be_items");
                        if (object instanceof JsonArray) {
                            jsonElement2 = (JsonArray)object;
                            for (String string : jsonElement2) {
                                if (cachedStack.contents == null) {
                                    cachedStack.contents = new ArrayList<CachedStack>();
                                }
                                cachedStack.contents.add(StackSerializer.deserialize((JsonElement)string));
                            }
                        } else {
                            throw new JsonParseException("invalid CachedStack at block entity content");
                        }
                    }
                }
                return cachedStack;
            }
        }
        throw new JsonParseException("invalid CachedStack");
    }

    private static /* synthetic */ void a(JsonArray jsonArray, CachedStack cachedStack) {
        jsonArray.add(StackSerializer.serialize(cachedStack));
    }
}

