/*
 * Decompiled with CFR 0.152.
 */
package fr.loxoz.csearcher.file;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.UUID;
import net.minecraft.class_156;
import net.minecraft.class_3544;

public class GameProfileSerializer {
    public static JsonElement serialize(GameProfile gameProfile) {
        JsonObject jsonObject = new JsonObject();
        if (!class_3544.method_15438((String)gameProfile.getName())) {
            jsonObject.addProperty("Name", gameProfile.getName());
        }
        if (gameProfile.getId() != null) {
            jsonObject.addProperty("Id", gameProfile.getId().toString());
        }
        if (!gameProfile.getProperties().isEmpty()) {
            JsonObject jsonObject2 = new JsonObject();
            for (String string : gameProfile.getProperties().keySet()) {
                JsonArray jsonArray = new JsonArray();
                for (Property property : gameProfile.getProperties().get((Object)string)) {
                    JsonObject jsonObject3 = new JsonObject();
                    jsonObject3.addProperty("Value", property.value());
                    if (property.hasSignature()) {
                        jsonObject3.addProperty("Signature", property.signature());
                    }
                    jsonArray.add((JsonElement)jsonObject3);
                }
                jsonObject2.add(string, (JsonElement)jsonArray);
            }
            jsonObject.add("Properties", (JsonElement)jsonObject2);
        }
        return jsonObject;
    }

    public static GameProfile deserialize(JsonElement jsonElement) throws JsonParseException {
        if (jsonElement instanceof JsonObject) {
            Object object;
            JsonObject jsonObject = (JsonObject)jsonElement;
            String string = "null";
            UUID uUID = class_156.field_25140;
            if (jsonObject.has("Name")) {
                string = jsonObject.get("Name").getAsString();
            }
            if (jsonObject.has("Id")) {
                uUID = UUID.fromString(jsonObject.get("Id").getAsString());
            }
            GameProfile gameProfile = new GameProfile(uUID, string);
            if (jsonObject.has("Properties") && (object = jsonObject.get("Properties")) instanceof JsonObject) {
                JsonObject jsonObject2 = (JsonObject)object;
                for (String string2 : jsonObject2.keySet()) {
                    JsonElement jsonElement2 = jsonObject2.get(string2);
                    if (!(jsonElement2 instanceof JsonArray)) continue;
                    JsonArray jsonArray = (JsonArray)jsonElement2;
                    for (JsonElement jsonElement3 : jsonArray) {
                        if (!(jsonElement3 instanceof JsonObject)) continue;
                        JsonObject jsonObject3 = (JsonObject)jsonElement3;
                        String string3 = jsonObject3.get("Value").getAsString();
                        Property property = jsonObject3.has("Signature") ? new Property(string2, string3, jsonObject3.get("Signature").getAsString()) : new Property(string2, string3);
                        gameProfile.getProperties().put((Object)string2, (Object)property);
                    }
                }
            }
            return gameProfile;
        }
        throw new JsonParseException("valid cache entry object expected");
    }
}

