/*
 * Decompiled with CFR 0.152.
 */
package fr.loxoz.csearcher.file;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import fr.loxoz.csearcher.core.CachedStack;
import fr.loxoz.csearcher.core.Container;
import fr.loxoz.csearcher.file.BlockPosSerializer;
import fr.loxoz.csearcher.file.StackSerializer;
import fr.loxoz.csearcher.util.Utils;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class ContainerSerializer {
    public static JsonElement serialize(Container container) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("dim", Utils.idToString(container.getDimId()));
        jsonObject.addProperty("block", Utils.idToString(class_7923.field_41175.method_10221((Object)container.getBlock())));
        jsonObject.add("pos", BlockPosSerializer.serialize(container.getPos()));
        JsonArray jsonArray = new JsonArray();
        for (CachedStack cachedStack : container.getContent()) {
            jsonArray.add(StackSerializer.serialize(cachedStack));
        }
        jsonObject.add("content", (JsonElement)jsonArray);
        jsonObject.addProperty("time", (Number)container.getTime());
        jsonObject.addProperty("full", Boolean.valueOf(container.isFull()));
        return jsonObject;
    }

    public static Container deserialize(JsonElement jsonElement) throws JsonParseException {
        if (jsonElement instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonElement;
            JsonElement jsonElement2 = jsonObject.get("dim");
            JsonElement jsonElement3 = jsonObject.get("block");
            JsonElement jsonElement4 = jsonObject.get("pos");
            JsonElement jsonElement5 = jsonObject.get("content");
            JsonElement jsonElement6 = jsonObject.get("time");
            JsonElement jsonElement7 = jsonObject.get("full");
            try {
                if (jsonElement3 != null && jsonElement4 != null && jsonElement5 instanceof JsonArray) {
                    boolean bl;
                    JsonArray jsonArray = (JsonArray)jsonElement5;
                    class_2960 class_29602 = class_2960.method_60654((String)jsonElement2.getAsString());
                    Optional optional = class_7923.field_41175.method_17966(class_2960.method_60654((String)jsonElement3.getAsString()));
                    Long l = jsonElement6 != null ? Long.valueOf(jsonElement6.getAsLong()) : null;
                    boolean bl2 = bl = jsonElement7 != null && jsonElement7.getAsBoolean();
                    if (optional.isPresent()) {
                        class_2248 class_22482 = (class_2248)optional.get();
                        class_2338 class_23382 = BlockPosSerializer.deserialize(jsonElement4);
                        ArrayList<CachedStack> arrayList = new ArrayList<CachedStack>();
                        for (JsonElement jsonElement8 : jsonArray) {
                            arrayList.add(StackSerializer.deserialize(jsonElement8));
                        }
                        return new Container(class_22482, class_29602, class_23382, arrayList, l, bl);
                    }
                    throw new JsonParseException("block id not found");
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            throw new JsonParseException("invalid Container object");
        }
        throw new JsonParseException("expected object");
    }
}

