/*
 * Decompiled with CFR 0.152.
 */
package fr.loxoz.csearcher.file;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import fr.loxoz.csearcher.core.CacheEntry;
import fr.loxoz.csearcher.core.Container;
import fr.loxoz.csearcher.file.CSMigrations;
import fr.loxoz.csearcher.file.ContainerListSerializer;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class CacheEntrySerializer {
    public static final int VERSION = 1;
    public static final String KEY_VERSION = "ver";

    public static JsonElement serialize(Collection<Container> collection) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(KEY_VERSION, (Number)1);
        jsonObject.add("data", ContainerListSerializer.serialize(collection));
        return jsonObject;
    }

    public static Collection<Container> deserialize(JsonElement jsonElement, CacheEntry cacheEntry) throws JsonParseException {
        if (!(jsonElement instanceof JsonObject)) {
            throw new JsonParseException("valid cache entry object expected");
        }
        JsonObject jsonObject = (JsonObject)jsonElement;
        Integer n = CacheEntrySerializer.getVersionOf(jsonObject);
        JsonElement jsonElement2 = jsonElement;
        if (n == null || n != 1) {
            cacheEntry.makeBackup();
            jsonElement2 = CSMigrations.migrate((JsonElement)jsonObject);
        }
        if (!(jsonElement2 instanceof JsonObject)) {
            throw new JsonParseException("valid cache entry object expected");
        }
        JsonObject jsonObject2 = (JsonObject)jsonElement2;
        return ContainerListSerializer.deserialize(jsonObject2.get("data"));
    }

    @Nullable
    public static Integer getVersionOf(JsonObject jsonObject) {
        JsonPrimitive jsonPrimitive;
        JsonElement jsonElement = jsonObject.get(KEY_VERSION);
        if (jsonElement instanceof JsonPrimitive && (jsonPrimitive = (JsonPrimitive)jsonElement).isNumber()) {
            return jsonPrimitive.getAsInt();
        }
        return null;
    }
}

