/*
 * Decompiled with CFR 0.152.
 */
package fr.loxoz.csearcher.core;

import com.mojang.blaze3d.systems.RenderSystem;
import fr.loxoz.csearcher.CSearcher;
import fr.loxoz.csearcher.core.CachedStack;
import fr.loxoz.csearcher.core.FocusedStack;
import fr.loxoz.csearcher.core.VisualsManager$BlockBlinker;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1735;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_465;
import net.minecraft.class_757;
import net.minecraft.class_9801;

public class VisualsManager {
    public static int COLOR_UNFOCUSED = 0x20000000;
    public static int COLOR_FOCUSED = -2130706433;
    public final List<VisualsManager$BlockBlinker> blockBlinkers = new ArrayList<VisualsManager$BlockBlinker>();
    public final List<FocusedStack> focusedStacks = new ArrayList<FocusedStack>();
    private int a = -1;

    public void tick(class_310 class_3102) {
        if (class_3102.field_1687 == null || class_3102.method_1493()) {
            return;
        }
        ++this.a;
        if (this.a >= 20) {
            this.focusedStacks.removeIf(FocusedStack::hasTimedOut);
            this.a = 0;
        }
    }

    public void renderWorld(WorldRenderContext worldRenderContext) {
        if (this.blockBlinkers.isEmpty()) {
            return;
        }
        class_4587 class_45872 = Objects.requireNonNull(worldRenderContext.matrixStack());
        RenderSystem.setShader(class_757::method_34535);
        RenderSystem.lineWidth((float)4.0f);
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        class_287 class_2872 = class_289.method_1348().method_60827(class_293.class_5596.field_27377, class_290.field_29337);
        class_243 class_2432 = worldRenderContext.camera().method_19326();
        class_45872.method_22903();
        class_45872.method_22904(-class_2432.method_10216(), -class_2432.method_10214(), -class_2432.method_10215());
        class_9801 class_98012 = this.blockBlinkers.iterator();
        while (class_98012.hasNext()) {
            VisualsManager$BlockBlinker visualsManager$BlockBlinker = class_98012.next();
            if (visualsManager$BlockBlinker.isDone()) {
                class_98012.remove();
                continue;
            }
            visualsManager$BlockBlinker.render(class_45872, (class_4588)class_2872, worldRenderContext.camera());
        }
        class_45872.method_22909();
        class_98012 = class_2872.method_60794();
        if (class_98012 != null) {
            class_286.method_43433((class_9801)class_98012);
        }
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
    }

    public void blinkBlock(class_2338 class_23382) {
        this.blockBlinkers.add(new VisualsManager$BlockBlinker(class_23382, CSearcher.getConfig().minBlinkAmount, 500L));
    }

    public void focusStack(CachedStack cachedStack) {
        this.focusedStacks.add(new FocusedStack(cachedStack));
    }

    public void drawSparksLine(class_243 class_2432, class_243 class_2433, class_1937 class_19372) {
        double d = class_2432.method_1022(class_2433);
        int n = (int)d;
        for (int i = 0; i < n; ++i) {
            double d2 = class_3532.method_16436((double)((double)i / (double)n), (double)class_2432.field_1352, (double)class_2433.field_1352);
            double d3 = class_3532.method_16436((double)((double)i / (double)n), (double)class_2432.field_1351, (double)class_2433.field_1351);
            double d4 = class_3532.method_16436((double)((double)i / (double)n), (double)class_2432.field_1350, (double)class_2433.field_1350);
            class_19372.method_8406((class_2394)class_2398.field_11207, d2, d3, d4, 0.0, 0.0, 0.0);
        }
    }

    public void drawSlotHighlight(class_332 class_3322, class_1735 class_17352, class_465<?> class_4652, boolean bl) {
        if (this.focusedStacks.size() < 1 || CSearcher.shouldIgnoreSlot(class_17352, class_4652)) {
            return;
        }
        CachedStack cachedStack = CachedStack.of(class_17352.method_7677());
        boolean bl2 = false;
        for (FocusedStack focusedStack : this.focusedStacks) {
            if (!focusedStack.getStack().isSameAs(cachedStack, CSearcher.getConfig().focusedSlotMatchStrict)) continue;
            focusedStack.setSeen(true);
            bl2 = true;
        }
        if (!bl2 && CSearcher.getConfig().darkenUnfocusedSlots || bl2 && CSearcher.getConfig().highlightFocusedSlots) {
            class_3322.method_51448().method_22903();
            if (!bl) {
                class_3322.method_51448().method_22904(0.0, 0.0, 300.0);
            }
            if (!bl2 && CSearcher.getConfig().darkenUnfocusedSlots) {
                class_3322.method_25294(class_17352.field_7873 - 1, class_17352.field_7872 - 1, class_17352.field_7873 + 17, class_17352.field_7872 + 17, COLOR_UNFOCUSED);
            }
            if (bl2 && CSearcher.getConfig().highlightFocusedSlots && bl) {
                class_3322.method_25294(class_17352.field_7873, class_17352.field_7872, class_17352.field_7873 + 16, class_17352.field_7872 + 16, COLOR_FOCUSED);
            }
            class_3322.method_51448().method_22909();
        }
    }
}

