/*
 * Decompiled with CFR 0.152.
 */
package fr.loxoz.csearcher.core;

import fr.loxoz.csearcher.CSearcher;
import fr.loxoz.csearcher.core.CacheEntry;
import fr.loxoz.csearcher.core.FileResult;
import fr.loxoz.csearcher.file.FileUtils;
import java.io.File;
import java.util.Objects;
import net.minecraft.class_310;
import net.minecraft.class_642;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class CacheManager {
    protected CacheEntry entry = null;
    protected File folder;

    public CacheManager(File file) {
        this.folder = file;
    }

    public static String getCurrentCacheName() {
        class_642 class_6422;
        class_310 class_3102 = class_310.method_1551();
        if (class_3102.method_1542()) {
            return FileUtils.sanitizeFilename(Objects.requireNonNull(class_3102.method_1576()).method_27728().method_150());
        }
        if (class_3102.field_1687 != null && (class_6422 = class_3102.method_1558()) != null) {
            String string = class_6422.method_52811() ? "Realms" : "MP";
            String string2 = class_6422.method_52811() ? class_6422.field_3752 : class_6422.field_3761;
            return string + "_" + FileUtils.sanitizeFilename(string2);
        }
        return null;
    }

    @Nullable
    @Contract(pure=true)
    public CacheEntry current() {
        return this.entry;
    }

    public FileResult createLoadCurrent() {
        String string = CacheManager.getCurrentCacheName();
        if (string == null) {
            return FileResult.N_EXISTS;
        }
        return this.createLoad(string);
    }

    public FileResult createLoad(String string) {
        if (string == null) {
            this.unload();
            return FileResult.ERROR;
        }
        if (this.entry == null) {
            this.entry = this.createEntryFor(string);
        }
        if (!this.entry.isDisabled()) {
            return this.entry.load();
        }
        return FileResult.NO_CHANGES;
    }

    public FileResult save() {
        CacheEntry cacheEntry = this.current();
        if (cacheEntry != null && !cacheEntry.isDisabled()) {
            return cacheEntry.save();
        }
        return FileResult.NO_CHANGES;
    }

    public CacheEntry createEntryFor(String string) {
        return new CacheEntry(string, this.folder);
    }

    public void unload() {
        this.entry = null;
    }

    public FileResult saveUnload() {
        FileResult fileResult = this.save();
        this.unload();
        return fileResult;
    }

    public boolean isBlacklisted(String string) {
        return CSearcher.getConfig().sensitive.getBlacklistedTrimmed().contains(string);
    }

    public boolean isCurrentBlacklisted() {
        return this.isBlacklisted(CacheManager.getCurrentCacheName());
    }
}

