/*
 * Decompiled with CFR 0.152.
 */
package fr.loxoz.csearcher.core;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import fr.loxoz.csearcher.CSearcher;
import fr.loxoz.csearcher.core.Container;
import fr.loxoz.csearcher.core.FileResult;
import fr.loxoz.csearcher.file.CacheEntrySerializer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2338;

public class CacheEntry {
    public final Map<class_2338, Container> containers = new HashMap<class_2338, Container>();
    private final String a;
    private final File b;
    protected long lastSave;
    private final Gson c;

    public CacheEntry(String string, File file) {
        this.a = string;
        this.b = file;
        this.c = new Gson();
        this.lastSave = System.currentTimeMillis();
    }

    public boolean isDisabled() {
        return CSearcher.getConfig().sensitive.getBlacklistedTrimmed().contains(this.getName());
    }

    public String getName() {
        return this.a;
    }

    public File getFile() {
        return new File(this.b, this.getName() + ".json");
    }

    public long getLastSave() {
        return this.lastSave;
    }

    public FileResult makeBackup() {
        File file = this.getFile();
        if (!file.exists()) {
            return FileResult.NO_CHANGES;
        }
        try {
            LocalDateTime localDateTime = LocalDateTime.now();
            String string = this.getName() + String.format("_backup_%s_%s_%s_%s_%s_%s.json", localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond());
            Files.copy(file.toPath(), new File(this.b, string).toPath(), StandardCopyOption.REPLACE_EXISTING);
            CSearcher.inst().getLogger().info("Created backup file " + string);
            return FileResult.SUCCESS;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            CSearcher.inst().getLogger().warn("Failed to make backup");
            return FileResult.ERROR;
        }
    }

    public FileResult load() {
        File file = this.getFile();
        if (!file.exists()) {
            return FileResult.N_EXISTS;
        }
        try {
            BufferedReader bufferedReader = Files.newBufferedReader(file.toPath());
            JsonElement jsonElement = (JsonElement)this.c.fromJson((Reader)bufferedReader, JsonElement.class);
            bufferedReader.close();
            Collection<Container> collection = CacheEntrySerializer.deserialize(jsonElement, this);
            this.containers.clear();
            for (Container container : collection) {
                this.containers.put(container.getPos(), container);
            }
            CSearcher.inst().getLogger().debug("Cache loaded from " + this.getName());
            return FileResult.SUCCESS;
        }
        catch (Exception exception) {
            CSearcher.inst().getLogger().error("Error while reading cache:", (Throwable)exception);
            this.makeBackup();
            return FileResult.ERROR;
        }
    }

    public FileResult save() {
        if (CSearcher.getConfig().disableCacheSaving) {
            return FileResult.NO_CHANGES;
        }
        File file = this.getFile();
        if (this.containers.size() < 1) {
            if (file.exists() && file.delete()) {
                CSearcher.inst().getLogger().debug("Previous cache file deleted ");
            }
            this.lastSave = System.currentTimeMillis();
            return FileResult.SUCCESS;
        }
        file.getParentFile().mkdirs();
        try {
            BufferedWriter bufferedWriter = Files.newBufferedWriter(file.toPath(), new OpenOption[0]);
            JsonElement jsonElement = CacheEntrySerializer.serialize(this.containers.values());
            this.c.toJson(jsonElement, (Appendable)bufferedWriter);
            bufferedWriter.close();
            CSearcher.inst().getLogger().debug("Cache saved for " + this.getName());
            this.lastSave = System.currentTimeMillis();
            return FileResult.SUCCESS;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return FileResult.ERROR;
        }
    }

    public void clear() {
        this.containers.clear();
    }
}

