/*
 * Decompiled with CFR 0.152.
 */
package fr.loxoz.csearcher;

import fr.loxoz.csearcher.compat.CText;
import fr.loxoz.csearcher.config.CSConfig;
import fr.loxoz.csearcher.config.CSConfig$DistanceMode;
import fr.loxoz.csearcher.core.CSMixinListener;
import fr.loxoz.csearcher.core.CacheEntry;
import fr.loxoz.csearcher.core.CacheManager;
import fr.loxoz.csearcher.core.CachedStack;
import fr.loxoz.csearcher.core.ContainedStack;
import fr.loxoz.csearcher.core.Container;
import fr.loxoz.csearcher.core.InteractionHolder;
import fr.loxoz.csearcher.core.VisualsManager;
import fr.loxoz.csearcher.gui.SearchScreen;
import fr.loxoz.csearcher.util.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1729;
import net.minecraft.class_1731;
import net.minecraft.class_1734;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2336;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_8566;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class CSearcher
implements ClientModInitializer {
    public static final String MOD_ID = "csearcher";
    public static int INTERACTION_MAX_TIME = 500;
    public static int NON_SMALL_CONTAINER = 9;
    private static CSearcher a = null;
    private static CSConfig b = null;
    private final Logger c = LogManager.getLogger(CSearcher.class);
    private final CSMixinListener d;
    private final VisualsManager e;
    private CacheManager f = null;
    public class_304 keySearchMenu;
    public class_304 keySearchInNearContainers;
    public InteractionHolder lastInteract = null;
    private long g = 0L;
    private long h = 0L;

    public CSearcher() {
        a = this;
        this.d = new CSMixinListener(this);
        this.e = new VisualsManager();
    }

    public static CSearcher inst() {
        return a;
    }

    public void onInitializeClient() {
        this.keySearchMenu = CSearcher.a("search_menu", 325);
        this.keySearchInNearContainers = CSearcher.a("search_in_near_container", 89);
        b = (CSConfig)AutoConfig.register(CSConfig.class, GsonConfigSerializer::new).getConfig();
        this.f = new CacheManager(new File(FabricLoader.getInstance().getGameDir().toString(), "csearcher_cache"));
        ClientTickEvents.END_CLIENT_TICK.register(this::a);
        ClientPlayConnectionEvents.JOIN.register((class_6342, packetSender, class_3102) -> {
            if (this.getCache().createLoadCurrent().hasError()) {
                class_3102.field_1705.method_1743().method_1812((class_2561)CText.translatable("text.csearcher.entry_load_failed"));
            }
        });
        ClientPlayConnectionEvents.DISCONNECT.register((class_6342, class_3102) -> this.getCache().saveUnload());
        ClientLifecycleEvents.CLIENT_STOPPING.register(class_3102 -> this.getCache().saveUnload());
        WorldRenderEvents.AFTER_TRANSLUCENT.register(this.e::renderWorld);
    }

    public static CSConfig getConfig() {
        return b;
    }

    public Logger getLogger() {
        return this.c;
    }

    public CacheManager getCache() {
        return this.f;
    }

    public CSMixinListener getMixinListener() {
        return this.d;
    }

    public VisualsManager getVisualsManager() {
        return this.e;
    }

    private void a(class_310 class_3102) {
        this.e.tick(class_3102);
        if (class_3102.field_1687 == null || class_3102.method_1493()) {
            return;
        }
        CacheEntry cacheEntry = this.getCache().current();
        if (cacheEntry != null && !cacheEntry.isDisabled()) {
            long l;
            if (CSearcher.getConfig().enableAutoCleanup && System.currentTimeMillis() - this.g > (long)CSearcher.getConfig().cleanupInterval * 1000L && !cacheEntry.containers.isEmpty()) {
                this.runCleanupTask(class_3102.field_1687);
            }
            if ((l = System.currentTimeMillis()) - cacheEntry.getLastSave() > CSearcher.getConfig().saveInterval.get() && l - this.h > Math.min(CSearcher.getConfig().saveInterval.get() / 4L, 1000L)) {
                cacheEntry.save();
                this.h = l;
            }
        }
        while (this.keySearchMenu.method_1436()) {
            class_3102.method_1507((class_437)new SearchScreen());
            if (cacheEntry != null) continue;
            this.a();
        }
        if (CSearcher.getConfig().searchNearForHeld && class_3102.field_1724 != null) {
            while (this.keySearchInNearContainers.method_1436()) {
                this.searchNearStackAndOpen(class_3102, CachedStack.of(class_3102.field_1724.method_6047()), cacheEntry, CSearcher.getConfig().searchNearIgnoreFull);
            }
        }
    }

    public void runCleanupTask(class_638 class_6382) {
        this.g = System.currentTimeMillis();
        new Thread(() -> this.runCleanup(class_6382), "ContainerSearcher cleanup thread").start();
    }

    protected void runCleanup(class_638 class_6382) {
        CacheEntry cacheEntry = this.getCache().current();
        if (cacheEntry == null) {
            return;
        }
        Iterator<Container> iterator = cacheEntry.containers.values().iterator();
        while (iterator.hasNext()) {
            class_2680 class_26802;
            Container container = iterator.next();
            if (!CSearcher.isValidContainer(container.getBlock())) {
                iterator.remove();
                continue;
            }
            if (!container.isIn((class_1937)class_6382) || !class_6382.method_2935().method_12123(class_4076.method_18675((int)container.getPos().method_10263()), class_4076.method_18675((int)container.getPos().method_10260())) || (class_26802 = class_6382.method_8320(container.getPos())).method_27852(container.getBlock())) continue;
            iterator.remove();
            this.c.debug("Container at " + container.getPos().method_23854() + " was removed (now has " + cacheEntry.containers.size() + " cached containers)");
        }
    }

    public void handleContainerScreenUpdate(class_1703 class_17032, InteractionHolder interactionHolder, boolean bl) {
        if (interactionHolder == null) {
            return;
        }
        if (!bl && System.currentTimeMillis() - interactionHolder.getTime() > (long)INTERACTION_MAX_TIME) {
            return;
        }
        if (!(interactionHolder.getBlockState().method_26204() instanceof class_2237)) {
            return;
        }
        if (class_17032 instanceof class_1729) {
            return;
        }
        ArrayList<class_1799> arrayList = new ArrayList<class_1799>();
        int n = 0;
        int n2 = 0;
        for (class_1735 class_17352 : class_17032.field_7761) {
            if (class_17352.field_7871 instanceof class_1661) continue;
            ++n;
            if (!class_17352.method_7681()) continue;
            arrayList.add(class_17352.method_7677());
            if (class_17352.method_7677().method_7947() < class_17352.method_7677().method_7914()) continue;
            ++n2;
        }
        this.updateCachedContainer(interactionHolder.getWorld(), interactionHolder.getPos(), this.getCache().current(), arrayList, n2 >= n);
    }

    public void updateCachedContainer(@NotNull class_1937 class_19372, @NotNull class_2338 class_23382, CacheEntry cacheEntry, @NotNull List<class_1799> list, boolean bl) {
        Object object;
        class_2680 class_26802;
        Objects.requireNonNull(class_19372);
        Objects.requireNonNull(class_23382);
        Objects.requireNonNull(list);
        if (cacheEntry == null || cacheEntry.isDisabled()) {
            return;
        }
        class_2338 class_23383 = new class_2338((class_2382)class_23382);
        Map<class_2338, Container> map = cacheEntry.containers;
        class_2680 class_26803 = class_19372.method_8320(class_23382);
        if (!CSearcher.isValidContainer(class_26803.method_26204())) {
            map.remove(class_23382);
            return;
        }
        if (class_26803.method_26204() instanceof class_2281 && (class_26802 = class_19372.method_8320((class_2338)(object = class_23382.method_10093(class_2281.method_9758((class_2680)class_26803))))).method_26204() instanceof class_2281 && map.containsKey(object)) {
            class_23382 = object;
            class_26803 = class_26802;
        }
        if ((list = list.stream().filter(class_17992 -> !class_17992.method_7960()).collect(Collectors.toList())).size() < 1) {
            if (!map.containsKey(class_23382)) {
                return;
            }
            map.remove(class_23382);
            this.c.debug("container got removed because there is no content inside at " + class_23382.method_23854() + " (now has " + map.size() + " cached containers)");
            return;
        }
        object = new Container(class_26803.method_26204(), class_19372.method_27983().method_29177(), class_23383, CachedStack.ofList(list), bl);
        if (!class_23383.equals((Object)class_23382)) {
            map.remove(class_23382);
        }
        map.put(((Container)object).getPos(), (Container)object);
        this.c.debug("detected container update content at " + class_23382.method_23854());
    }

    public static boolean shouldIgnoreSlot(class_1735 class_17352, class_465<?> class_4652) {
        return class_4652.method_17577() instanceof class_1723 || class_4652.method_17577() instanceof class_481.class_483 || class_4652.method_17577() instanceof class_1729 || class_17352 instanceof class_1734 || class_17352.field_7871 instanceof class_1661 || class_17352.field_7871 instanceof class_8566 || class_17352.field_7871 instanceof class_1731;
    }

    public static boolean isHandlerIgnored(class_1703 class_17032) {
        return CSearcher.getConfig().ignoreSmallContainers && class_17032.field_7761.stream().filter(class_17352 -> !(class_17352.field_7871 instanceof class_1661)).count() < (long)NON_SMALL_CONTAINER;
    }

    public static boolean isValidContainer(class_2248 class_22482) {
        if (!(class_22482 instanceof class_2237)) {
            return false;
        }
        return !(class_22482 instanceof class_2336);
    }

    public boolean targetContainedStack(class_310 class_3102, ContainedStack containedStack) {
        this.e.focusStack(containedStack.cachedStack());
        class_2338 class_23382 = containedStack.container().getPos();
        class_243 class_2432 = class_243.method_24953((class_2382)class_23382);
        class_746 class_7462 = Objects.requireNonNull(class_3102.field_1724);
        class_243 class_2433 = class_7462.method_5836(0.0f);
        this.e.blinkBlock(class_23382);
        if (CSearcher.getConfig().showDirectionLine) {
            this.e.drawSparksLine(class_2433, class_2432, (class_1937)class_3102.field_1687);
        }
        if (CSearcher.getConfig().lookAtTarget) {
            Utils.lookAt((class_1657)class_7462, class_2432);
        }
        if (CSearcher.getConfig().autoOpenIfNear && class_7462.method_19538().method_1022(class_243.method_24953((class_2382)class_23382)) <= class_3102.field_1724.method_55754()) {
            return Utils.tryInteractBlock(class_3102, class_23382).method_23665();
        }
        return false;
    }

    @Nullable
    public List<ContainedStack> searchNearStack(class_310 class_3102, CachedStack cachedStack, CacheEntry cacheEntry, boolean bl, boolean bl2, boolean bl3) {
        if (class_3102.field_1724 == null) {
            return null;
        }
        if (cacheEntry == null) {
            this.a();
            return null;
        }
        Map<class_2338, Container> map = cacheEntry.containers;
        ArrayList<ContainedStack> arrayList = new ArrayList<ContainedStack>();
        CSConfig$DistanceMode cSConfig$DistanceMode = CSearcher.getConfig().searchNearDistance;
        block0: for (Container container : map.values()) {
            if (!container.isIn((class_1937)class_3102.field_1687) || bl && container.isFull() || cSConfig$DistanceMode != CSConfig$DistanceMode.NONE && container.distanceTo(class_3102.field_1724.method_19538()) > (double)cSConfig$DistanceMode.getBlocks()) continue;
            for (CachedStack cachedStack2 : container.getFlattenContent()) {
                if (!cachedStack2.isSameAs(cachedStack, CSearcher.getConfig().focusedSlotMatchStrict)) continue;
                arrayList.add(new ContainedStack(container, cachedStack2));
                if (!bl3) continue;
                break block0;
            }
        }
        if (!bl2) {
            return arrayList;
        }
        return arrayList.stream().sorted((containedStack, containedStack2) -> {
            class_243 class_2432 = Objects.requireNonNull(class_3102.field_1724).method_19538();
            return (int)containedStack.container().distanceTo(class_2432) - (int)containedStack2.container().distanceTo(class_2432);
        }).collect(Collectors.toList());
    }

    public boolean searchNearStackAndOpen(class_310 class_3102, CachedStack cachedStack, CacheEntry cacheEntry, boolean bl) {
        List<ContainedStack> list = this.searchNearStack(class_3102, cachedStack, cacheEntry, bl, true, false);
        if (list == null) {
            return false;
        }
        if (list.isEmpty()) {
            Utils.postMessage((class_2561)CText.translatable("text.csearcher.no_near_matches"));
            return false;
        }
        if (class_3102.field_1755 != null) {
            class_3102.method_1507(null);
        }
        ContainedStack containedStack = list.get(0);
        this.targetContainedStack(class_3102, containedStack);
        return true;
    }

    private void a() {
        if (this.getCache().current() == null) {
            if (this.getCache().isCurrentBlacklisted()) {
                Utils.postMessage((class_2561)CText.translatable("text.csearcher.blacklisted_entry"));
            } else {
                Utils.postMessage((class_2561)CText.translatable("text.csearcher.no_entry"));
            }
        }
    }

    private static class_304 a(String string, int n) {
        return KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.csearcher." + string, n, "key.categories.csearcher"));
    }
}

