/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.util;

import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.util.CameraEntity;
import net.minecraft.class_1297;
import net.minecraft.class_2806;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_761;

public class CameraUtils {
    private static float cameraYaw;
    private static float cameraPitch;
    private static boolean freeCameraSpectator;

    public static void setFreeCameraSpectator(boolean isSpectator) {
        freeCameraSpectator = isSpectator;
    }

    public static boolean getFreeCameraSpectator() {
        return freeCameraSpectator;
    }

    public static boolean shouldPreventPlayerInputs() {
        return FeatureToggle.TWEAK_FREE_CAMERA.getBooleanValue() && !Configs.Generic.FREE_CAMERA_PLAYER_INPUTS.getBooleanValue();
    }

    public static boolean shouldPreventPlayerMovement() {
        return FeatureToggle.TWEAK_FREE_CAMERA.getBooleanValue() && !Configs.Generic.FREE_CAMERA_PLAYER_MOVEMENT.getBooleanValue();
    }

    public static float getCameraYaw() {
        return class_3532.method_15393((float)cameraYaw);
    }

    public static float getCameraPitch() {
        return class_3532.method_15393((float)cameraPitch);
    }

    public static void setCameraYaw(float yaw) {
        cameraYaw = yaw;
    }

    public static void setCameraPitch(float pitch) {
        cameraPitch = pitch;
    }

    public static void setCameraRotations(float yaw, float pitch) {
        CameraEntity camera = CameraEntity.getCamera();
        if (camera != null) {
            camera.setCameraRotations(yaw, pitch);
        }
    }

    public static void updateCameraRotations(float yawChange, float pitchChange) {
        CameraEntity camera = CameraEntity.getCamera();
        if (camera != null) {
            camera.updateCameraRotations(yawChange, pitchChange);
        }
    }

    public static void markChunksForRebuild(int chunkX, int chunkZ, int lastChunkX, int lastChunkZ) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || chunkX == lastChunkX && chunkZ == lastChunkZ) {
            return;
        }
        int viewDistance = (Integer)mc.field_1690.method_42503().method_41753();
        if (chunkX != lastChunkX) {
            int minCX = chunkX > lastChunkX ? lastChunkX + viewDistance : chunkX - viewDistance;
            int maxCX = chunkX > lastChunkX ? chunkX + viewDistance : lastChunkX - viewDistance;
            for (int cx = minCX; cx <= maxCX; ++cx) {
                for (int cz = chunkZ - viewDistance; cz <= chunkZ + viewDistance; ++cz) {
                    if (!CameraUtils.isClientChunkLoaded(mc.field_1687, cx, cz)) continue;
                    CameraUtils.markChunkForReRender(mc.field_1769, cx, cz);
                }
            }
        }
        if (chunkZ != lastChunkZ) {
            int minCZ = chunkZ > lastChunkZ ? lastChunkZ + viewDistance : chunkZ - viewDistance;
            int maxCZ = chunkZ > lastChunkZ ? chunkZ + viewDistance : lastChunkZ - viewDistance;
            for (int cz = minCZ; cz <= maxCZ; ++cz) {
                for (int cx = chunkX - viewDistance; cx <= chunkX + viewDistance; ++cx) {
                    if (!CameraUtils.isClientChunkLoaded(mc.field_1687, cx, cz)) continue;
                    CameraUtils.markChunkForReRender(mc.field_1769, cx, cz);
                }
            }
        }
    }

    public static void markChunksForRebuildOnDeactivation(int lastChunkX, int lastChunkZ) {
        class_1297 entity = EntityUtils.getCameraEntity();
        class_310 mc = class_310.method_1551();
        int viewDistance = (Integer)mc.field_1690.method_42503().method_41753();
        int chunkX = class_3532.method_15357((double)(entity.method_23317() / 16.0)) >> 4;
        int chunkZ = class_3532.method_15357((double)(entity.method_23321() / 16.0)) >> 4;
        int minCameraCX = lastChunkX - viewDistance;
        int maxCameraCX = lastChunkX + viewDistance;
        int minCameraCZ = lastChunkZ - viewDistance;
        int maxCameraCZ = lastChunkZ + viewDistance;
        int minCX = chunkX - viewDistance;
        int maxCX = chunkX + viewDistance;
        int minCZ = chunkZ - viewDistance;
        int maxCZ = chunkZ + viewDistance;
        for (int cz = minCZ; cz <= maxCZ; ++cz) {
            for (int cx = minCX; cx <= maxCX; ++cx) {
                if (cx >= minCameraCX && cx <= maxCameraCX && cz >= minCameraCZ && cz <= maxCameraCZ || !CameraUtils.isClientChunkLoaded(mc.field_1687, cx, cz)) continue;
                CameraUtils.markChunkForReRender(mc.field_1769, cx, cz);
            }
        }
    }

    public static void markChunkForReRender(class_761 renderer, int chunkX, int chunkZ) {
        for (int cy = 0; cy < 16; ++cy) {
            renderer.method_8571(chunkX, cy, chunkZ);
        }
    }

    public static boolean isClientChunkLoaded(class_638 world, int chunkX, int chunkZ) {
        return world.method_2935().method_2857(chunkX, chunkZ, class_2806.field_12803, false) != null;
    }
}

