/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.data;

import com.mojang.datafixers.util.Either;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.mixin.IMixinDataQueryHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1258;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_300;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_638;
import net.minecraft.class_7225;
import net.minecraft.class_8886;
import net.minecraft.class_8887;
import org.jetbrains.annotations.Nullable;

public class ServerDataSyncer {
    private static ServerDataSyncer INSTANCE;
    private final Map<class_2338, class_3545<class_2586, Long>> blockCache = new HashMap<class_2338, class_3545<class_2586, Long>>();
    private final Map<Integer, class_3545<class_1297, Long>> entityCache = new HashMap<Integer, class_3545<class_1297, Long>>();
    private final Map<Either<class_2338, Integer>, CompletableFuture<@Nullable class_2487>> pendingQueriesByObject = new HashMap<Either<class_2338, Integer>, CompletableFuture<class_2487>>();
    private final Map<Integer, CompletableFuture<@Nullable class_2487>> pendingQueriesById = new HashMap<Integer, CompletableFuture<class_2487>>();
    private final class_638 clientWorld;
    private Optional<Boolean> yesIAmOp = Optional.empty();

    public static ServerDataSyncer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ServerDataSyncer(class_310.method_1551().field_1687);
        }
        return INSTANCE;
    }

    public static void resetInstance() {
        INSTANCE = null;
    }

    public ServerDataSyncer(class_638 world) {
        this.clientWorld = Objects.requireNonNull(world);
    }

    @Nullable
    private class_2586 getCache(class_2338 pos) {
        class_3545<class_2586, Long> data = this.blockCache.get(pos);
        if (this.yesIAmOp.isPresent() && !this.yesIAmOp.get().booleanValue()) {
            return null;
        }
        if (data != null && System.currentTimeMillis() - (Long)data.method_15441() <= 1000L) {
            if (System.currentTimeMillis() - (Long)data.method_15441() > 500L) {
                this.syncBlockEntity((class_1937)this.clientWorld, pos);
            }
            return (class_2586)data.method_15442();
        }
        return null;
    }

    @Nullable
    private class_1297 getCache(int networkId) {
        class_3545<class_1297, Long> data = this.entityCache.get(networkId);
        if (this.yesIAmOp.isPresent() && !this.yesIAmOp.get().booleanValue()) {
            return null;
        }
        if (data != null && System.currentTimeMillis() - (Long)data.method_15441() <= 1000L) {
            if (System.currentTimeMillis() - (Long)data.method_15441() > 500L) {
                this.syncEntity(networkId);
            }
            return (class_1297)data.method_15442();
        }
        return null;
    }

    public void handleQueryResponse(int transactionId, class_2487 nbt) {
        CompletableFuture<@Nullable class_2487> future = this.pendingQueriesById.remove(transactionId);
        if (future != null) {
            future.complete(nbt);
            this.yesIAmOp = Optional.of(true);
        }
        if (this.blockCache.size() > 30) {
            this.blockCache.entrySet().removeIf(entry -> System.currentTimeMillis() - (Long)((class_3545)entry.getValue()).method_15441() > 1000L);
            this.pendingQueriesByObject.clear();
        }
        if (this.entityCache.size() > 30) {
            this.entityCache.entrySet().removeIf(entry -> System.currentTimeMillis() - (Long)((class_3545)entry.getValue()).method_15441() > 1000L);
            this.pendingQueriesByObject.clear();
        }
    }

    public class_1263 getBlockInventory(class_1937 world, class_2338 pos) {
        if (!FeatureToggle.TWEAK_SERVER_DATA_SYNC.getBooleanValue()) {
            return null;
        }
        if (this.yesIAmOp.isPresent() && !this.yesIAmOp.get().booleanValue()) {
            return null;
        }
        if (!world.method_22340(pos)) {
            return null;
        }
        class_2586 class_25862 = this.getCache(pos);
        if (class_25862 instanceof class_1263) {
            class_1263 inv = (class_1263)class_25862;
            class_2680 state = world.method_8320(pos);
            if (state.method_26204() instanceof class_2281 && inv instanceof class_2595) {
                class_2745 type = (class_2745)state.method_11654((class_2769)class_2281.field_10770);
                if (type != class_2745.field_12569) {
                    class_2338 posAdj = pos.method_10093(class_2281.method_9758((class_2680)state));
                    if (!world.method_22340(posAdj)) {
                        return null;
                    }
                    class_2680 stateAdj = world.method_8320(posAdj);
                    class_2586 dataAdj = this.getCache(posAdj);
                    if (dataAdj == null) {
                        this.syncBlockEntity(world, posAdj);
                    }
                    if (stateAdj.method_26204() == state.method_26204() && dataAdj instanceof class_2595) {
                        class_2595 inv2 = (class_2595)dataAdj;
                        if (stateAdj.method_11654((class_2769)class_2281.field_10770) != class_2745.field_12569 && stateAdj.method_11654((class_2769)class_2281.field_10768) == state.method_11654((class_2769)class_2281.field_10768)) {
                            class_1263 invRight = type == class_2745.field_12571 ? inv : inv2;
                            class_2595 invLeft = type == class_2745.field_12571 ? inv2 : inv;
                            inv = new class_1258(invRight, (class_1263)invLeft);
                        }
                    }
                }
            } else if (state.method_26204() instanceof class_8886 && inv instanceof class_8887) {
                class_8887 ce = (class_8887)inv;
                return InventoryUtils.getAsInventory((class_2371)ce.method_11282());
            }
            return inv;
        }
        this.syncBlockEntity(world, pos);
        class_2680 state = world.method_8320(pos);
        if (state.method_26204() instanceof class_2281) {
            class_2680 stateAdj;
            class_2338 posAdj;
            class_2745 type = (class_2745)state.method_11654((class_2769)class_2281.field_10770);
            if (type != class_2745.field_12569 && world.method_22340(posAdj = pos.method_10093(class_2281.method_9758((class_2680)state))) && (stateAdj = world.method_8320(posAdj)).method_26204() instanceof class_2281) {
                this.syncBlockEntity(world, posAdj);
            }
        } else if (state.method_26204() instanceof class_8886) {
            this.syncBlockEntity(world, pos);
        }
        return null;
    }

    public CompletableFuture<class_2487> syncBlockEntity(class_1937 world, class_2338 pos) {
        class_2586 blockEntity;
        if (this.yesIAmOp.isPresent() && !this.yesIAmOp.get().booleanValue()) {
            return CompletableFuture.completedFuture(null);
        }
        if (class_310.method_1551().method_1496() && (blockEntity = class_310.method_1551().method_1576().method_3847(world.method_27983()).method_8500(pos).method_12201(pos, class_2818.class_2819.field_12859)) != null) {
            this.blockCache.put(pos, (class_3545<class_2586, Long>)new class_3545((Object)blockEntity, (Object)System.currentTimeMillis()));
            return CompletableFuture.completedFuture(blockEntity.method_38244((class_7225.class_7874)world.method_30349()));
        }
        Either posEither = Either.left((Object)pos);
        if (class_310.method_1551().method_1562() != null) {
            if (this.pendingQueriesByObject.containsKey(posEither)) {
                return this.pendingQueriesByObject.get(posEither);
            }
            CompletableFuture<class_2487> future = new CompletableFuture<class_2487>();
            class_300 handler = class_310.method_1551().method_1562().method_2876();
            handler.method_1403(pos, it -> {});
            this.pendingQueriesByObject.put((Either<class_2338, Integer>)posEither, future);
            this.pendingQueriesById.put(((IMixinDataQueryHandler)handler).currentTransactionId(), future);
            future.thenAccept(nbt -> {
                class_2343 provider;
                class_2586 be;
                this.pendingQueriesByObject.remove(posEither);
                if (!this.clientWorld.method_22340(pos) || nbt == null) {
                    return;
                }
                class_2680 state = this.clientWorld.method_8320(pos);
                class_2248 patt0$temp = state.method_26204();
                if (patt0$temp instanceof class_2343 && (be = (provider = (class_2343)patt0$temp).method_10123(pos, state)) != null) {
                    be.method_58690(nbt, (class_7225.class_7874)this.clientWorld.method_30349());
                    this.blockCache.put(pos, (class_3545<class_2586, Long>)new class_3545((Object)be, (Object)System.currentTimeMillis()));
                }
            });
            if (this.yesIAmOp.isEmpty()) {
                this.yesIAmOp = Optional.of(false);
            }
            return future;
        }
        throw new IllegalStateException("Not connected to a server");
    }

    public CompletableFuture<class_2487> syncEntity(int networkId) {
        if (this.yesIAmOp.isPresent() && !this.yesIAmOp.get().booleanValue()) {
            return CompletableFuture.completedFuture(null);
        }
        Either idEither = Either.right((Object)networkId);
        if (class_310.method_1551().method_1562() != null) {
            if (this.pendingQueriesByObject.containsKey(idEither)) {
                return this.pendingQueriesByObject.get(idEither);
            }
            CompletableFuture<class_2487> future = new CompletableFuture<class_2487>();
            class_300 handler = class_310.method_1551().method_1562().method_2876();
            handler.method_1405(networkId, it -> {});
            this.pendingQueriesByObject.put((Either<class_2338, Integer>)idEither, future);
            this.pendingQueriesById.put(((IMixinDataQueryHandler)handler).currentTransactionId(), future);
            future.thenAccept(nbt -> {
                class_1297 entity;
                this.pendingQueriesByObject.remove(idEither);
                if (nbt == null) {
                    return;
                }
                if (this.clientWorld.method_8469(networkId) != null && (entity = this.clientWorld.method_8469(networkId).method_5864().method_5883((class_1937)this.clientWorld)) != null) {
                    entity.method_5651(nbt);
                    this.entityCache.put(networkId, (class_3545<class_1297, Long>)new class_3545((Object)entity, (Object)System.currentTimeMillis()));
                }
            });
            if (this.yesIAmOp.isEmpty()) {
                this.yesIAmOp = Optional.of(false);
            }
            return future;
        }
        throw new IllegalStateException("Not connected to a server");
    }

    @Nullable
    public class_1297 getServerEntity(class_1297 entity) {
        if (!FeatureToggle.TWEAK_SERVER_DATA_SYNC.getBooleanValue()) {
            return null;
        }
        if (this.yesIAmOp.isPresent() && !this.yesIAmOp.get().booleanValue()) {
            return null;
        }
        class_1297 serverEntity = this.getCache(entity.method_5628());
        if (serverEntity == null) {
            this.syncEntity(entity.method_5628());
            return null;
        }
        return serverEntity;
    }

    public void recheckOpStatus() {
        this.yesIAmOp = Optional.empty();
        this.pendingQueriesByObject.clear();
        this.pendingQueriesById.clear();
    }
}

