/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.litematica_mixin;

import ch.endte.syncmatica.litematica.IIDContainer;
import ch.endte.syncmatica.litematica.LitematicManager;
import ch.endte.syncmatica.litematica.MovingFinisher;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacementManager;
import fi.dy.masa.malilib.util.JsonUtils;
import java.util.UUID;
import net.minecraft.class_2338;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SchematicPlacement.class})
public abstract class MixinSchematicPlacement
implements IIDContainer,
MovingFinisher {
    @Unique
    UUID serverId;

    private MixinSchematicPlacement() {
    }

    @Inject(method={"toJson"}, at={@At(value="RETURN")}, remap=false)
    public void saveUuid(CallbackInfoReturnable<JsonObject> cir) {
        JsonObject saveData = (JsonObject)cir.getReturnValue();
        if (saveData != null && this.serverId != null) {
            saveData.add("syncmatica_uuid", (JsonElement)new JsonPrimitive(this.serverId.toString()));
        }
    }

    @Inject(method={"fromJson"}, at={@At(value="RETURN")}, remap=false, cancellable=true)
    private static void loadSyncmatic(JsonObject obj, CallbackInfoReturnable<SchematicPlacement> cir) {
        SchematicPlacement newInstance;
        if (JsonUtils.hasString((JsonObject)obj, (String)"syncmatica_uuid") && (newInstance = (SchematicPlacement)cir.getReturnValue()) != null) {
            ((IIDContainer)newInstance).syncmatica$setServerId(UUID.fromString(obj.get("syncmatica_uuid").getAsString()));
            cir.setReturnValue(null);
            LitematicManager.getInstance().preLoad(newInstance);
        }
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")}, remap=false)
    public void setNull(LitematicaSchematic schematic, class_2338 origin, String name, boolean enabled, boolean enableRender, CallbackInfo ci) {
        this.serverId = null;
    }

    @Override
    public void syncmatica$setServerId(UUID i) {
        this.serverId = i;
    }

    @Override
    public UUID syncmatica$getServerId() {
        return this.serverId;
    }

    @Override
    @Invoker(value="onModified", remap=false)
    public abstract void onFinishedMoving(String var1, SchematicPlacementManager var2);
}

