/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.litematica_mixin;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.litematica.LitematicManager;
import ch.endte.syncmatica.litematica.gui.ButtonListenerChangeMenu;
import ch.endte.syncmatica.litematica.gui.MainMenuButtonType;
import fi.dy.masa.litematica.gui.GuiMainMenu;
import fi.dy.masa.litematica.selection.SelectionMode;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.util.StringUtils;
import net.minecraft.class_437;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiMainMenu.class})
public class MixinGuiMainMenu
extends GuiBase {
    @Inject(method={"initGui"}, at={@At(value="RETURN")}, remap=false)
    public void initGui(CallbackInfo ci) {
        int width = this.getButtonWidth();
        int x = 52 + 2 * width;
        int y = 30;
        this.createChangeMenuButton(x, y, width, MainMenuButtonType.VIEW_SYNCMATICS);
        this.createChangeMenuButton(x, y += 22, width, MainMenuButtonType.MATERIAL_GATHERINGS).setEnabled(false);
    }

    @Unique
    private ButtonGeneric createChangeMenuButton(int x, int y, int width, MainMenuButtonType type) {
        ButtonGeneric button = new ButtonGeneric(x, y, width, 20, type.getTranslatedKey(), type.getIcon(), new String[0]);
        Context con = LitematicManager.getInstance().getActiveContext();
        button.setEnabled(con != null && con.isStarted());
        this.addButton((ButtonBase)button, new ButtonListenerChangeMenu(type, (class_437)this));
        return button;
    }

    @Unique
    private int getButtonWidth() {
        int width = 0;
        for (MainMenuButtonType mainMenuButtonType : MainMenuButtonType.values()) {
            width = Math.max(width, this.getStringWidth(mainMenuButtonType.getTranslatedKey()) + 30);
        }
        for (MainMenuButtonType mainMenuButtonType : SelectionMode.values()) {
            String label = StringUtils.translate((String)"litematica.gui.button.area_selection_mode", (Object[])new Object[]{mainMenuButtonType.getDisplayName()});
            width = Math.max(width, this.getStringWidth(label) + 10);
        }
        return width;
    }
}

