/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.litematica.gui;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.Syncmatica;
import ch.endte.syncmatica.communication.ClientCommunicationManager;
import ch.endte.syncmatica.communication.ExchangeTarget;
import ch.endte.syncmatica.data.LocalLitematicState;
import ch.endte.syncmatica.data.ServerPlacement;
import ch.endte.syncmatica.litematica.LitematicManager;
import ch.endte.syncmatica.litematica.gui.BaseButtonType;
import ch.endte.syncmatica.litematica.gui.IButtonType;
import ch.endte.syncmatica.litematica.gui.MultiTypeButton;
import ch.endte.syncmatica.network.PacketType;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetListEntryBase;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.StringUtils;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import net.minecraft.class_2540;
import net.minecraft.class_332;

public class WidgetSyncmaticaServerPlacementEntry
extends WidgetListEntryBase<ServerPlacement> {
    private final ServerPlacement placement;
    private final boolean isOdd;

    public WidgetSyncmaticaServerPlacementEntry(int x, int y, int width, int height, ServerPlacement entry, int listIndex) {
        super(x, y, width, height, (Object)entry, listIndex);
        this.placement = entry;
        this.isOdd = listIndex % 2 == 1;
        int posX = x + width;
        String text = StringUtils.translate((String)"syncmatica.gui.button.remove", (Object[])new Object[0]);
        int len = this.getStringWidth(text) + 10;
        ButtonListener listener = new ButtonListener(ButtonListener.Type.REMOVE, this);
        this.addButton((ButtonBase)new ButtonGeneric(posX -= len + 2, ++y, len, 20, text, new String[0]), listener);
        text = StringUtils.translate((String)"syncmatica.gui.button.material_gathering_placement", (Object[])new Object[0]);
        len = this.getStringWidth(text) + 10;
        listener = new ButtonListener(ButtonListener.Type.MATERIAL_GATHERING, this);
        ButtonGeneric matGathering = new ButtonGeneric(posX -= len + 2, y, len, 20, text, new String[0]);
        matGathering.setEnabled(false);
        this.addButton((ButtonBase)matGathering, listener);
        ArrayList<IButtonType> multi = new ArrayList<IButtonType>();
        multi.add(new BaseButtonType("syncmatica.gui.button.downloading", () -> LitematicManager.getInstance().getActiveContext().getCommunicationManager().getDownloadState(this.placement), null));
        multi.add(new BaseButtonType("syncmatica.gui.button.download", () -> {
            Context con = LitematicManager.getInstance().getActiveContext();
            LocalLitematicState state = con.getFileStorage().getLocalState(this.placement);
            return !state.isLocalFileReady() && state.isReadyForDownload();
        }, new ButtonListener(ButtonListener.Type.DOWNLOAD, this)));
        multi.add(new BaseButtonType("syncmatica.gui.button.load", () -> !LitematicManager.getInstance().isRendered(this.placement), new ButtonListener(ButtonListener.Type.LOAD, this)));
        multi.add(new BaseButtonType("syncmatica.gui.button.unload", () -> LitematicManager.getInstance().isRendered(this.placement), new ButtonListener(ButtonListener.Type.UNLOAD, this)));
        MultiTypeButton button = new MultiTypeButton(posX, y, true, multi);
        this.addButton((ButtonBase)button, null);
    }

    public void render(int mouseX, int mouseY, boolean selected, class_332 drawContext) {
        RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (selected || this.isMouseOver(mouseX, mouseY)) {
            RenderUtils.drawRect((int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)0x70FFFFFF);
        } else if (this.isOdd) {
            RenderUtils.drawRect((int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)0x20FFFFFF);
        } else {
            RenderUtils.drawRect((int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)0x50FFFFFF);
        }
        String schematicName = this.placement.getName();
        this.drawString(this.x + 20, this.y + 7, -1, schematicName, drawContext);
        this.drawSubWidgets(mouseX, mouseY, drawContext);
    }

    private static class ButtonListener
    implements IButtonActionListener {
        Type type;
        WidgetSyncmaticaServerPlacementEntry placement;

        public ButtonListener(Type type, WidgetSyncmaticaServerPlacementEntry placement) {
            this.type = type;
            this.placement = placement;
        }

        public void actionPerformedWithButton(ButtonBase button, int arg1) {
            if (this.type == null) {
                return;
            }
            button.setEnabled(false);
            this.type.onAction(this.placement);
        }

        public static enum Type {
            LOAD{

                @Override
                void onAction(WidgetSyncmaticaServerPlacementEntry placement) {
                    LitematicManager.getInstance().renderSyncmatic(placement.placement);
                }
            }
            ,
            UNLOAD{

                @Override
                void onAction(WidgetSyncmaticaServerPlacementEntry placement) {
                    LitematicManager.getInstance().unrenderSyncmatic(placement.placement);
                }
            }
            ,
            DOWNLOAD{

                @Override
                void onAction(WidgetSyncmaticaServerPlacementEntry placement) {
                    Context con = LitematicManager.getInstance().getActiveContext();
                    ExchangeTarget server = ((ClientCommunicationManager)con.getCommunicationManager()).getServer();
                    if (con.getCommunicationManager().getDownloadState(placement.placement)) {
                        return;
                    }
                    try {
                        con.getCommunicationManager().download(placement.placement, server);
                    }
                    catch (IOException | NoSuchAlgorithmException e) {
                        e.printStackTrace();
                    }
                }
            }
            ,
            REMOVE{

                @Override
                void onAction(WidgetSyncmaticaServerPlacementEntry placement) {
                    Context con = LitematicManager.getInstance().getActiveContext();
                    ExchangeTarget server = ((ClientCommunicationManager)con.getCommunicationManager()).getServer();
                    class_2540 packetBuf = new class_2540(Unpooled.buffer());
                    packetBuf.method_10797(placement.placement.getId());
                    server.sendPacket(PacketType.REMOVE_SYNCMATIC, packetBuf, LitematicManager.getInstance().getActiveContext());
                }
            }
            ,
            MATERIAL_GATHERING{

                @Override
                void onAction(WidgetSyncmaticaServerPlacementEntry placement) {
                    Syncmatica.LOGGER.info("Opened Material Gatherings GUI - currently unsupported operation");
                }
            };


            abstract void onAction(WidgetSyncmaticaServerPlacementEntry var1);
        }
    }
}

