/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.litematica.gui;

import ch.endte.syncmatica.litematica.gui.IButtonType;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import java.util.List;

public class MultiTypeButton
extends ButtonGeneric {
    IButtonType activeType;
    List<IButtonType> types;

    public MultiTypeButton(int x, int y, boolean rightAligned, List<IButtonType> types) {
        super(x, y, 1, 20, "", new String[0]);
        this.types = types;
        this.activeType = types.get(0);
        this.update();
        this.width = this.calculateWidth();
        if (rightAligned) {
            this.x -= this.width;
        }
        this.actionListener = new MultiTypeListener();
    }

    public void update() {
        this.updateType();
        this.displayString = this.activeType.getTranslatedKey();
        if (this.activeType.getHoverStrings() != null) {
            List<String> hoverStrings = this.activeType.getHoverStrings();
            this.setHoverStrings(hoverStrings.toArray(new String[0]));
        }
        this.setEnabled(this.activeType.getButtonListener() != null);
    }

    private void updateType() {
        for (IButtonType type : this.types) {
            if (!type.isActive()) continue;
            this.activeType = type;
            return;
        }
        this.activeType = this.types.get(0);
    }

    public IButtonType getActiveType() {
        return this.activeType;
    }

    private int calculateWidth() {
        int wMax = -1;
        for (IButtonType type : this.types) {
            int wType = this.calculateWidth(type);
            if (wType <= wMax) continue;
            wMax = wType;
        }
        return wMax;
    }

    private int calculateWidth(IButtonType type) {
        int w = 0;
        if (type.getTranslatedKey() != null) {
            w += this.getStringWidth(type.getTranslatedKey()) + 10;
        }
        if (type.getIcon() != null) {
            w += type.getIcon().getWidth() + 8;
        }
        return w;
    }

    public MultiTypeButton setActionListener(IButtonActionListener listener) {
        return this;
    }

    public class MultiTypeListener
    implements IButtonActionListener {
        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            MultiTypeButton.this.update();
            if (MultiTypeButton.this.activeType.getButtonListener() != null) {
                MultiTypeButton.this.activeType.getButtonListener().actionPerformedWithButton(button, mouseButton);
            }
        }
    }
}

