/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.litematica;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.data.RedirectFileStorage;
import ch.endte.syncmatica.data.ServerPlacement;
import ch.endte.syncmatica.data.ServerPosition;
import ch.endte.syncmatica.data.SyncmaticManager;
import ch.endte.syncmatica.extended_core.PlayerIdentifier;
import ch.endte.syncmatica.extended_core.SubRegionData;
import ch.endte.syncmatica.extended_core.SubRegionPlacementModification;
import ch.endte.syncmatica.litematica.IIDContainer;
import ch.endte.syncmatica.litematica.MovingFinisher;
import ch.endte.syncmatica.litematica.ScreenHelper;
import ch.endte.syncmatica.litematica_mixin.MixinSchematicPlacementManager;
import ch.endte.syncmatica.litematica_mixin.MixinSubregionPlacement;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.data.SchematicHolder;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacementManager;
import fi.dy.masa.litematica.schematic.placement.SubRegionPlacement;
import fi.dy.masa.litematica.util.FileType;
import fi.dy.masa.malilib.gui.Message;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_310;

public class LitematicManager {
    private static LitematicManager instance = null;
    private final Map<ServerPlacement, SchematicPlacement> rendering;
    private Collection<SchematicPlacement> preLoadList = new ArrayList<SchematicPlacement>();
    private Context context;

    public static LitematicManager getInstance() {
        if (instance == null) {
            instance = new LitematicManager();
        }
        return instance;
    }

    public static void clear() {
        instance = null;
    }

    private LitematicManager() {
        this.rendering = new HashMap<ServerPlacement, SchematicPlacement>();
    }

    public void setActiveContext(Context con) {
        if (con.isServer()) {
            throw new Context.ContextMismatchException("Applied server context where client context was expected");
        }
        this.context = con;
        ScreenHelper.ifPresent(s -> s.setActiveContext(con));
    }

    public Context getActiveContext() {
        return this.context;
    }

    public void renderSyncmatic(ServerPlacement placement) {
        String dimension = class_310.method_1551().method_1560().method_5770().method_27983().method_29177().toString();
        if (!dimension.equals(placement.getDimension())) {
            ScreenHelper.ifPresent(s -> s.addMessage(Message.MessageType.ERROR, "syncmatica.error.player_dimension_mismatch", new Object[0]));
            this.context.getSyncmaticManager().updateServerPlacement(placement);
            return;
        }
        if (this.rendering.containsKey(placement)) {
            return;
        }
        File file = this.context.getFileStorage().getLocalLitematic(placement);
        LitematicaSchematic schematic = SchematicHolder.getInstance().getOrLoad(file);
        if (schematic == null) {
            ScreenHelper.ifPresent(s -> s.addMessage(Message.MessageType.ERROR, "syncmatica.error.failed_to_load", file.getAbsolutePath()));
            return;
        }
        class_2338 origin = placement.getPosition();
        SchematicPlacement litematicaPlacement = SchematicPlacement.createFor((LitematicaSchematic)schematic, (class_2338)origin, (String)file.getName(), (boolean)true, (boolean)true);
        this.rendering.put(placement, litematicaPlacement);
        ((IIDContainer)litematicaPlacement).syncmatica$setServerId(placement.getId());
        if (litematicaPlacement.isLocked()) {
            litematicaPlacement.toggleLocked();
        }
        litematicaPlacement.setRotation(placement.getRotation(), null);
        litematicaPlacement.setMirror(placement.getMirror(), null);
        this.transferSubregionDataToClientPlacement(placement, litematicaPlacement);
        litematicaPlacement.toggleLocked();
        DataManager.getSchematicPlacementManager().addSchematicPlacement(litematicaPlacement, true);
        this.context.getSyncmaticManager().updateServerPlacement(placement);
    }

    public ServerPlacement syncmaticFromSchematic(SchematicPlacement schem) {
        if (this.rendering.containsValue(schem)) {
            for (ServerPlacement checkPlacement : this.rendering.keySet()) {
                if (this.rendering.get(checkPlacement) != schem) continue;
                return checkPlacement;
            }
            return null;
        }
        try {
            File placementFile = schem.getSchematicFile();
            FileType fileType = FileType.fromFile((File)placementFile);
            if (fileType == FileType.VANILLA_STRUCTURE || fileType == FileType.SCHEMATICA_SCHEMATIC) {
                ScreenHelper.ifPresent(s -> s.addMessage(Message.MessageType.ERROR, "syncmatica.error.share_incompatible_schematic", new Object[0]));
                return null;
            }
            if (fileType != FileType.LITEMATICA_SCHEMATIC) {
                ScreenHelper.ifPresent(s -> s.addMessage(Message.MessageType.ERROR, "syncmatica.error.invalid_file", new Object[0]));
                return null;
            }
            PlayerIdentifier owner = this.context.getPlayerIdentifierProvider().createOrGet(class_310.method_1551().method_1548().method_44717(), class_310.method_1551().method_1548().method_1676());
            ServerPlacement placement = new ServerPlacement(UUID.randomUUID(), placementFile, owner);
            String dimension = class_310.method_1551().method_1560().method_5770().method_27983().method_29177().toString();
            placement.move(dimension, schem.getOrigin(), schem.getRotation(), schem.getMirror());
            this.transferSubregionDataToServerPlacement(schem, placement);
            return placement;
        }
        catch (Exception e) {
            ScreenHelper.ifPresent(s -> s.addMessage(Message.MessageType.ERROR, "syncmatica.error.create_from_schematic", e.getMessage()));
            return null;
        }
    }

    private void transferSubregionDataToServerPlacement(SchematicPlacement schem, ServerPlacement placement) {
        Collection subLitematica = schem.getAllSubRegionsPlacements();
        Map defaultPositionMap = schem.getSchematic().getAreaPositions();
        SubRegionData subRegionData = placement.getSubRegionData();
        subRegionData.reset();
        for (SubRegionPlacement subRegionPlacement : subLitematica) {
            class_2338 defaultPos;
            if (!this.isSubregionModified(subRegionPlacement, defaultPos = (class_2338)defaultPositionMap.get(subRegionPlacement.getName()))) continue;
            subRegionData.modify(subRegionPlacement.getName(), subRegionPlacement.getPos(), subRegionPlacement.getRotation(), subRegionPlacement.getMirror());
        }
    }

    private void transferSubregionDataToClientPlacement(ServerPlacement placement, SchematicPlacement schem) {
        Collection subLitematica = schem.getAllSubRegionsPlacements();
        Map defaultPositionMap = schem.getSchematic().getAreaPositions();
        Map<String, SubRegionPlacementModification> modificationData = placement.getSubRegionData().getModificationData();
        for (SubRegionPlacement subRegionPlacement : subLitematica) {
            SubRegionPlacementModification modification = modificationData != null ? modificationData.get(subRegionPlacement.getName()) : null;
            class_2338 defaultPos = (class_2338)defaultPositionMap.get(subRegionPlacement.getName());
            SchematicPlacementManager manager = DataManager.getSchematicPlacementManager();
            MixinSchematicPlacementManager mixinManager = (MixinSchematicPlacementManager)manager;
            MixinSubregionPlacement mutable = (MixinSubregionPlacement)subRegionPlacement;
            if (modification != null) {
                mixinManager.preSubregionChange(schem);
                mutable.setBlockPosition(modification.position);
                mutable.setBlockRotation(modification.rotation);
                mutable.setBlockMirror(modification.mirror);
                ((MovingFinisher)schem).onFinishedMoving(subRegionPlacement.getName(), manager);
                continue;
            }
            if (!this.isSubregionModified(subRegionPlacement, defaultPos)) continue;
            mixinManager.preSubregionChange(schem);
            this.resetSubRegion(subRegionPlacement, defaultPos);
            ((MovingFinisher)schem).onFinishedMoving(subRegionPlacement.getName(), manager);
        }
    }

    public SchematicPlacement schematicFromSyncmatic(ServerPlacement p) {
        return this.rendering.get(p);
    }

    public void renderSyncmatic(ServerPlacement placement, SchematicPlacement litematicaPlacement, boolean addToRendering) {
        if (this.rendering.containsKey(placement)) {
            return;
        }
        IIDContainer modPlacement = (IIDContainer)litematicaPlacement;
        if (modPlacement.syncmatica$getServerId() != null && !modPlacement.syncmatica$getServerId().equals(placement.getId())) {
            return;
        }
        this.rendering.put(placement, litematicaPlacement);
        modPlacement.syncmatica$setServerId(placement.getId());
        if (litematicaPlacement.isLocked()) {
            litematicaPlacement.toggleLocked();
        }
        litematicaPlacement.setOrigin(placement.getPosition(), null);
        litematicaPlacement.setRotation(placement.getRotation(), null);
        litematicaPlacement.setMirror(placement.getMirror(), null);
        this.transferSubregionDataToClientPlacement(placement, litematicaPlacement);
        litematicaPlacement.toggleLocked();
        this.context.getSyncmaticManager().updateServerPlacement(placement);
        if (addToRendering) {
            DataManager.getSchematicPlacementManager().addSchematicPlacement(litematicaPlacement, false);
        }
    }

    public void unrenderSyncmatic(ServerPlacement placement) {
        if (!this.isRendered(placement)) {
            return;
        }
        DataManager.getSchematicPlacementManager().removeSchematicPlacement(this.rendering.get(placement));
        this.rendering.remove(placement);
        this.context.getSyncmaticManager().updateServerPlacement(placement);
    }

    public void updateRendered(ServerPlacement placement) {
        if (!this.isRendered(placement)) {
            return;
        }
        SchematicPlacement litematicaPlacement = this.rendering.get(placement);
        boolean wasLocked = litematicaPlacement.isLocked();
        if (wasLocked) {
            litematicaPlacement.toggleLocked();
        }
        litematicaPlacement.setOrigin(placement.getPosition(), null);
        litematicaPlacement.setRotation(placement.getRotation(), null);
        litematicaPlacement.setMirror(placement.getMirror(), null);
        this.transferSubregionDataToClientPlacement(placement, litematicaPlacement);
        if (wasLocked) {
            litematicaPlacement.toggleLocked();
        }
    }

    public void updateServerPlacement(SchematicPlacement placement, ServerPlacement serverPlacement) {
        serverPlacement.move(serverPlacement.getDimension(), placement.getOrigin(), placement.getRotation(), placement.getMirror());
        this.transferSubregionDataToServerPlacement(placement, serverPlacement);
    }

    public boolean isRendered(ServerPlacement placement) {
        return this.rendering.containsKey(placement);
    }

    public boolean isSyncmatic(SchematicPlacement schem) {
        return this.rendering.containsValue(schem);
    }

    public boolean isSubregionModified(SubRegionPlacement subRegionPlacement, class_2338 defaultPos) {
        return subRegionPlacement.getMirror() != class_2415.field_11302 || subRegionPlacement.getRotation() != class_2470.field_11467 || !subRegionPlacement.getPos().equals((Object)defaultPos);
    }

    public void resetSubRegion(SubRegionPlacement subRegionPlacement, class_2338 defaultPos) {
        MixinSubregionPlacement mutable = (MixinSubregionPlacement)subRegionPlacement;
        mutable.setBlockMirror(class_2415.field_11302);
        mutable.setBlockRotation(class_2470.field_11467);
        mutable.setBlockPosition(defaultPos);
    }

    public void preLoad(SchematicPlacement schem) {
        if (this.context != null && this.context.isStarted()) {
            UUID id = ((IIDContainer)schem).syncmatica$getServerId();
            ServerPlacement p = this.context.getSyncmaticManager().getPlacement(id);
            if (this.isRendered(p)) {
                this.rendering.put(p, schem);
                DataManager.getSchematicPlacementManager().addSchematicPlacement(schem, false);
            }
        } else if (this.preLoadList != null) {
            this.preLoadList.add(schem);
        }
    }

    public void commitLoad() {
        SyncmaticManager man = this.context.getSyncmaticManager();
        for (SchematicPlacement schem : this.preLoadList) {
            UUID id = ((IIDContainer)schem).syncmatica$getServerId();
            ServerPlacement p = man.getPlacement(id);
            if (p == null) continue;
            if (this.context.getFileStorage().getLocalLitematic(p) != schem.getSchematicFile()) {
                ((RedirectFileStorage)this.context.getFileStorage()).addRedirect(schem.getSchematicFile());
            }
            this.renderSyncmatic(p, schem, true);
        }
        this.preLoadList = null;
    }

    public void unrenderSchematic(LitematicaSchematic l) {
        this.rendering.entrySet().removeIf(e -> {
            if (((SchematicPlacement)e.getValue()).getSchematic() == l) {
                this.context.getSyncmaticManager().updateServerPlacement((ServerPlacement)e.getKey());
                return true;
            }
            return false;
        });
    }

    public void unrenderSchematicPlacement(SchematicPlacement placement) {
        UUID id = ((IIDContainer)placement).syncmatica$getServerId();
        ServerPlacement p = this.context.getSyncmaticManager().getPlacement(id);
        if (p != null) {
            this.unrenderSyncmatic(p);
        }
    }

    public ServerPosition getPlayerPosition() {
        if (class_310.method_1551().method_1560() != null) {
            class_2338 blockPos = class_310.method_1551().method_1560().method_24515();
            String dimensionId = this.getPlayerDimension();
            return new ServerPosition(blockPos, dimensionId);
        }
        return new ServerPosition(new class_2338(0, 0, 0), "minecraft:overworld");
    }

    public String getPlayerDimension() {
        if (class_310.method_1551().method_1560() != null) {
            return class_310.method_1551().method_1560().method_5770().method_27983().method_29177().toString();
        }
        return "minecraft:overworld";
    }
}

