/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.data;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.data.ServerPlacement;
import ch.endte.syncmatica.util.SyncmaticaUtil;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;

public class SyncmaticManager {
    public static final String PLACEMENTS_JSON_KEY = "placements";
    private final Map<UUID, ServerPlacement> schematics = new HashMap<UUID, ServerPlacement>();
    private final Collection<Consumer<ServerPlacement>> consumers = new ArrayList<Consumer<ServerPlacement>>();
    Context context;

    public void setContext(Context con) {
        if (this.context != null) {
            throw new Context.DuplicateContextAssignmentException("Duplicate Context assignment");
        }
        this.context = con;
    }

    public void addPlacement(ServerPlacement placement) {
        this.schematics.put(placement.getId(), placement);
        this.updateServerPlacement(placement);
    }

    public ServerPlacement getPlacement(UUID id) {
        return this.schematics.get(id);
    }

    public Collection<ServerPlacement> getAll() {
        return this.schematics.values();
    }

    public void removePlacement(ServerPlacement placement) {
        this.schematics.remove(placement.getId());
        this.updateServerPlacement(placement);
    }

    public void addServerPlacementConsumer(Consumer<ServerPlacement> consumer) {
        this.consumers.add(consumer);
    }

    public void removeServerPlacementConsumer(Consumer<ServerPlacement> consumer) {
        this.consumers.remove(consumer);
    }

    public void updateServerPlacement(ServerPlacement updated) {
        for (Consumer<ServerPlacement> consumer : this.consumers) {
            consumer.accept(updated);
        }
        if (this.context.isServer()) {
            this.saveServer();
        }
    }

    public void startup() {
        if (this.context.isServer()) {
            this.loadServer();
        }
    }

    public void shutdown() {
    }

    private void saveServer() {
        JsonObject obj = new JsonObject();
        JsonArray arr = new JsonArray();
        for (ServerPlacement p : this.getAll()) {
            arr.add((JsonElement)p.toJson());
        }
        obj.add(PLACEMENTS_JSON_KEY, (JsonElement)arr);
        File backup = new File(this.context.getConfigFolder(), "placements.json.bak");
        File incoming = new File(this.context.getConfigFolder(), "placements.json.new");
        File current = new File(this.context.getConfigFolder(), "placements.json");
        try (FileWriter writer = new FileWriter(incoming);){
            writer.write(new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)obj));
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        SyncmaticaUtil.backupAndReplace(backup.toPath(), current.toPath(), incoming.toPath());
    }

    private void loadServer() {
        File f = new File(this.context.getConfigFolder(), "placements.json");
        if (f.exists() && f.isFile() && f.canRead()) {
            JsonElement element = null;
            try {
                FileReader reader = new FileReader(f);
                element = JsonParser.parseReader((Reader)reader);
                reader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (element == null) {
                return;
            }
            try {
                JsonObject obj = element.getAsJsonObject();
                if (obj == null || !obj.has(PLACEMENTS_JSON_KEY)) {
                    return;
                }
                JsonArray arr = obj.getAsJsonArray(PLACEMENTS_JSON_KEY);
                for (JsonElement elem : arr) {
                    ServerPlacement placement = ServerPlacement.fromJson(elem.getAsJsonObject(), this.context);
                    this.schematics.put(placement.getId(), placement);
                }
            }
            catch (IllegalStateException | NullPointerException e) {
                e.printStackTrace();
            }
        }
    }
}

