/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.data;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.data.IFileStorage;
import ch.endte.syncmatica.data.LocalLitematicState;
import ch.endte.syncmatica.data.ServerPlacement;
import ch.endte.syncmatica.util.SyncmaticaUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;

public class FileStorage
implements IFileStorage {
    private final HashMap<ServerPlacement, Long> buffer = new HashMap();
    private Context context = null;

    @Override
    public void setContext(Context con) {
        if (this.context != null) {
            throw new Context.DuplicateContextAssignmentException("Duplicate Context assignment");
        }
        this.context = con;
    }

    @Override
    public LocalLitematicState getLocalState(ServerPlacement placement) {
        File localFile = this.getSchematicPath(placement);
        if (localFile.isFile()) {
            if (this.isDownloading(placement)) {
                return LocalLitematicState.DOWNLOADING_LITEMATIC;
            }
            if (this.buffer.containsKey(placement) && this.buffer.get(placement).longValue() == localFile.lastModified() || this.hashCompare(localFile, placement)) {
                return LocalLitematicState.LOCAL_LITEMATIC_PRESENT;
            }
            return LocalLitematicState.LOCAL_LITEMATIC_DESYNC;
        }
        return LocalLitematicState.NO_LOCAL_LITEMATIC;
    }

    private boolean isDownloading(ServerPlacement placement) {
        if (this.context == null) {
            throw new RuntimeException("No CommunicationManager has been set yet - cannot get litematic state");
        }
        return this.context.getCommunicationManager().getDownloadState(placement);
    }

    @Override
    public File getLocalLitematic(ServerPlacement placement) {
        if (this.getLocalState(placement).isLocalFileReady()) {
            return this.getSchematicPath(placement);
        }
        return null;
    }

    @Override
    public File createLocalLitematic(ServerPlacement placement) {
        if (this.getLocalState(placement).isLocalFileReady()) {
            throw new IllegalArgumentException("");
        }
        File file = this.getSchematicPath(placement);
        if (file.exists()) {
            file.delete();
        }
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    private boolean hashCompare(File localFile, ServerPlacement placement) {
        UUID hash = null;
        try {
            hash = SyncmaticaUtil.createChecksum(new FileInputStream(localFile));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (hash == null) {
            return false;
        }
        if (hash.equals(placement.getHash())) {
            this.buffer.put(placement, localFile.lastModified());
            return true;
        }
        return false;
    }

    private File getSchematicPath(ServerPlacement placement) {
        File litematicPath = this.context.getLitematicFolder();
        if (this.context.isServer()) {
            return new File(litematicPath, placement.getHash().toString() + ".litematic");
        }
        return new File(litematicPath, placement.getName() + ".litematic");
    }
}

