/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.communication.exchange;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.communication.ExchangeTarget;
import ch.endte.syncmatica.communication.FeatureSet;
import ch.endte.syncmatica.communication.exchange.AbstractExchange;
import ch.endte.syncmatica.network.PacketType;
import io.netty.buffer.Unpooled;
import net.minecraft.class_2540;

public abstract class FeatureExchange
extends AbstractExchange {
    protected FeatureExchange(ExchangeTarget partner, Context con) {
        super(partner, con);
    }

    @Override
    public boolean checkPacket(PacketType type, class_2540 packetBuf) {
        return type.equals((Object)PacketType.FEATURE_REQUEST) || type.equals((Object)PacketType.FEATURE);
    }

    @Override
    public void handle(PacketType type, class_2540 packetBuf) {
        if (type.equals((Object)PacketType.FEATURE_REQUEST)) {
            this.sendFeatures();
        } else if (type.equals((Object)PacketType.FEATURE)) {
            FeatureSet fs = FeatureSet.fromString(packetBuf.method_10800(this.PACKET_MAX_STRING_SIZE));
            this.getPartner().setFeatureSet(fs);
            this.onFeatureSetReceive();
        }
    }

    protected void onFeatureSetReceive() {
        this.succeed();
    }

    public void requestFeatureSet() {
        this.getPartner().sendPacket(PacketType.FEATURE_REQUEST, new class_2540(Unpooled.buffer()), this.getContext());
    }

    private void sendFeatures() {
        class_2540 buf = new class_2540(Unpooled.buffer());
        FeatureSet fs = this.getContext().getFeatureSet();
        buf.method_10788(fs.toString(), this.PACKET_MAX_STRING_SIZE);
        this.getPartner().sendPacket(PacketType.FEATURE, buf, this.getContext());
    }
}

