/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica;

import ch.endte.syncmatica.Feature;
import ch.endte.syncmatica.Reference;
import ch.endte.syncmatica.Syncmatica;
import ch.endte.syncmatica.communication.CommunicationManager;
import ch.endte.syncmatica.communication.FeatureSet;
import ch.endte.syncmatica.data.IFileStorage;
import ch.endte.syncmatica.data.SyncmaticManager;
import ch.endte.syncmatica.extended_core.PlayerIdentifierProvider;
import ch.endte.syncmatica.network.SyncmaticaPacket;
import ch.endte.syncmatica.network.handler.ClientPlayHandler;
import ch.endte.syncmatica.network.handler.ServerPlayHandler;
import ch.endte.syncmatica.service.DebugService;
import ch.endte.syncmatica.service.IService;
import ch.endte.syncmatica.service.JsonConfiguration;
import ch.endte.syncmatica.service.QuotaService;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2960;

public class Context {
    private final IFileStorage files;
    private final CommunicationManager comMan;
    private final SyncmaticManager synMan;
    private FeatureSet fs = null;
    private final boolean server;
    private final boolean integratedServer;
    private final File litematicFolder;
    private final File worldFolder;
    private boolean isStarted = false;
    private final QuotaService quota;
    private final DebugService debugService;
    private final PlayerIdentifierProvider playerIdentifierProvider;
    private static boolean registerS2C = false;
    private static boolean registerC2S = false;

    public Context(IFileStorage fs, CommunicationManager comMan, SyncmaticManager synMan, File litematicFolder) {
        this(fs, comMan, synMan, false, litematicFolder, false, null);
    }

    public Context(IFileStorage fs, CommunicationManager comMan, SyncmaticManager synMan, boolean isServer, File litematicFolder, boolean integrated, File worldFolder) {
        this.files = fs;
        fs.setContext(this);
        this.comMan = comMan;
        comMan.setContext(this);
        this.synMan = synMan;
        synMan.setContext(this);
        this.server = isServer;
        this.quota = isServer ? new QuotaService() : null;
        this.playerIdentifierProvider = new PlayerIdentifierProvider(this);
        this.debugService = new DebugService();
        this.litematicFolder = litematicFolder;
        if (!litematicFolder.exists()) {
            try {
                if (!litematicFolder.mkdirs()) {
                    Syncmatica.LOGGER.fatal("Context(): Fatal error creating litematic Folder.  Check that Syncmatica has the permissions to do so.");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.integratedServer = integrated;
        this.worldFolder = worldFolder;
        this.loadConfiguration();
    }

    public PlayerIdentifierProvider getPlayerIdentifierProvider() {
        return this.playerIdentifierProvider;
    }

    public IFileStorage getFileStorage() {
        return this.files;
    }

    public CommunicationManager getCommunicationManager() {
        return this.comMan;
    }

    public SyncmaticManager getSyncmaticManager() {
        return this.synMan;
    }

    public QuotaService getQuotaService() {
        return this.quota;
    }

    public DebugService getDebugService() {
        return this.debugService;
    }

    public FeatureSet getFeatureSet() {
        if (this.fs == null) {
            this.generateFeatureSet();
        }
        return this.fs;
    }

    public boolean isServer() {
        return this.server;
    }

    public boolean isIntegratedServer() {
        return this.integratedServer;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public File getLitematicFolder() {
        return this.litematicFolder;
    }

    private void generateFeatureSet() {
        this.fs = new FeatureSet(Arrays.asList(Feature.values()));
    }

    public void startup() {
        Syncmatica.debug("Context#startup()", new Object[0]);
        this.registerReceivers();
        this.startupServices();
        this.isStarted = true;
        this.synMan.startup();
    }

    public void shutdown() {
        Syncmatica.debug("Context#shutdown()", new Object[0]);
        this.shutdownServices();
        this.unregisterReceivers();
        this.isStarted = false;
        this.synMan.shutdown();
    }

    public void registerReceivers() {
        if (this.isServer() && !registerC2S) {
            if (Reference.isServer() || Reference.isIntegratedServer() || Reference.isOpenToLan()) {
                Syncmatica.debug("Context#registerReceivers(): [SERVER] -> registerSyncmaticaHandler", new Object[0]);
                ServerPlayNetworking.registerGlobalReceiver(SyncmaticaPacket.Payload.ID, ServerPlayHandler::receiveSyncPayload);
                registerC2S = true;
            }
        } else if (Reference.isClient() && !registerS2C) {
            Syncmatica.debug("Context#registerReceivers(): [CLIENT] -> registerSyncmaticaHandler", new Object[0]);
            ClientPlayNetworking.registerGlobalReceiver(SyncmaticaPacket.Payload.ID, ClientPlayHandler::receiveSyncPayload);
            registerS2C = true;
        }
    }

    public void unregisterReceivers() {
        if (this.isServer()) {
            if (Reference.isServer() || Reference.isIntegratedServer() || Reference.isOpenToLan()) {
                Syncmatica.debug("Context#unregisterReceivers(): [SERVER] -> unregisterSyncmaticaHandlers", new Object[0]);
                ServerPlayNetworking.unregisterGlobalReceiver((class_2960)SyncmaticaPacket.Payload.ID.comp_2242());
                registerC2S = false;
            }
        } else if (Reference.isClient()) {
            Syncmatica.debug("Context#unregisterReceivers(): [CLIENT] -> unregisterSyncmaticaHandlers", new Object[0]);
            ClientPlayNetworking.unregisterGlobalReceiver((class_2960)SyncmaticaPacket.Payload.ID.comp_2242());
            registerS2C = false;
        }
    }

    public boolean checkPartnerVersion(String version) {
        return !version.equals("0.0.1");
    }

    public File getConfigFolder() {
        if (this.isServer() && this.isIntegratedServer()) {
            return new File(this.worldFolder, "syncmatica");
        }
        return new File(new File("."), "config" + File.separator + "syncmatica");
    }

    public File getConfigFile() {
        return new File(this.getConfigFolder(), "config.json");
    }

    @Nullable
    public File getAndCreateConfigFile() throws IOException {
        this.getConfigFolder().mkdirs();
        File configFile = this.getConfigFile();
        configFile.createNewFile();
        return configFile;
    }

    public void loadConfiguration() {
        JsonObject configuration;
        boolean attemptToLoad = false;
        try {
            configuration = (JsonObject)new Gson().fromJson((Reader)new BufferedReader(new FileReader(this.getConfigFile())), JsonObject.class);
            attemptToLoad = true;
        }
        catch (Exception ignored) {
            configuration = new JsonObject();
        }
        boolean needsRewrite = false;
        if (this.isServer()) {
            needsRewrite = this.loadConfigurationForService(this.quota, configuration, attemptToLoad);
        }
        if (needsRewrite |= this.loadConfigurationForService(this.debugService, configuration, attemptToLoad).booleanValue()) {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.getAndCreateConfigFile()));){
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                String jsonString = gson.toJson((JsonElement)configuration);
                writer.write(jsonString);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Boolean loadConfigurationForService(IService service, JsonObject configuration, boolean attemptToLoad) {
        String configKey = service.getConfigKey();
        JsonObject serviceJson = null;
        JsonConfiguration serviceConfiguration = null;
        boolean started = false;
        if (attemptToLoad && configuration.has(configKey)) {
            try {
                serviceJson = configuration.getAsJsonObject(configKey);
                if (serviceJson != null) {
                    serviceConfiguration = new JsonConfiguration(serviceJson);
                    service.configure(serviceConfiguration);
                    started = true;
                    if (!serviceConfiguration.hadError().booleanValue()) {
                        return false;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (serviceJson == null) {
            serviceJson = new JsonObject();
            configuration.add(configKey, (JsonElement)serviceJson);
        }
        if (serviceConfiguration == null) {
            serviceConfiguration = new JsonConfiguration(serviceJson);
        }
        service.getDefaultConfiguration(serviceConfiguration);
        if (!started) {
            service.configure(serviceConfiguration);
        }
        return true;
    }

    private void startupServices() {
        Syncmatica.debug("Context#startupServices()", new Object[0]);
        if (this.quota != null) {
            this.quota.startup();
        }
        this.debugService.startup();
    }

    private void shutdownServices() {
        Syncmatica.debug("Context#shutdownServices()", new Object[0]);
        if (this.quota != null) {
            this.quota.shutdown();
        }
        this.debugService.shutdown();
    }

    public static class ContextMismatchException
    extends RuntimeException {
        private static final long serialVersionUID = 2769376183212635479L;

        public ContextMismatchException(String reason) {
            super(reason);
        }
    }

    public static class DuplicateContextAssignmentException
    extends RuntimeException {
        private static final long serialVersionUID = -5147544661160756303L;

        public DuplicateContextAssignmentException(String reason) {
            super(reason);
        }
    }
}

