/*
 * Decompiled with CFR 0.152.
 */
package com.red.masaadditions.tweakeroo_additions.tweaks;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class InventoryTweaks {
    private static final Set<class_1792> SWAP_ALMOST_BROKEN_TOOLS_WHITELIST = Sets.newIdentityHashSet();
    private static final Set<class_1792> SWAP_ALMOST_BROKEN_TOOLS_BLACKLIST = Sets.newIdentityHashSet();

    public static void setSwapAlmostBrokenToolsWhitelist(List<String> whitelist) {
        InventoryTweaks.parseList(whitelist, SWAP_ALMOST_BROKEN_TOOLS_WHITELIST);
    }

    public static void setSwapAlmostBrokenToolsBlacklist(List<String> blacklist) {
        InventoryTweaks.parseList(blacklist, SWAP_ALMOST_BROKEN_TOOLS_BLACKLIST);
    }

    private static void parseList(List<String> list, Set<class_1792> set) {
        set.clear();
        for (String blockStr : list) {
            class_2960 id = class_2960.method_12829((String)blockStr);
            if (id == null) continue;
            class_7923.field_41178.method_17966(id).ifPresent(set::add);
        }
    }

    public static boolean canSwapAlmostBrokenTool(class_1792 item) {
        if (SWAP_ALMOST_BROKEN_TOOLS_BLACKLIST.contains(item)) {
            return false;
        }
        if (!SWAP_ALMOST_BROKEN_TOOLS_WHITELIST.isEmpty()) {
            return SWAP_ALMOST_BROKEN_TOOLS_WHITELIST.contains(item);
        }
        return true;
    }
}

