/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.util;

import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2495;
import net.minecraft.class_3341;

public class IntBoundingBox {
    public final int minX;
    public final int minY;
    public final int minZ;
    public final int maxX;
    public final int maxY;
    public final int maxZ;

    public IntBoundingBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public boolean containsPos(class_2382 pos) {
        return pos.method_10263() >= this.minX && pos.method_10263() <= this.maxX && pos.method_10260() >= this.minZ && pos.method_10260() <= this.maxZ && pos.method_10264() >= this.minY && pos.method_10264() <= this.maxY;
    }

    public boolean containsPos(long pos) {
        int x = class_2338.method_10061((long)pos);
        int y = class_2338.method_10071((long)pos);
        int z = class_2338.method_10083((long)pos);
        return x >= this.minX && y >= this.minY && z >= this.minZ && x <= this.maxX && y <= this.maxY && z <= this.maxZ;
    }

    public boolean intersects(IntBoundingBox box) {
        return this.maxX >= box.minX && this.minX <= box.maxX && this.maxZ >= box.minZ && this.minZ <= box.maxZ && this.maxY >= box.minY && this.minY <= box.maxY;
    }

    public int getMinValueForAxis(class_2350.class_2351 axis) {
        switch (axis) {
            case field_11048: {
                return this.minX;
            }
            case field_11052: {
                return this.minY;
            }
            case field_11051: {
                return this.minZ;
            }
        }
        return 0;
    }

    public int getMaxValueForAxis(class_2350.class_2351 axis) {
        switch (axis) {
            case field_11048: {
                return this.maxX;
            }
            case field_11052: {
                return this.maxY;
            }
            case field_11051: {
                return this.maxZ;
            }
        }
        return 0;
    }

    public class_3341 toVanillaBox() {
        return new class_3341(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public class_2495 toNBTIntArray() {
        return new class_2495(new int[]{this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ});
    }

    public static IntBoundingBox fromVanillaBox(class_3341 box) {
        return IntBoundingBox.createProper(box.method_35415(), box.method_35416(), box.method_35417(), box.method_35418(), box.method_35419(), box.method_35420());
    }

    public static IntBoundingBox createProper(int x1, int y1, int z1, int x2, int y2, int z2) {
        return new IntBoundingBox(Math.min(x1, x2), Math.min(y1, y2), Math.min(z1, z2), Math.max(x1, x2), Math.max(y1, y2), Math.max(z1, z2));
    }

    public static IntBoundingBox createForWorldBounds(@Nullable class_1937 world) {
        int worldMinH = -30000000;
        int worldMaxH = 30000000;
        int worldMinY = world != null ? world.method_31607() : -64;
        int worldMaxY = world != null ? world.method_31600() - 1 : 319;
        return new IntBoundingBox(worldMinH, worldMinY, worldMinH, worldMaxH, worldMaxY, worldMaxH);
    }

    public static IntBoundingBox fromArray(int[] coords) {
        if (coords.length == 6) {
            return new IntBoundingBox(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
        }
        return new IntBoundingBox(0, 0, 0, 0, 0, 0);
    }

    public IntBoundingBox expand(int amount) {
        return this.expand(amount, amount, amount);
    }

    public IntBoundingBox expand(int x, int y, int z) {
        return new IntBoundingBox(this.minX - x, this.minY - y, this.minZ - z, this.maxX + x, this.maxY + y, this.maxZ + z);
    }

    public IntBoundingBox shrink(int x, int y, int z) {
        return this.expand(-x, -y, -z);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.maxX;
        result = 31 * result + this.maxY;
        result = 31 * result + this.maxZ;
        result = 31 * result + this.minX;
        result = 31 * result + this.minY;
        result = 31 * result + this.minZ;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IntBoundingBox other = (IntBoundingBox)obj;
        return this.maxX == other.maxX && this.maxY == other.maxY && this.maxZ == other.maxZ && this.minX == other.minX && this.minY == other.minY && this.minZ == other.minZ;
    }
}

