/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.data;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.Reference;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.mixin.IMixinDataQueryHandler;
import fi.dy.masa.litematica.network.ServuxLitematicaHandler;
import fi.dy.masa.litematica.network.ServuxLitematicaPacket;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.malilib.interfaces.IClientTickHandler;
import fi.dy.masa.malilib.network.ClientPlayHandler;
import fi.dy.masa.malilib.network.IPluginClientPlayHandler;
import fi.dy.masa.malilib.util.NBTUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_634;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class EntitiesDataStorage
implements IClientTickHandler {
    private static final EntitiesDataStorage INSTANCE = new EntitiesDataStorage();
    private static final ServuxLitematicaHandler<ServuxLitematicaPacket.Payload> HANDLER = ServuxLitematicaHandler.getInstance();
    private static final class_310 mc = class_310.method_1551();
    private int uptimeTicks = 0;
    private boolean servuxServer = false;
    private boolean hasInValidServux = false;
    private String servuxVersion;
    private final long chunkTimeoutMs = 5000L;
    private long serverTickTime = 0L;
    private final Set<class_2338> pendingBlockEntitiesQueue = new LinkedHashSet<class_2338>();
    private final Set<Integer> pendingEntitiesQueue = new LinkedHashSet<Integer>();
    private final Set<class_1923> pendingChunks = new LinkedHashSet<class_1923>();
    private final Set<class_1923> completedChunks = new LinkedHashSet<class_1923>();
    private final Map<class_1923, Long> pendingChunkTimeout = new HashMap<class_1923, Long>();
    private final Map<Integer, Either<class_2338, Integer>> transactionToBlockPosOrEntityId = new HashMap<Integer, Either<class_2338, Integer>>();

    public static EntitiesDataStorage getInstance() {
        return INSTANCE;
    }

    @Nullable
    public class_1937 getWorld() {
        return EntitiesDataStorage.mc.field_1687;
    }

    private EntitiesDataStorage() {
    }

    public void onClientTick(class_310 mc) {
        ++this.uptimeTicks;
        if (System.currentTimeMillis() - this.serverTickTime > 50L) {
            if (!Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue()) {
                this.serverTickTime = System.currentTimeMillis();
                if (!DataManager.getInstance().hasIntegratedServer() && this.hasServuxServer()) {
                    this.servuxServer = false;
                    HANDLER.unregisterPlayReceiver();
                }
                return;
            }
            if (!(DataManager.getInstance().hasIntegratedServer() || this.hasServuxServer() || this.hasInValidServux || this.getWorld() == null)) {
                HANDLER.registerPlayReceiver(ServuxLitematicaPacket.Payload.ID, HANDLER::receivePlayPayload);
                this.requestMetadata();
            }
            for (int i = 0; i < Configs.Generic.SERVER_NBT_REQUEST_RATE.getIntegerValue(); ++i) {
                Iterator<Object> iter;
                if (!this.pendingBlockEntitiesQueue.isEmpty()) {
                    iter = this.pendingBlockEntitiesQueue.iterator();
                    class_2338 pos = iter.next();
                    iter.remove();
                    if (this.hasServuxServer()) {
                        this.requestServuxBlockEntityData(pos);
                    } else {
                        this.requestQueryBlockEntity(pos);
                    }
                }
                if (this.pendingEntitiesQueue.isEmpty()) continue;
                iter = this.pendingEntitiesQueue.iterator();
                int entityId = (Integer)iter.next();
                iter.remove();
                if (this.hasServuxServer()) {
                    this.requestServuxEntityData(entityId);
                    continue;
                }
                this.requestQueryEntityData(entityId);
            }
            this.serverTickTime = System.currentTimeMillis();
        }
    }

    public class_2960 getNetworkChannel() {
        return ServuxLitematicaHandler.CHANNEL_ID;
    }

    private static class_634 getVanillaHandler() {
        if (EntitiesDataStorage.mc.field_1724 != null) {
            return EntitiesDataStorage.mc.field_1724.field_3944;
        }
        return null;
    }

    public IPluginClientPlayHandler<ServuxLitematicaPacket.Payload> getNetworkHandler() {
        return HANDLER;
    }

    public void reset(boolean isLogout) {
        if (isLogout) {
            Litematica.debugLog("EntitiesDataStorage#reset() - log-out", new Object[0]);
            HANDLER.reset(this.getNetworkChannel());
            HANDLER.resetFailures(this.getNetworkChannel());
            this.servuxServer = false;
            this.hasInValidServux = false;
        } else {
            Litematica.debugLog("EntitiesDataStorage#reset() - dimension change or log-in", new Object[0]);
        }
    }

    public void setIsServuxServer() {
        this.servuxServer = true;
        this.hasInValidServux = false;
    }

    public boolean hasServuxServer() {
        return this.servuxServer;
    }

    public void setServuxVersion(String ver) {
        if (ver != null && !ver.isEmpty()) {
            this.servuxVersion = ver;
            Litematica.debugLog("entityDataChannel: joining Servux version {}", ver);
        } else {
            this.servuxVersion = "unknown";
        }
    }

    public void onGameInit() {
        ClientPlayHandler.getInstance().registerClientPlayHandler(HANDLER);
        HANDLER.registerPlayPayload(ServuxLitematicaPacket.Payload.ID, ServuxLitematicaPacket.Payload.CODEC, 6);
    }

    public void onWorldPre() {
        if (!DataManager.getInstance().hasIntegratedServer()) {
            HANDLER.registerPlayReceiver(ServuxLitematicaPacket.Payload.ID, HANDLER::receivePlayPayload);
        }
    }

    public void onWorldJoin() {
    }

    public void requestMetadata() {
        if (!DataManager.getInstance().hasIntegratedServer() && Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue()) {
            class_2487 nbt = new class_2487();
            nbt.method_10582("version", Reference.MOD_STRING);
            HANDLER.encodeClientData(ServuxLitematicaPacket.MetadataRequest(nbt));
        }
    }

    public boolean receiveServuxMetadata(class_2487 data) {
        if (!DataManager.getInstance().hasIntegratedServer()) {
            Litematica.debugLog("EntitiesDataStorage#receiveServuxMetadata(): received METADATA from Servux", new Object[0]);
            if (Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue()) {
                if (data.method_10550("version") != 1) {
                    Litematica.logger.warn("entityDataChannel: Mis-matched protocol version!");
                }
                this.setServuxVersion(data.method_10558("servux"));
                this.setIsServuxServer();
                return true;
            }
        }
        return false;
    }

    public void onPacketFailure() {
        this.servuxServer = false;
        this.hasInValidServux = true;
    }

    public void requestBlockEntity(class_1937 world, class_2338 pos) {
        if (world.method_8320(pos).method_26204() instanceof class_2343) {
            this.pendingBlockEntitiesQueue.add(pos);
        }
    }

    public void requestEntity(int entityId) {
        this.pendingEntitiesQueue.add(entityId);
    }

    private void requestQueryBlockEntity(class_2338 pos) {
        if (!Configs.Generic.ENTITY_DATA_SYNC_BACKUP.getBooleanValue()) {
            return;
        }
        class_634 handler = this.getVanillaHandler();
        if (handler != null) {
            handler.method_2876().method_1403(pos, nbtCompound -> this.handleBlockEntityData(pos, (class_2487)nbtCompound, null));
            this.transactionToBlockPosOrEntityId.put(((IMixinDataQueryHandler)handler.method_2876()).currentTransactionId(), (Either<class_2338, Integer>)Either.left((Object)pos));
        }
    }

    private void requestQueryEntityData(int entityId) {
        if (!Configs.Generic.ENTITY_DATA_SYNC_BACKUP.getBooleanValue()) {
            return;
        }
        class_634 handler = EntitiesDataStorage.getVanillaHandler();
        if (handler != null) {
            handler.method_2876().method_1405(entityId, nbtCompound -> this.handleEntityData(entityId, (class_2487)nbtCompound));
            this.transactionToBlockPosOrEntityId.put(((IMixinDataQueryHandler)handler.method_2876()).currentTransactionId(), (Either<class_2338, Integer>)Either.right((Object)entityId));
        }
    }

    private void requestServuxBlockEntityData(class_2338 pos) {
        if (!Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue()) {
            return;
        }
        HANDLER.encodeClientData(ServuxLitematicaPacket.BlockEntityRequest(pos));
    }

    private void requestServuxEntityData(int entityId) {
        if (!Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue()) {
            return;
        }
        HANDLER.encodeClientData(ServuxLitematicaPacket.EntityRequest(entityId));
    }

    public void requestServuxBulkEntityData(class_1923 chunkPos, int minY, int maxY) {
        if (!this.hasServuxServer()) {
            return;
        }
        class_2487 req = new class_2487();
        this.completedChunks.remove(chunkPos);
        this.pendingChunks.add(chunkPos);
        this.pendingChunkTimeout.put(chunkPos, class_156.method_658());
        minY = class_3532.method_15340((int)minY, (int)-60, (int)319);
        maxY = class_3532.method_15340((int)maxY, (int)-60, (int)319);
        req.method_10582("Task", "BulkEntityRequest");
        req.method_10569("minY", minY);
        req.method_10569("maxY", maxY);
        Litematica.debugLog("EntitiesDataStorage#requestServuxBulkEntityData(): for chunkPos [{}] to Servux (minY [{}], maxY [{}])", chunkPos.toString(), minY, maxY);
        HANDLER.encodeClientData(ServuxLitematicaPacket.BulkNbtRequest(chunkPos, req));
    }

    @Nullable
    public class_2586 handleBlockEntityData(class_2338 pos, class_2487 nbt, @Nullable class_2960 type) {
        class_2586 blockEntity2;
        this.pendingBlockEntitiesQueue.remove(pos);
        if (nbt == null || this.getWorld() == null) {
            return null;
        }
        class_2586 blockEntity = this.getWorld().method_8321(pos);
        if (blockEntity != null && (type == null || type.equals((Object)class_2591.method_11033((class_2591)blockEntity.method_11017())))) {
            blockEntity.method_58690(nbt, (class_7225.class_7874)this.getWorld().method_30349());
            return blockEntity;
        }
        class_2591 beType = (class_2591)class_7923.field_41181.method_10223(type);
        if (beType != null && beType.method_20526(this.getWorld().method_8320(pos)) && (blockEntity2 = beType.method_11032(pos, this.getWorld().method_8320(pos))) != null) {
            blockEntity2.method_58690(nbt, (class_7225.class_7874)this.getWorld().method_30349());
            this.getWorld().method_8438(blockEntity2);
            return blockEntity2;
        }
        return null;
    }

    @Nullable
    public class_1297 handleEntityData(int entityId, class_2487 nbt) {
        this.pendingEntitiesQueue.remove(entityId);
        if (nbt == null || this.getWorld() == null) {
            return null;
        }
        class_1297 entity = this.getWorld().method_8469(entityId);
        if (entity != null) {
            EntityUtils.loadNbtIntoEntity(entity, nbt);
        }
        return entity;
    }

    public void handleBulkEntityData(int transactionId, @Nullable class_2487 nbt) {
        if (nbt == null) {
            return;
        }
        if (nbt.method_10545("Task") && nbt.method_10558("Task").equals("BulkEntityReply") || !nbt.method_10545("Task")) {
            class_2338 pos;
            int i;
            class_2499 tileList = nbt.method_10545("TileEntities") ? nbt.method_10554("TileEntities", 10) : new class_2499();
            class_2499 entityList = nbt.method_10545("Entities") ? nbt.method_10554("Entities", 10) : new class_2499();
            class_1923 chunkPos = new class_1923(nbt.method_10550("chunkX"), nbt.method_10550("chunkZ"));
            for (i = 0; i < tileList.size(); ++i) {
                class_2487 te = tileList.method_10602(i);
                pos = NBTUtils.readBlockPos((class_2487)te);
                class_2960 type = class_2960.method_60654((String)te.method_10558("id"));
                this.handleBlockEntityData(pos, te, type);
            }
            for (i = 0; i < entityList.size(); ++i) {
                class_2487 ent = entityList.method_10602(i);
                pos = NBTUtils.readEntityPositionFromTag((class_2487)ent);
                int entityId = ent.method_10550("entityId");
                this.handleEntityData(entityId, ent);
            }
            this.pendingChunks.remove(chunkPos);
            this.pendingChunkTimeout.remove(chunkPos);
            this.completedChunks.add(chunkPos);
            Litematica.debugLog("EntitiesDataStorage#handleBulkEntityData(): [ChunkPos {}] received TE: [{}], and E: [{}] entiries from Servux", chunkPos.toString(), tileList.size(), entityList.size());
        }
    }

    public void handleVanillaQueryNbt(int transactionId, class_2487 nbt) {
        Either<class_2338, Integer> either = this.transactionToBlockPosOrEntityId.remove(transactionId);
        if (either != null) {
            either.ifLeft(pos -> this.handleBlockEntityData((class_2338)pos, nbt, null)).ifRight(entityId -> this.handleEntityData((int)entityId, nbt));
        }
    }

    public boolean hasPendingChunk(class_1923 pos) {
        if (this.hasServuxServer()) {
            return this.pendingChunks.contains(pos);
        }
        return false;
    }

    private void checkForPendingChunkTimeout(class_1923 pos) {
        if (this.hasServuxServer() && this.hasPendingChunk(pos)) {
            long now = class_156.method_658();
            if (!WorldUtils.isClientChunkLoaded(EntitiesDataStorage.mc.field_1687, pos.field_9181, pos.field_9180)) {
                this.pendingChunkTimeout.replace(pos, now);
                return;
            }
            long duration = now - this.pendingChunkTimeout.get(pos);
            if (duration > this.chunkTimeoutMs) {
                this.pendingChunkTimeout.remove(pos);
                this.pendingChunks.remove(pos);
                this.completedChunks.add(pos);
            }
        }
    }

    public boolean hasCompletedChunk(class_1923 pos) {
        if (this.hasServuxServer()) {
            this.checkForPendingChunkTimeout(pos);
            return this.completedChunks.contains(pos);
        }
        return true;
    }

    public void markCompletedChunkDirty(class_1923 pos) {
        if (this.hasServuxServer()) {
            this.completedChunks.remove(pos);
        }
    }

    public JsonObject toJson() {
        return new JsonObject();
    }

    public void fromJson(JsonObject obj) {
    }
}

