/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.util.io.http;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class TcdWebApiPerson {
    private final JsonObject data;
    private final String name;
    @Nullable
    private final URL avatarUrl;
    private final TcdContactInformation contact;

    public TcdWebApiPerson(JsonObject data) throws IOException {
        this.data = Objects.requireNonNull(data).deepCopy();
        try {
            this.name = this.data.get("name").getAsString();
            this.contact = new TcdContactInformation(this);
            this.avatarUrl = this.data.has("avatar_url") ? URI.create(this.data.get("avatar_url").getAsString()).toURL() : (this.contact.getJson().has("avatar_url") ? URI.create(this.contact.getJson().get("avatar_url").getAsString()).toURL() : null);
        }
        catch (Exception e) {
            throw new IOException("Failed to read JSON data.", e);
        }
    }

    public final JsonObject getJson() {
        return this.data;
    }

    public final String getName() {
        return this.name;
    }

    @Nullable
    public final URL getAvatarUrl() {
        return this.avatarUrl;
    }

    public final TcdContactInformation getContact() {
        return this.contact;
    }

    public final class TcdContactInformation {
        private final JsonObject data;
        @Nullable
        private final URL homepageUrl;

        private TcdContactInformation(TcdWebApiPerson this$0) throws IOException {
            try {
                this.data = Objects.requireNonNull(this$0.data.get("contact").getAsJsonObject());
                URL homepage = null;
                if (this.data.has("homepage")) {
                    try {
                        homepage = URI.create(this.data.get("homepage").getAsString()).toURL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.homepageUrl = homepage;
            }
            catch (Exception e) {
                throw new IOException("Failed to load JSON data.", e);
            }
        }

        public final JsonObject getJson() {
            return this.data;
        }

        @Nullable
        public final URL getHomepageUrl() {
            return this.homepageUrl;
        }
    }
}

