/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.utils.deobfuscator;

import carpettisaddition.translations.Translator;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.deobfuscator.StackTraceDeobfuscator;
import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class StackTracePrinter {
    private static final int DEFAULT_MAX_STACK_TRACE_SIZE = 64;
    private static final Translator translator = StackTraceDeobfuscator.translator;
    private StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
    private int maxStackTraceSize = 64;
    private String ignorePackagePath;

    private StackTracePrinter() {
    }

    public static StackTracePrinter create() {
        return new StackTracePrinter();
    }

    public static class_5250 makeSymbol(Class<?> ignoreClass) {
        return StackTracePrinter.create().ignore(ignoreClass).deobfuscate().toSymbolText();
    }

    public StackTracePrinter limit(int maxStackTraceSize) {
        this.maxStackTraceSize = maxStackTraceSize;
        return this;
    }

    public StackTracePrinter ignore(String ignorePackagePath) {
        this.ignorePackagePath = ignorePackagePath;
        return this;
    }

    public StackTracePrinter ignore(Class<?> ignoreClass) {
        return this.ignore(ignoreClass.getPackage().getName());
    }

    public StackTracePrinter deobfuscate() {
        this.stackTrace = StackTraceDeobfuscator.deobfuscateStackTrace(this.stackTrace, this.ignorePackagePath);
        return this;
    }

    public StackTraceElement[] toStackTraceElements() {
        return this.stackTrace;
    }

    @Deprecated
    public class_5250 toBaseText() {
        List<StackTraceElement> list = Arrays.asList(this.stackTrace).subList(0, Integer.min(this.stackTrace.length, this.maxStackTraceSize));
        int restLineCount = this.stackTrace.length - this.maxStackTraceSize;
        class_5250 text = Messenger.c(translator.tr("deobfuscated_stack_trace", new Object[0]), Messenger.s(String.format(" (%s)\n", StackTraceDeobfuscator.MAPPING_VERSION)));
        text.method_10852((class_2561)Messenger.s(Joiner.on((String)"\n").join(list)));
        if (restLineCount > 0) {
            text.method_10852((class_2561)Messenger.c("w \n", translator.tr("n_more_lines", restLineCount)));
        }
        return text;
    }

    public class_5250 toSymbolText() {
        class_5250 baseText = this.toBaseText();
        return Messenger.fancy("f", Messenger.s("$"), baseText, new class_2558(class_2558.class_2559.field_21462, baseText.getString()));
    }
}

