/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.utils;

import carpettisaddition.CarpetTISAdditionServer;
import carpettisaddition.mixins.translations.StyleAccessor;
import carpettisaddition.mixins.translations.TranslatableTextAccessor;
import carpettisaddition.mixins.utils.DyeColorAccessor;
import carpettisaddition.translations.Translator;
import carpettisaddition.utils.IdentifierUtil;
import carpettisaddition.utils.TextUtil;
import carpettisaddition.utils.compat.DimensionWrapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2590;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_6880;
import net.minecraft.class_7417;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Messenger {
    private static final Translator translator = new Translator("util");
    private static final ImmutableMap<class_1767, Consumer<class_5250>> DYE_COLOR_APPLIER = (ImmutableMap)class_156.method_656(() -> {
        HashMap map = Maps.newHashMap();
        map.put(class_1767.field_7952, class_124.field_1068);
        map.put(class_1767.field_7967, class_124.field_1080);
        map.put(class_1767.field_7944, class_124.field_1063);
        map.put(class_1767.field_7963, class_124.field_1074);
        map.put(class_1767.field_7964, class_124.field_1061);
        map.put(class_1767.field_7947, class_124.field_1054);
        map.put(class_1767.field_7961, class_124.field_1060);
        map.put(class_1767.field_7942, class_124.field_1077);
        map.put(class_1767.field_7955, class_124.field_1062);
        map.put(class_1767.field_7951, class_124.field_1075);
        map.put(class_1767.field_7966, class_124.field_1058);
        map.put(class_1767.field_7945, class_124.field_1064);
        map.put(class_1767.field_7958, class_124.field_1076);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        map.forEach((dyeColor, fmt) -> builder.put(dyeColor, text -> Messenger.formatting(text, fmt)));
        Arrays.stream(class_1767.values()).filter(dyeColor -> !map.containsKey(dyeColor)).forEach(dyeColor -> builder.put(dyeColor, text -> {
            class_5251 color = class_5251.method_27717((int)((DyeColorAccessor)dyeColor).getSignColor$TISCM());
            text.method_10862(text.method_10866().method_27703(color));
        }));
        return builder.build();
    });
    private static final ImmutableMap<DimensionWrapper, class_5250> DIMENSION_NAME = ImmutableMap.of((Object)DimensionWrapper.OVERWORLD, (Object)Messenger.tr("flat_world_preset.minecraft.overworld", new Object[0]), (Object)DimensionWrapper.THE_NETHER, (Object)Messenger.tr("advancements.nether.root.title", new Object[0]), (Object)DimensionWrapper.THE_END, (Object)Messenger.tr("advancements.end.root.title", new Object[0]));

    public static class_7417 getTextContent(class_5250 text) {
        return text.method_10851();
    }

    public static class_5250 c(Object ... fields) {
        return (class_5250)carpet.utils.Messenger.c((Object[])fields);
    }

    public static class_5250 s(Object text) {
        return class_2561.method_43470((String)text.toString());
    }

    public static class_5250 s(Object text, String carpetStyle) {
        return Messenger.formatting(Messenger.s(text), carpetStyle);
    }

    public static class_5250 s(Object text, class_124 ... textFormattings) {
        return Messenger.formatting(Messenger.s(text), textFormattings);
    }

    public static class_5250 newLine() {
        return Messenger.s("\n");
    }

    public static class_5250 colored(class_5250 text, class_1767 value) {
        Consumer consumer = (Consumer)DYE_COLOR_APPLIER.get((Object)value);
        if (consumer != null) {
            consumer.accept(text);
        }
        return text;
    }

    public static class_5250 colored(class_5250 text, Object value) {
        class_124 color = null;
        if (Boolean.TRUE.equals(value)) {
            color = class_124.field_1060;
        } else if (Boolean.FALSE.equals(value)) {
            color = class_124.field_1061;
        }
        if (value instanceof Number) {
            color = class_124.field_1065;
        }
        if (color != null) {
            Messenger.formatting(text, color);
        }
        return text;
    }

    public static class_5250 colored(Object value) {
        return Messenger.colored(Messenger.s(value), value);
    }

    public static class_5250 property(class_2769<?> property, Object value) {
        return Messenger.colored(Messenger.s(TextUtil.property(property, value)), value);
    }

    public static class_5250 tr(String key, Object ... args) {
        return class_2561.method_43469((String)key, (Object[])args);
    }

    public static class_5250 fancy(@Nullable String carpetStyle, @NotNull class_5250 displayText, @Nullable class_5250 hoverText, @Nullable class_2558 clickEvent) {
        class_5250 text = Messenger.copy(displayText);
        if (carpetStyle != null) {
            text.method_10862(Messenger.parseCarpetStyle(carpetStyle));
        }
        if (hoverText != null) {
            Messenger.hover(text, hoverText);
        }
        if (clickEvent != null) {
            Messenger.click(text, clickEvent);
        }
        return text;
    }

    public static class_5250 fancy(class_5250 displayText, class_5250 hoverText, class_2558 clickEvent) {
        return Messenger.fancy(null, displayText, hoverText, clickEvent);
    }

    public static class_5250 join(class_5250 joiner, Iterable<class_5250> items) {
        class_5250 text = Messenger.s("");
        boolean first = true;
        for (class_5250 item : items) {
            if (!first) {
                text.method_10852((class_2561)joiner);
            }
            first = false;
            text.method_10852((class_2561)item);
        }
        return text;
    }

    public static class_5250 join(class_5250 joiner, class_5250 ... items) {
        return Messenger.join(joiner, Arrays.asList(items));
    }

    public static class_5250 joinLines(Iterable<class_5250> items) {
        return Messenger.join(Messenger.newLine(), items);
    }

    public static class_5250 joinLines(class_5250 ... items) {
        return Messenger.join(Messenger.newLine(), items);
    }

    public static class_5250 format(String formatter, Object ... args) {
        TranslatableTextAccessor dummy = (TranslatableTextAccessor)Messenger.tr(formatter, args).method_10851();
        try {
            ArrayList segments = Lists.newArrayList();
            dummy.invokeForEachPart(formatter, segments::add);
            return Messenger.c(segments.stream().map(stringVisitable -> {
                if (stringVisitable instanceof class_2561) {
                    return (class_2561)stringVisitable;
                }
                return Messenger.s(stringVisitable.getString());
            }).toArray());
        }
        catch (class_2590 e) {
            throw new IllegalArgumentException(formatter);
        }
    }

    public static class_5250 bool(boolean value) {
        return Messenger.s((Object)String.valueOf(value), value ? class_124.field_1060 : class_124.field_1061);
    }

    private static class_5250 getTeleportHint(class_5250 dest) {
        return translator.tr("teleport_hint", dest);
    }

    private static class_5250 __coord(String style, @Nullable DimensionWrapper dim, String posStr, String command) {
        class_5250 hoverText = Messenger.s("");
        hoverText.method_10852((class_2561)Messenger.getTeleportHint(Messenger.s(posStr)));
        if (dim != null) {
            hoverText.method_27693("\n");
            hoverText.method_10852((class_2561)translator.tr("teleport_hint.dimension", new Object[0]));
            hoverText.method_27693(": ");
            hoverText.method_10852((class_2561)Messenger.dimension(dim));
        }
        return Messenger.fancy(style, Messenger.s(posStr), hoverText, new class_2558(class_2558.class_2559.field_11745, command));
    }

    public static class_5250 coord(String style, class_243 pos, DimensionWrapper dim) {
        return Messenger.__coord(style, dim, TextUtil.coord(pos), TextUtil.tp(pos, dim));
    }

    public static class_5250 coord(String style, class_2382 pos, DimensionWrapper dim) {
        return Messenger.__coord(style, dim, TextUtil.coord(pos), TextUtil.tp(pos, dim));
    }

    public static class_5250 coord(String style, class_1923 pos, DimensionWrapper dim) {
        return Messenger.__coord(style, dim, TextUtil.coord(pos), TextUtil.tp(pos, dim));
    }

    public static class_5250 coord(String style, class_243 pos) {
        return Messenger.__coord(style, null, TextUtil.coord(pos), TextUtil.tp(pos));
    }

    public static class_5250 coord(String style, class_2382 pos) {
        return Messenger.__coord(style, null, TextUtil.coord(pos), TextUtil.tp(pos));
    }

    public static class_5250 coord(String style, class_1923 pos) {
        return Messenger.__coord(style, null, TextUtil.coord(pos), TextUtil.tp(pos));
    }

    public static class_5250 coord(class_243 pos, DimensionWrapper dim) {
        return Messenger.coord(null, pos, dim);
    }

    public static class_5250 coord(class_2382 pos, DimensionWrapper dim) {
        return Messenger.coord(null, pos, dim);
    }

    public static class_5250 coord(class_1923 pos, DimensionWrapper dim) {
        return Messenger.coord(null, pos, dim);
    }

    public static class_5250 coord(class_243 pos) {
        return Messenger.coord(null, pos);
    }

    public static class_5250 coord(class_2382 pos) {
        return Messenger.coord(null, pos);
    }

    public static class_5250 coord(class_1923 pos) {
        return Messenger.coord(null, pos);
    }

    private static class_5250 __vector(String style, String displayText, String detailedText) {
        return Messenger.fancy(style, Messenger.s(displayText), Messenger.s(detailedText), new class_2558(class_2558.class_2559.field_11745, detailedText));
    }

    public static class_5250 vector(String style, class_243 vec) {
        return Messenger.__vector(style, TextUtil.vector(vec), TextUtil.vector(vec, 6));
    }

    public static class_5250 vector(class_243 vec) {
        return Messenger.vector(null, vec);
    }

    public static class_5250 entityType(class_1299<?> entityType) {
        return (class_5250)entityType.method_5897();
    }

    public static class_5250 entityType(class_1297 entity) {
        return Messenger.entityType(entity.method_5864());
    }

    public static class_5250 entity(String style, class_1297 entity) {
        class_5250 entityBaseName = Messenger.entityType(entity);
        class_5250 entityDisplayName = (class_5250)entity.method_5477();
        class_5250 hoverText = Messenger.c(translator.tr("entity_type", entityBaseName, Messenger.s(class_1299.method_5890((class_1299)entity.method_5864()).toString())), Messenger.newLine(), Messenger.getTeleportHint(entityDisplayName));
        return Messenger.fancy(style, entityDisplayName, hoverText, new class_2558(class_2558.class_2559.field_11745, TextUtil.tp(entity)));
    }

    public static class_5250 entity(class_1297 entity) {
        return Messenger.entity(null, entity);
    }

    public static class_5250 attribute(class_1320 attribute) {
        return Messenger.tr(attribute.method_26830(), new Object[0]);
    }

    public static class_5250 attribute(class_6880<class_1320> attribute) {
        return Messenger.attribute((class_1320)attribute.comp_349());
    }

    public static class_5250 dimension(DimensionWrapper dim) {
        class_5250 dimText = (class_5250)DIMENSION_NAME.get((Object)dim);
        return dimText != null ? Messenger.copy(dimText) : Messenger.s(dim.getIdentifierString());
    }

    public static class_5250 getColoredDimensionSymbol(DimensionWrapper dimensionType) {
        if (dimensionType.equals(DimensionWrapper.OVERWORLD)) {
            return Messenger.s((Object)"O", class_124.field_1077);
        }
        if (dimensionType.equals(DimensionWrapper.THE_NETHER)) {
            return Messenger.s((Object)"N", class_124.field_1079);
        }
        if (dimensionType.equals(DimensionWrapper.THE_END)) {
            return Messenger.s((Object)"E", class_124.field_1064);
        }
        return Messenger.s(dimensionType.getIdentifierString().toUpperCase().substring(0, 1));
    }

    public static class_5250 block(class_2248 block) {
        return Messenger.hover(Messenger.tr(block.method_9539(), new Object[0]), Messenger.s(TextUtil.block(block)));
    }

    public static class_5250 block(class_2680 blockState) {
        ArrayList hovers = Lists.newArrayList();
        hovers.add(Messenger.s(TextUtil.block(blockState.method_26204())));
        for (class_2769 property : blockState.method_28501()) {
            hovers.add(Messenger.c(Messenger.s(property.method_11899()), "g : ", Messenger.property(property, blockState.method_11654(property))));
        }
        return Messenger.fancy(Messenger.block(blockState.method_26204()), Messenger.join(Messenger.s("\n"), hovers.toArray(new class_5250[0])), new class_2558(class_2558.class_2559.field_11745, TextUtil.block(blockState)));
    }

    public static class_5250 fluid(class_3611 fluid) {
        return Messenger.hover(Messenger.block(fluid.method_15785().method_15759().method_26204()), Messenger.s(IdentifierUtil.id(fluid).toString()));
    }

    public static class_5250 fluid(class_3610 fluid) {
        return Messenger.fluid(fluid.method_15772());
    }

    public static class_5250 blockEntity(class_2586 blockEntity) {
        class_2960 id = IdentifierUtil.id(blockEntity.method_11017());
        return Messenger.s(id != null ? id.toString() : blockEntity.getClass().getSimpleName());
    }

    public static class_5250 item(class_1792 item) {
        return Messenger.tr(item.method_7876(), new Object[0]);
    }

    public static class_5250 color(class_1767 color) {
        return translator.tr("color." + color.method_7792().toLowerCase(), new Object[0]);
    }

    public static class_5250 hover(class_5250 text, class_2568 hoverEvent) {
        Messenger.style(text, text.method_10866().method_10949(hoverEvent));
        return text;
    }

    public static class_5250 hover(class_5250 text, class_5250 hoverText) {
        return Messenger.hover(text, new class_2568(class_2568.class_5247.field_24342, (Object)hoverText));
    }

    public static class_5250 click(class_5250 text, class_2558 clickEvent) {
        Messenger.style(text, text.method_10866().method_10958(clickEvent));
        return text;
    }

    public static class_5250 formatting(class_5250 text, class_124 ... formattings) {
        text.method_27695(formattings);
        return text;
    }

    public static class_5250 formatting(class_5250 text, String carpetStyle) {
        class_2583 textStyle = text.method_10866();
        StyleAccessor parsedStyle = (StyleAccessor)Messenger.parseCarpetStyle(carpetStyle);
        textStyle = textStyle.method_27703(parsedStyle.getColorField());
        textStyle = textStyle.method_10982(parsedStyle.getBoldField());
        textStyle = textStyle.method_10978(parsedStyle.getItalicField());
        ((StyleAccessor)textStyle).setUnderlinedField(parsedStyle.getUnderlineField());
        ((StyleAccessor)textStyle).setStrikethroughField(parsedStyle.getStrikethroughField());
        ((StyleAccessor)textStyle).setObfuscatedField(parsedStyle.getObfuscatedField());
        return Messenger.style(text, textStyle);
    }

    public static class_5250 style(class_5250 text, class_2583 style) {
        text.method_10862(style);
        return text;
    }

    public static class_5250 copy(class_5250 text) {
        class_5250 copied = text.method_27661();
        if (Messenger.getTextContent(copied) instanceof class_2588) {
            class_2588 translatableText = (class_2588)Messenger.getTextContent(copied);
            Object[] args = (Object[])translatableText.method_11023().clone();
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof class_5250)) continue;
                args[i] = Messenger.copy((class_5250)args[i]);
            }
            ((TranslatableTextAccessor)translatableText).setArgs(args);
        }
        return copied;
    }

    private static void __tell(class_2168 source, class_5250 text, boolean broadcastToOps) {
        source.method_9226(() -> text, broadcastToOps);
    }

    public static void tell(class_2168 source, class_5250 text, boolean broadcastToOps) {
        Messenger.__tell(source, text, broadcastToOps);
    }

    public static void tell(class_1657 player, class_5250 text, boolean broadcastToOps) {
        Messenger.tell(player.method_5671(), text, broadcastToOps);
    }

    public static void tell(class_2168 source, class_5250 text) {
        Messenger.tell(source, text, false);
    }

    public static void tell(class_1657 player, class_5250 text) {
        Messenger.tell(player, text, false);
    }

    public static void tell(class_2168 source, Iterable<class_5250> texts, boolean broadcastToOps) {
        texts.forEach(text -> Messenger.tell(source, text, broadcastToOps));
    }

    public static void tell(class_1657 player, Iterable<class_5250> texts, boolean broadcastToOps) {
        texts.forEach(text -> Messenger.tell(player, text, broadcastToOps));
    }

    public static void tell(class_2168 source, Iterable<class_5250> texts) {
        Messenger.tell(source, texts, false);
    }

    public static void tell(class_1657 player, Iterable<class_5250> texts) {
        Messenger.tell(player, texts, false);
    }

    public static void reminder(class_1657 player, class_5250 text) {
        player.method_7353((class_2561)text, true);
    }

    public static void sendToConsole(class_5250 text) {
        if (CarpetTISAdditionServer.minecraft_server != null) {
            CarpetTISAdditionServer.minecraft_server.method_43496((class_2561)text);
        }
    }

    public static void broadcast(class_5250 text) {
        Messenger.sendToConsole(text);
        if (CarpetTISAdditionServer.minecraft_server != null) {
            CarpetTISAdditionServer.minecraft_server.method_3760().method_14571().forEach(player -> Messenger.tell((class_1657)player, text));
        }
    }

    public static class_2583 parseCarpetStyle(String style) {
        return carpet.utils.Messenger.parseStyle((String)style);
    }

    public static class_5250 getSpaceText() {
        return translator.tr("language.space", new Object[0]);
    }
}

