/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;

public class FileUtil {
    public static void touchFileDirectory(File file) throws IOException {
        FileUtil.touchDirectory(file.getParentFile());
    }

    public static void touchDirectory(File dir) throws IOException {
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new IOException("Directory creation failed");
            }
        } else if (!dir.isDirectory()) {
            throw new IOException("Directory exists but it's not a directory");
        }
    }

    public static boolean isFile(File file) {
        return file.exists() && file.isFile();
    }

    public static boolean isFile(String fileName) {
        return FileUtil.isFile(new File(fileName));
    }

    public static String readResourceFileAsString(String path) throws IOException {
        InputStream inputStream = FileUtil.class.getClassLoader().getResourceAsStream(path);
        if (inputStream == null) {
            throw new IOException("Null input stream from path " + path);
        }
        return IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
    }
}

