/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.settings.validator;

import carpettisaddition.settings.validator.AbstractCheckerValidator;
import carpettisaddition.settings.validator.RangedNumberValidator;
import carpettisaddition.settings.validator.ValidationContext;
import net.minecraft.class_5250;

public class Validators {

    public static class Probability
    extends RangedNumberValidator<Double> {
        public Probability() {
            super(0.0, 1.0);
        }
    }

    public static class NonPositiveNumber<T extends Number>
    extends AbstractCheckerValidator<T> {
        @Override
        protected boolean validateValue(T value) {
            return ((Number)value).doubleValue() <= 0.0;
        }

        @Override
        public class_5250 errorMessage(ValidationContext<T> ctx) {
            return NonPositiveNumber.tr("positive_number.message", new Object[0]);
        }
    }

    public static class NonNegativeNumber<T extends Number>
    extends AbstractCheckerValidator<T> {
        @Override
        protected boolean validateValue(T value) {
            return ((Number)value).doubleValue() >= 0.0;
        }

        @Override
        public class_5250 errorMessage(ValidationContext<T> ctx) {
            return NonNegativeNumber.tr("non_negative_number.message", new Object[0]);
        }
    }

    public static class PositiveNumber<T extends Number>
    extends AbstractCheckerValidator<T> {
        @Override
        protected boolean validateValue(T value) {
            return ((Number)value).doubleValue() > 0.0;
        }

        @Override
        public class_5250 errorMessage(ValidationContext<T> ctx) {
            return PositiveNumber.tr("positive_number.message", new Object[0]);
        }
    }

    public static class NegativeNumber<T extends Number>
    extends AbstractCheckerValidator<T> {
        @Override
        protected boolean validateValue(T value) {
            return ((Number)value).doubleValue() < 0.0;
        }

        @Override
        public class_5250 errorMessage(ValidationContext<T> ctx) {
            return NegativeNumber.tr("negative_number.message", new Object[0]);
        }
    }
}

