/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.network;

import carpettisaddition.CarpetTISAdditionServer;
import carpettisaddition.commands.speedtest.SpeedTestCommand;
import carpettisaddition.helpers.rule.syncServerMsptMetricsData.ServerMsptMetricsDataSyncer;
import carpettisaddition.network.HandlerContext;
import carpettisaddition.network.TISCMCustomPayload;
import carpettisaddition.network.TISCMNetworkUtils;
import carpettisaddition.network.TISCMProtocol;
import carpettisaddition.utils.NbtUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_7648;
import org.apache.logging.log4j.Logger;

public class TISCMClientPacketHandler {
    private static final Logger LOGGER = CarpetTISAdditionServer.LOGGER;
    private static final TISCMClientPacketHandler INSTANCE = new TISCMClientPacketHandler();
    private final Map<TISCMProtocol.S2C, Consumer<HandlerContext.S2C>> handlers = new EnumMap<TISCMProtocol.S2C, Consumer<HandlerContext.S2C>>(TISCMProtocol.S2C.class);
    private final Map<TISCMProtocol.S2C, Consumer<HandlerContext.S2C>> asyncHandlers = new EnumMap<TISCMProtocol.S2C, Consumer<HandlerContext.S2C>>(TISCMProtocol.S2C.class);
    private final Set<TISCMProtocol.C2S> serverSupportedPackets = Sets.newHashSet();

    private TISCMClientPacketHandler() {
        this.handlers.put(TISCMProtocol.S2C.HELLO, this::handleHello);
        this.handlers.put(TISCMProtocol.S2C.SUPPORTED_C2S_PACKETS, this::handleSupportPackets);
        this.handlers.put(TISCMProtocol.S2C.MSPT_METRICS_SAMPLE, this::handleMsptMetricsSample);
        this.asyncHandlers.put(TISCMProtocol.S2C.SPEED_TEST_DOWNLOAD_PAYLOAD, TISCMNetworkUtils::blackHole);
        this.handlers.put(TISCMProtocol.S2C.SPEED_TEST_UPLOAD_REQUEST, SpeedTestCommand.getInstance()::handleServerUploadRequest);
        this.asyncHandlers.put(TISCMProtocol.S2C.SPEED_TEST_PING, SpeedTestCommand.getInstance()::handleServerPing);
        this.handlers.put(TISCMProtocol.S2C.SPEED_TEST_ABORT, SpeedTestCommand.getInstance()::handleServerTestAbort);
        HashSet missingIds = Sets.newHashSet();
        missingIds.addAll(TISCMProtocol.S2C.ID_MAP.values());
        missingIds.removeAll(this.handlers.keySet());
        missingIds.removeAll(this.asyncHandlers.keySet());
        if (!missingIds.isEmpty()) {
            throw new RuntimeException("TISCMClientPacketHandler doesn't handle all S2C packets: " + String.valueOf(missingIds));
        }
    }

    public static TISCMClientPacketHandler getInstance() {
        return INSTANCE;
    }

    public void dispatch(class_634 networkHandler, TISCMCustomPayload tiscmCustomPayload) {
        HandlerContext.S2C ctx = new HandlerContext.S2C(networkHandler, tiscmCustomPayload.getNbt());
        Optional<TISCMProtocol.S2C> packetId = TISCMProtocol.S2C.fromId(tiscmCustomPayload.getPacketId());
        packetId.map(this.asyncHandlers::get).ifPresent(handler -> handler.accept(ctx));
        ctx.runSynced(() -> packetId.map(this.handlers::get).ifPresent(handler -> handler.accept(ctx)));
    }

    public boolean isProtocolEnabled() {
        return !this.serverSupportedPackets.isEmpty();
    }

    public boolean doesServerSupport(TISCMProtocol.C2S packetId) {
        return packetId.isHandshake || this.serverSupportedPackets.contains(packetId);
    }

    public boolean sendPacket(TISCMProtocol.C2S packetId, Consumer<class_2487> payloadBuilder) {
        return this.sendPacket(packetId, payloadBuilder, () -> {});
    }

    public boolean sendPacket(TISCMProtocol.C2S packetId, Consumer<class_2487> payloadBuilder, Runnable doneCallback) {
        class_634 networkHandler;
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            throw new RuntimeException("Trying to send TISCM C2S packet on a dedicated server");
        }
        if (this.doesServerSupport(packetId) && (networkHandler = class_310.method_1551().method_1562()) != null) {
            networkHandler.method_48296().method_10752((class_2596)packetId.packet(payloadBuilder), class_7648.method_45084(doneCallback::run));
            return true;
        }
        return false;
    }

    public void onConnectedToNewServer() {
        this.serverSupportedPackets.clear();
        this.sendPacket(TISCMProtocol.C2S.HI, nbt -> {
            nbt.method_10582("platform_name", "Carpet TIS Addition");
            nbt.method_10582("platform_version", TISCMProtocol.PLATFORM_VERSION);
        });
    }

    public void handleHello(HandlerContext.S2C ctx) {
        String platformName = ctx.payload.method_10558("platform_name");
        String platformVersion = ctx.payload.method_10558("platform_version");
        LOGGER.info("Serverside TISCM protocol supported with platform {} @ {}", (Object)platformName, (Object)platformVersion);
        ArrayList ids = Lists.newArrayList(TISCMProtocol.S2C.ID_MAP.keySet());
        ctx.send(TISCMProtocol.C2S.SUPPORTED_S2C_PACKETS, nbt -> nbt.method_10566("supported_s2c_packets", (class_2520)NbtUtil.stringList2Nbt(ids)));
    }

    public void handleSupportPackets(HandlerContext.S2C ctx) {
        List<String> ids = NbtUtil.nbt2StringList(ctx.payload.method_10562("supported_c2s_packets"));
        LOGGER.debug("Serverside supported TISCM C2S packet ids: {}", ids);
        for (String id : ids) {
            TISCMProtocol.C2S.fromId(id).ifPresent(this.serverSupportedPackets::add);
        }
    }

    public void handleMsptMetricsSample(HandlerContext.S2C ctx) {
        ServerMsptMetricsDataSyncer.getInstance().receiveMetricData(ctx.payload);
    }
}

