/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.mixins.rule.optimizedFastEntityMovement.compat.lithium;

import carpettisaddition.helpers.rule.optimizedFastEntityMovement.OFEMContext;
import carpettisaddition.helpers.rule.optimizedFastEntityMovement.OFEMUtil;
import carpettisaddition.utils.mixin.testers.LithiumEntityMovementOptimizationTester;
import com.google.common.collect.Lists;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.util.Collections;
import java.util.Iterator;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import me.jellysquid.mods.lithium.common.entity.movement.ChunkAwareBlockCollisionSweeper;
import me.jellysquid.mods.lithium.common.util.collections.LazyList;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Restriction(require={@Condition(value="minecraft", versionPredicates={">=1.21"}), @Condition(value="lithium", versionPredicates={">=0.12.5"}), @Condition(type=Condition.Type.TESTER, tester=LithiumEntityMovementOptimizationTester.class)})
@Mixin(value={class_1297.class}, priority=2000)
public abstract class EntityMixin {
    @Unique
    private static final LazyList<class_265> EMPTY_BLOCK_COLLECTIONS = new LazyList(Lists.newArrayList(), Collections.emptyIterator());

    @ModifyExpressionValue(method={"lithium$CollideMovement"}, at={@At(value="NEW", target="(Ljava/util/ArrayList;Ljava/util/Iterator;)Lme/jellysquid/mods/lithium/common/util/collections/LazyList;", remap=false)}, remap=false)
    @Dynamic(value="Should be added by lithium entity.collisions.movement")
    private static LazyList<class_265> dontUseThatLargeBlockCollisions(LazyList<class_265> originalList, @Local(argsOnly=true) class_1937 world, @Local(argsOnly=true) @Nullable class_1297 entity, @Local(argsOnly=true) class_243 movement, @Share(value="OFEMContext") LocalRef<OFEMContext> context) {
        OFEMContext ctx = OFEMUtil.checkAndCreateContext(world, entity, movement);
        context.set((Object)ctx);
        if (ctx != null) {
            return EMPTY_BLOCK_COLLECTIONS;
        }
        return originalList;
    }

    @ModifyArgs(method={"lithium$CollideMovement"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/shape/VoxelShapes;calculateMaxOffset(Lnet/minecraft/util/math/Direction$Axis;Lnet/minecraft/util/math/Box;Ljava/lang/Iterable;D)D", remap=true), remap=false)
    @Dynamic(value="Should be added by lithium entity.collisions.movement")
    private static void useAxisOnlyBlockCollisions(Args args, @Share(value="OFEMContext") LocalRef<OFEMContext> context) {
        OFEMContext ctx = (OFEMContext)context.get();
        if (ctx == null) {
            return;
        }
        class_2350.class_2351 axis = (class_2350.class_2351)args.get(0);
        class_238 entityBoundingBox = (class_238)args.get(1);
        Iterable blockCollisions = (Iterable)args.get(2);
        double maxDist = (Double)args.get(3);
        ctx.axis = axis;
        ctx.movementOnAxis = maxDist;
        ctx.entityBoundingBox = entityBoundingBox;
        if (blockCollisions == EMPTY_BLOCK_COLLECTIONS) {
            Iterable<class_265> newList = OFEMUtil.getAxisOnlyBlockCollision(ctx, (world, entity, box) -> {
                ChunkAwareBlockCollisionSweeper blockCollisionSweeper = new ChunkAwareBlockCollisionSweeper(world, entity, box, false);
                return new LazyList(Lists.newArrayList(), (Iterator)blockCollisionSweeper);
            });
            args.set(2, newList);
        }
    }
}

