/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.mixins.rule.fakePlayerName;

import carpet.commands.PlayerCommand;
import carpettisaddition.CarpetTISAdditionSettings;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={PlayerCommand.class})
public abstract class PlayerCommandMixin {
    private static String getDecoratedString(CommandContext<?> context, String name) {
        Object playerName = StringArgumentType.getString(context, (String)name);
        if (!name.equals("player")) {
            return playerName;
        }
        String rulePrefix = CarpetTISAdditionSettings.fakePlayerNamePrefix;
        String ruleSuffix = CarpetTISAdditionSettings.fakePlayerNameSuffix;
        if (!rulePrefix.equals("#none") && !((String)playerName).startsWith(rulePrefix)) {
            playerName = rulePrefix + (String)playerName;
        }
        if (!ruleSuffix.equals("#none") && !((String)playerName).endsWith(ruleSuffix)) {
            playerName = (String)playerName + ruleSuffix;
        }
        return playerName;
    }

    @Redirect(method={"spawn"}, at=@At(value="INVOKE", target="Lcom/mojang/brigadier/arguments/StringArgumentType;getString(Lcom/mojang/brigadier/context/CommandContext;Ljava/lang/String;)Ljava/lang/String;"), remap=false)
    private static String getStringWithPrefixAtSpawn(CommandContext<?> context, String name) {
        return PlayerCommandMixin.getDecoratedString(context, name);
    }

    @Redirect(method={"cantSpawn"}, at=@At(value="INVOKE", target="Lcom/mojang/brigadier/arguments/StringArgumentType;getString(Lcom/mojang/brigadier/context/CommandContext;Ljava/lang/String;)Ljava/lang/String;"), require=1, remap=false)
    private static String getStringWithPrefixAtCantSpawn(CommandContext<?> context, String name) {
        return PlayerCommandMixin.getDecoratedString(context, name);
    }
}

