/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.mixins.carpet.tweaks.logger.projectile;

import carpet.logging.logHelpers.TrajectoryLogHelper;
import carpettisaddition.CarpetTISAdditionServer;
import carpettisaddition.CarpetTISAdditionSettings;
import carpettisaddition.helpers.carpet.tweaks.logger.projectile.ProjectileLoggerTarget;
import carpettisaddition.helpers.carpet.tweaks.logger.projectile.TrajectoryLoggerUtil;
import carpettisaddition.helpers.carpet.tweaks.logger.projectile.VisualizeTrajectoryHelper;
import carpettisaddition.translations.Translator;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.compat.DimensionWrapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5250;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TrajectoryLogHelper.class})
public abstract class TrajectoryLogHelperMixin {
    @Shadow(remap=false)
    private ArrayList<class_243> positions;
    @Shadow(remap=false)
    private boolean doLog;
    @Shadow(remap=false)
    @Final
    private static int MAX_TICKS_PER_LINE;
    @Unique
    private class_1937 world;
    @Unique
    private class_1297 entity;
    private boolean doVisualizeLogging;
    private boolean hasCreatedVisualizer;
    private final Translator translator = new Translator("logger.projectiles.visualized");

    @Inject(method={"<init>"}, at={@At(value="TAIL")}, remap=false)
    private void initTISCMStuffs(String logName, CallbackInfo ci) {
        this.doVisualizeLogging = false;
        this.hasCreatedVisualizer = false;
        if (TrajectoryLoggerUtil.isVisualizer.get().booleanValue()) {
            TrajectoryLoggerUtil.isVisualizer.set(false);
            this.doLog = false;
            return;
        }
        if ("projectiles".equals(logName)) {
            this.entity = TrajectoryLoggerUtil.currentEntity.get();
            TrajectoryLoggerUtil.currentEntity.remove();
            if (this.entity != null) {
                this.world = this.entity.method_5770();
                this.doVisualizeLogging = this.world != null;
            }
        }
    }

    @Inject(method={"onFinish"}, at={@At(value="HEAD")}, remap=false)
    private void checkIfIsVisualizeLogger(CallbackInfo ci) {
        if (this.doVisualizeLogging) {
            if (VisualizeTrajectoryHelper.isVisualizeProjectile(this.entity)) {
                this.doLog = false;
            } else {
                VisualizeTrajectoryHelper.clearVisualizers();
            }
        }
    }

    private Optional<class_239> getHitResult() {
        if (this.entity instanceof ProjectileLoggerTarget) {
            return Optional.ofNullable(((ProjectileLoggerTarget)this.entity).getHitResult());
        }
        return Optional.empty();
    }

    @Inject(method={"lambda$onFinish$0"}, at={@At(value="TAIL")}, remap=false, cancellable=true)
    private void projectileLoggerEnhance(String option, CallbackInfoReturnable<class_2561[]> cir) {
        ArrayList comp = Lists.newArrayList();
        for (class_2561 text : (class_2561[])cir.getReturnValue()) {
            if (!(text instanceof class_5250)) {
                CarpetTISAdditionServer.LOGGER.warn("Unsupported text type {} found in return value in TrajectoryLogHelperMixin#projectileLoggerEnhance", (Object)text.getClass());
                return;
            }
            comp.add((class_5250)text);
        }
        Optional<class_239> hitResultOptional = this.getHitResult();
        class_243 hitPos = null;
        class_5250 hitType = null;
        if (hitResultOptional.isPresent()) {
            hitPos = hitResultOptional.get().method_17784();
            hitType = hitResultOptional.get() instanceof class_3965 ? Messenger.c("w block ", Messenger.coord(null, (class_2382)((class_3965)hitResultOptional.get()).method_17777(), DimensionWrapper.of(this.world))) : (hitResultOptional.get() instanceof class_3966 ? Messenger.c("w entity (", Messenger.entity(null, ((class_3966)hitResultOptional.get()).method_17782()), "w )") : Messenger.s("?"));
        }
        switch (option) {
            case "brief": {
                if (!hitResultOptional.isPresent()) break;
                class_5250 lastLine = (class_5250)comp.get(comp.size() - 1);
                class_5250 marker = Messenger.fancy("g", Messenger.s(" x"), Messenger.c("w Hit: ", hitType, String.format("w \nx: %f", hitPos.method_10216()), String.format("w \ny: %f", hitPos.method_10214()), String.format("w \nz: %f", hitPos.method_10215())), null);
                if (lastLine.getString().length() >= MAX_TICKS_PER_LINE * 2) {
                    comp.add(marker);
                    break;
                }
                lastLine.method_10852((class_2561)marker);
                break;
            }
            case "full": {
                if (!hitResultOptional.isPresent()) break;
                comp.add(Messenger.c("w Hit: ", hitType));
                break;
            }
            case "visualize": {
                if (!this.doVisualizeLogging) break;
                if (CarpetTISAdditionSettings.visualizeProjectileLoggerEnabled) {
                    comp.add(this.translator.tr("info", this.positions.size()));
                    if (this.hasCreatedVisualizer) break;
                    for (int i = 0; i < this.positions.size(); ++i) {
                        VisualizeTrajectoryHelper.createVisualizer(this.world, this.positions.get(i), String.valueOf(i));
                    }
                    hitResultOptional.ifPresent(hitResult -> VisualizeTrajectoryHelper.createVisualizer(this.world, hitResult.method_17784(), "Hit"));
                    this.hasCreatedVisualizer = true;
                    break;
                }
                comp.add(Messenger.fancy("w", this.translator.tr("not_enabled.warn", new Object[0]), this.translator.tr("not_enabled.hint", new Object[0]), new class_2558(class_2558.class_2559.field_11745, "/carpet visualizeProjectileLoggerEnabled true")));
            }
        }
        cir.setReturnValue((Object)comp.toArray(new class_2561[0]));
    }
}

