/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.raid;

import carpettisaddition.logging.TISAdditionLoggerRegistry;
import carpettisaddition.logging.loggers.AbstractLogger;
import carpettisaddition.translations.Translator;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.compat.DimensionWrapper;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3765;
import net.minecraft.class_5250;

public class RaidLogger
extends AbstractLogger {
    public static final String NAME = "raid";
    private static final RaidLogger instance = new RaidLogger();

    public RaidLogger() {
        super(NAME, true);
    }

    public static RaidLogger getInstance() {
        return instance;
    }

    public void onRaidCreated(class_3765 raid) {
        if (!TISAdditionLoggerRegistry.__raid) {
            return;
        }
        this.log(() -> new class_5250[]{Messenger.c(this.tr("created", raid.method_16494()), "g  @ ", Messenger.coord("w", (class_2382)raid.method_16495(), DimensionWrapper.of(raid.method_16831())))});
    }

    public void onRaidInvalidated(class_3765 raid, InvalidateReason reason) {
        if (!TISAdditionLoggerRegistry.__raid) {
            return;
        }
        this.log(() -> new class_5250[]{Messenger.c(this.tr("invalidated", raid.method_16494(), reason.toText()))});
    }

    public void onBadOmenLevelIncreased(class_3765 raid, int badOmenLevel) {
        if (!TISAdditionLoggerRegistry.__raid) {
            return;
        }
        this.log(() -> new class_5250[]{Messenger.c(this.tr("bad_omen_level_increased", raid.method_16494(), badOmenLevel))});
    }

    public void onCenterMoved(class_3765 raid, class_2338 pos) {
        if (!TISAdditionLoggerRegistry.__raid) {
            return;
        }
        this.log(() -> new class_5250[]{Messenger.c(this.tr("center_moved", raid.method_16494(), Messenger.coord((class_2382)pos, DimensionWrapper.of(raid.method_16831()))))});
    }

    public static enum InvalidateReason {
        DIFFICULTY_PEACEFUL,
        GAMERULE_DISABLE,
        POI_REMOVED_BEFORE_SPAWN,
        TIME_OUT,
        RAIDER_CANNOT_SPAWN,
        RAID_VICTORY,
        RAID_DEFEAT;

        private static final Translator TRANSLATOR;

        public String getName() {
            return this.name().toLowerCase();
        }

        public class_5250 toText() {
            return TRANSLATOR.tr(this.getName(), new Object[0]);
        }

        static {
            TRANSLATOR = RaidLogger.getInstance().getTranslator().getDerivedTranslator("raid_invalidate_reason");
        }
    }
}

