/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.phantom;

import carpettisaddition.logging.TISAdditionLoggerRegistry;
import carpettisaddition.logging.loggers.AbstractLogger;
import carpettisaddition.utils.CounterUtil;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.StringUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_2558;
import net.minecraft.class_3222;
import net.minecraft.class_3442;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class PhantomLogger
extends AbstractLogger {
    public static final String NAME = "phantom";
    private static final PhantomLogger INSTANCE = new PhantomLogger();
    private static final int PHANTOM_SPAWNING_TIME = 72000;
    private static final List<Integer> REMINDER_TICKS = Lists.newArrayList((Object[])new Integer[]{54000, 72000});
    private static final class_5250 PHANTOM_NAME = Messenger.entityType(class_1299.field_6078);

    private PhantomLogger() {
        super(NAME, false);
    }

    public static PhantomLogger getInstance() {
        return INSTANCE;
    }

    @Override
    @Nullable
    public String getDefaultLoggingOption() {
        return LoggingOption.DEFAULT.getName();
    }

    @Override
    @Nullable
    public String[] getSuggestedLoggingOption() {
        return LoggingOption.getSuggestions();
    }

    private class_5250 pack(class_5250 message) {
        String command = String.format("/log %s", this.getName());
        return Messenger.c(Messenger.fancy(Messenger.c("g [", this.tr("header", new Object[0]), "g ] "), Messenger.s(command), new class_2558(class_2558.class_2559.field_11745, command)), message);
    }

    public void onPhantomSpawn(class_1657 spawnerPlayer, int phantomAmount) {
        if (!TISAdditionLoggerRegistry.__phantom) {
            return;
        }
        this.log(option -> {
            if (LoggingOption.SPAWNING.isContainedIn(option)) {
                return new class_5250[]{this.pack(this.tr("summon", Messenger.entity("b", (class_1297)spawnerPlayer), phantomAmount, PHANTOM_NAME))};
            }
            return null;
        });
    }

    public void tick() {
        if (!TISAdditionLoggerRegistry.__phantom) {
            return;
        }
        this.log((option, player) -> {
            class_3442 serverStatHandler;
            int timeSinceRest;
            if (LoggingOption.REMINDER.isContainedIn(option) && REMINDER_TICKS.contains(timeSinceRest = class_3532.method_15340((int)(serverStatHandler = ((class_3222)player).method_14248()).method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15429)), (int)1, (int)Integer.MAX_VALUE))) {
                int timeUntilSpawn = 72000 - timeSinceRest;
                String sinceRest = StringUtil.fractionDigit(CounterUtil.tickToMinute(timeSinceRest), 0);
                String untilSpawn = StringUtil.fractionDigit(CounterUtil.tickToMinute(timeUntilSpawn), 0);
                return new class_5250[]{this.pack(this.tr("reminder.time_since_rest", sinceRest)), this.pack(this.tr(timeUntilSpawn != 0 ? "reminder.regular" : "reminder.now", PHANTOM_NAME, untilSpawn))};
            }
            return null;
        });
    }

    public static enum LoggingOption {
        SPAWNING,
        REMINDER;

        public static final LoggingOption DEFAULT;

        public String getName() {
            return this.name().toLowerCase();
        }

        public static String[] getSuggestions() {
            ArrayList suggestions = Lists.newArrayList();
            suggestions.addAll(Arrays.stream(LoggingOption.values()).map(LoggingOption::getName).collect(Collectors.toList()));
            suggestions.add(PhantomLogger.createCompoundOption(new String[]{LoggingOption.SPAWNING.getName(), LoggingOption.REMINDER.getName()}));
            return suggestions.toArray(new String[0]);
        }

        public boolean isContainedIn(String option) {
            return Arrays.asList(option.split("[,. ]")).contains(this.getName());
        }

        static {
            DEFAULT = SPAWNING;
        }
    }
}

