/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.microtiming.utils;

import carpet.logging.Logger;
import carpettisaddition.CarpetTISAdditionSettings;
import carpettisaddition.logging.TISAdditionLoggerRegistry;
import carpettisaddition.logging.loggers.microtiming.MicroTimingLogger;
import carpettisaddition.logging.loggers.microtiming.MicroTimingLoggerManager;
import carpettisaddition.logging.loggers.microtiming.enums.MicroTimingTarget;
import carpettisaddition.logging.loggers.microtiming.marker.MicroTimingMarkerManager;
import carpettisaddition.logging.loggers.microtiming.utils.MicroTimingUtil;
import carpettisaddition.translations.Translator;
import carpettisaddition.utils.Messenger;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.minecraft.class_1657;
import net.minecraft.class_2558;
import net.minecraft.class_3222;

public class MicroTimingStandardCarpetLogger
extends Logger {
    private static final MicroTimingStandardCarpetLogger INSTANCE = MicroTimingStandardCarpetLogger.createInstance();
    public static final String NAME = "microTiming";
    private static final Translator translator = MicroTimingLoggerManager.TRANSLATOR.getDerivedTranslator("carpet_logger");

    private MicroTimingStandardCarpetLogger(Field acceleratorField, String logName, String def, String[] options) {
        super(acceleratorField, logName, def, options, true);
    }

    private static MicroTimingStandardCarpetLogger createInstance() {
        String def = MicroTimingLogger.LoggingOption.DEFAULT.toString();
        String[] options = (String[])Arrays.stream(MicroTimingLogger.LoggingOption.values()).map(Enum::toString).map(String::toLowerCase).toArray(String[]::new);
        return new MicroTimingStandardCarpetLogger(TISAdditionLoggerRegistry.getLoggerField(NAME), NAME, def, options);
    }

    public static MicroTimingStandardCarpetLogger getInstance() {
        return INSTANCE;
    }

    public void addPlayer(String playerName, String option) {
        super.addPlayer(playerName, option);
        class_3222 player = this.playerFromName(playerName);
        if (player != null) {
            if (MicroTimingLoggerManager.isLoggerActivated()) {
                if (CarpetTISAdditionSettings.microTimingTarget != MicroTimingTarget.MARKER_ONLY) {
                    MicroTimingTarget.deprecatedWarning(player.method_5671());
                }
            } else {
                String command = "/carpet microTiming true";
                Messenger.tell((class_1657)player, Messenger.fancy(translator.tr("rule_hint", command), translator.tr("click_to_execute", new Object[0]), new class_2558(class_2558.class_2559.field_11745, command)));
            }
            MicroTimingMarkerManager.getInstance().sendAllMarkersForPlayer(player);
        }
    }

    public void removePlayer(String playerName) {
        super.removePlayer(playerName);
        class_3222 player = this.playerFromName(playerName);
        if (player != null) {
            MicroTimingMarkerManager.getInstance().cleanAllMarkersForPlayer(player);
        }
    }

    public void onCarpetClientHello(class_3222 player) {
        if (MicroTimingUtil.isPlayerSubscribed((class_1657)player)) {
            MicroTimingMarkerManager.getInstance().sendAllMarkersForPlayer(player);
        }
    }
}

