/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.microtiming.message;

import carpettisaddition.CarpetTISAdditionServer;
import carpettisaddition.logging.loggers.microtiming.message.IndentedMessage;
import carpettisaddition.logging.loggers.microtiming.message.MicroTimingMessage;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;

public class MessageTreeNode {
    private final List<MessageTreeNode> children = Lists.newArrayList();
    private final MessageTreeNode parent;
    private final MicroTimingMessage entryMessage;
    private MicroTimingMessage quitMessage;
    private boolean flushed;

    public MessageTreeNode(MessageTreeNode parent, MicroTimingMessage message) {
        this.parent = parent;
        this.entryMessage = message;
        this.flushed = false;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
    }

    public MessageTreeNode getParent() {
        return this.parent;
    }

    public void setQuitMessage(MicroTimingMessage message) {
        this.quitMessage = message;
        if (this.entryMessage.getEvent().getClass() != this.quitMessage.getEvent().getClass()) {
            CarpetTISAdditionServer.LOGGER.warn(String.format("Trying to merge %s with %s", MessageTreeNode.childName(this.entryMessage.getEvent()), MessageTreeNode.childName(this.quitMessage.getEvent())));
        }
    }

    private void addChild(MessageTreeNode child) {
        this.children.add(child);
    }

    public List<IndentedMessage> flush() {
        ArrayDeque stack = Queues.newArrayDeque();
        StackElement rootElement = new StackElement(this, 0, null);
        stack.push(rootElement);
        while (!stack.isEmpty()) {
            StackElement parent;
            boolean showQuitMessage;
            StackElement e = (StackElement)stack.pop();
            if (e.iterator == null) {
                if (e.node.flushed) {
                    throw new IllegalStateException(e.node.getClass().getName() + " can only flush once");
                }
                e.node.flushed = true;
                e.iterator = e.node.children.iterator();
            }
            if (e.iterator.hasNext()) {
                MessageTreeNode child = e.iterator.next();
                stack.push(e);
                stack.push(new StackElement(child, e.depth + 1, e));
                continue;
            }
            boolean showEntryMessage = e.node.entryMessage.getEvent().isImportant() || e.childWithMessageCount > 0;
            boolean mergeMessage = showEntryMessage && e.node.quitMessage != null && e.childWithMessageCount <= 1;
            boolean bl = showQuitMessage = e.node.quitMessage != null && showEntryMessage && !mergeMessage;
            if (mergeMessage) {
                e.node.entryMessage.mergeQuitMessage(e.node.quitMessage);
            }
            if (showEntryMessage) {
                e.messageList.add(new IndentedMessage(e.node.entryMessage, e.depth));
            }
            e.messageList.addAll(e.childMessageList);
            if (showQuitMessage) {
                e.messageList.add(new IndentedMessage(e.node.quitMessage, e.depth));
            }
            if ((parent = e.parentStackElement) == null) continue;
            parent.childMessageList.addAll(e.messageList);
            if (e.messageList.isEmpty()) continue;
            ++parent.childWithMessageCount;
        }
        return rootElement.messageList;
    }

    private static String childName(Object o) {
        String[] list = o.toString().split("\\.");
        return list[list.length - 1];
    }

    private static String ms(MicroTimingMessage msg) {
        return MessageTreeNode.childName(msg.getEvent()) + " " + MessageTreeNode.childName((Object)msg.getEvent().getEventType()) + " " + MessageTreeNode.childName((Object)msg.getMessageType());
    }

    private void printTree(int depth) {
        StringBuilder prefix = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            prefix.append("  ");
        }
        System.err.println(String.valueOf(prefix) + MessageTreeNode.ms(this.entryMessage));
        for (MessageTreeNode child : this.children) {
            child.printTree(depth + 1);
        }
        System.err.println(String.valueOf(prefix) + (this.quitMessage != null ? MessageTreeNode.ms(this.quitMessage) : null));
    }

    public void printTree() {
        try {
            this.printTree(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class StackElement {
        public MessageTreeNode node;
        public int depth;
        public StackElement parentStackElement;
        public List<IndentedMessage> messageList;
        public List<IndentedMessage> childMessageList;
        public Iterator<MessageTreeNode> iterator;
        public int childWithMessageCount;

        private StackElement(MessageTreeNode node, int depth, StackElement parentStackElement) {
            this.node = node;
            this.depth = depth;
            this.parentStackElement = parentStackElement;
            this.messageList = Lists.newArrayList();
            this.childMessageList = Lists.newArrayList();
            this.iterator = null;
            this.childWithMessageCount = 0;
        }
    }
}

