/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.microtiming.events;

import carpettisaddition.utils.IdentifierUtil;
import carpettisaddition.utils.Messenger;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_5250;

public abstract class EventSource {
    public abstract Object getSourceObject();

    public abstract class_5250 getName();

    public abstract class_2960 getId();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Objects.equals(this.getSourceObject(), ((EventSource)o).getSourceObject());
    }

    public int hashCode() {
        return this.getSourceObject().hashCode();
    }

    public static Optional<EventSource> fromObject(Object object) {
        if (object instanceof class_2248) {
            return Optional.of(new BlockEventSource((class_2248)object));
        }
        if (object instanceof class_3611) {
            return Optional.of(new FluidEventSource((class_3611)object));
        }
        return Optional.empty();
    }

    public static class BlockEventSource
    extends EventSource {
        private final class_2248 block;

        public BlockEventSource(class_2248 block) {
            this.block = block;
        }

        @Override
        public Object getSourceObject() {
            return this.block;
        }

        @Override
        public class_5250 getName() {
            return Messenger.block(this.block);
        }

        @Override
        public class_2960 getId() {
            return IdentifierUtil.id(this.block);
        }
    }

    public static class FluidEventSource
    extends EventSource {
        private final class_3611 fluid;

        public FluidEventSource(class_3611 fluid) {
            this.fluid = fluid;
        }

        @Override
        public Object getSourceObject() {
            return this.fluid;
        }

        @Override
        public class_5250 getName() {
            return Messenger.fluid(this.fluid);
        }

        @Override
        public class_2960 getId() {
            return IdentifierUtil.id(this.fluid);
        }
    }
}

