/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.microtiming;

import carpet.logging.Logger;
import carpettisaddition.logging.loggers.AbstractLogger;
import carpettisaddition.logging.loggers.microtiming.enums.EventType;
import carpettisaddition.logging.loggers.microtiming.enums.TickStage;
import carpettisaddition.logging.loggers.microtiming.marker.MicroTimingMarkerManager;
import carpettisaddition.logging.loggers.microtiming.message.IndentedMessage;
import carpettisaddition.logging.loggers.microtiming.message.MessageList;
import carpettisaddition.logging.loggers.microtiming.message.MessageType;
import carpettisaddition.logging.loggers.microtiming.message.MicroTimingMessage;
import carpettisaddition.logging.loggers.microtiming.tickphase.TickPhase;
import carpettisaddition.logging.loggers.microtiming.tickphase.substages.AbstractSubStage;
import carpettisaddition.logging.loggers.microtiming.utils.MicroTimingContext;
import carpettisaddition.logging.loggers.microtiming.utils.MicroTimingUtil;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.compat.DimensionWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class MicroTimingLogger
extends AbstractLogger {
    public static final String NAME = "microTiming";
    private TickPhase tickPhase;
    private final class_3218 world;
    public final MessageList messageList = new MessageList();

    public MicroTimingLogger(@NotNull class_3218 world) {
        super(NAME, true);
        this.world = world;
        this.tickPhase = new TickPhase(TickStage.UNKNOWN, DimensionWrapper.of((class_1937)this.world));
    }

    @Override
    public Logger createCarpetLogger() {
        throw new UnsupportedOperationException("Use MicroTimingStandardCarpetLogger.getInstance()");
    }

    public void setTickStage(@NotNull TickStage stage) {
        this.tickPhase = this.tickPhase.withMainStage(stage);
    }

    public void setTickStageDetail(String stageDetail) {
        this.tickPhase = this.tickPhase.withDetailed(stageDetail);
    }

    public void setSubTickStage(AbstractSubStage subStage) {
        this.tickPhase = this.tickPhase.withSubStage(subStage);
    }

    public TickPhase getTickPhase() {
        return this.tickPhase;
    }

    public class_3218 getWorld() {
        return this.world;
    }

    public void addMessage(MicroTimingContext context) {
        if (context.getColor() == null) {
            Optional<class_1767> optionalDyeColor;
            if (context.getWoolGetter() == null) {
                context.withWoolGetter(MicroTimingUtil::defaultColorGetter);
            }
            if ((optionalDyeColor = context.getWoolGetter().apply((class_1937)this.world, context.getBlockPos())).isPresent()) {
                context.withColor(optionalDyeColor.get());
            } else {
                return;
            }
        }
        MicroTimingMarkerManager.getInstance().getMarkerName(context.getWorld(), context.getBlockPos()).ifPresent(context::withBlockName);
        MicroTimingMessage message = new MicroTimingMessage(this, context);
        if (message.getEvent().getEventType() != EventType.ACTION_END) {
            this.messageList.addMessageAndIndent(message);
        } else {
            this.messageList.addMessageAndUnIndent(message);
        }
    }

    private class_5250 getMergedResult(int count, IndentedMessage previousMessage) {
        return Messenger.fancy("g", Messenger.s(String.format(" +%dx", count)), Messenger.c(this.tr("merged_message", count), "w \n", previousMessage.getMessage().toText(0, true)), null);
    }

    private class_5250[] getTrimmedMessages(List<IndentedMessage> flushedMessages, LoggingOption option) {
        ArrayList msg = Lists.newArrayList();
        HashSet messageHashSet = Sets.newHashSet();
        msg.add(Messenger.s(" "));
        msg.add(Messenger.c("f [", Messenger.formatting(this.tr("gametime", new Object[0]), "f"), "^w world.getTime()", "g  " + this.world.method_8510(), "f  @ ", Messenger.fancy("g", Messenger.dimension(DimensionWrapper.of((class_1937)this.world)), Messenger.s(DimensionWrapper.of((class_1937)this.world).getIdentifierString()), null), "f ] ------------"));
        int skipCount = 0;
        Iterator<IndentedMessage> iterator = flushedMessages.iterator();
        IndentedMessage previousMessage = null;
        while (iterator.hasNext()) {
            boolean showThisMessage;
            IndentedMessage message = iterator.next();
            boolean bl = showThisMessage = option == LoggingOption.ALL || message.getMessage().getMessageType() == MessageType.PROCEDURE;
            if (!showThisMessage && option == LoggingOption.MERGED) {
                boolean bl2 = showThisMessage = previousMessage == null || !message.getMessage().equals(previousMessage.getMessage());
            }
            if (!showThisMessage && option == LoggingOption.UNIQUE) {
                showThisMessage = messageHashSet.add(message.getMessage());
            }
            if (showThisMessage) {
                if (option == LoggingOption.MERGED && previousMessage != null && skipCount > 0 && !msg.isEmpty()) {
                    ((class_5250)msg.get(msg.size() - 1)).method_10852((class_2561)this.getMergedResult(skipCount, previousMessage));
                }
                msg.add(message.toText());
                previousMessage = message;
                skipCount = 0;
            } else {
                ++skipCount;
            }
            if (iterator.hasNext() || option != LoggingOption.MERGED || skipCount <= 0 || msg.isEmpty()) continue;
            ((class_5250)msg.get(msg.size() - 1)).method_10852((class_2561)this.getMergedResult(skipCount, previousMessage));
        }
        return msg.toArray(new class_5250[0]);
    }

    public void flushMessages() {
        List<IndentedMessage> flushedMessages;
        if (!this.messageList.isEmpty() && !(flushedMessages = this.messageList.flush()).isEmpty()) {
            EnumMap<LoggingOption, class_5250[]> flushedTrimmedMessages = new EnumMap<LoggingOption, class_5250[]>(LoggingOption.class);
            for (LoggingOption option2 : LoggingOption.values()) {
                flushedTrimmedMessages.put(option2, this.getTrimmedMessages(flushedMessages, option2));
            }
            this.log(option -> (class_2561[])flushedTrimmedMessages.get((Object)LoggingOption.getOrDefault(option)));
        }
    }

    public static enum LoggingOption {
        MERGED,
        ALL,
        UNIQUE;

        public static final LoggingOption DEFAULT;

        public static LoggingOption getOrDefault(String option) {
            LoggingOption loggingOption;
            try {
                loggingOption = LoggingOption.valueOf(option.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                loggingOption = DEFAULT;
            }
            return loggingOption;
        }

        static {
            DEFAULT = MERGED;
        }
    }
}

