/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.helpers.rule.syncServerMsptMetricsData;

import carpettisaddition.CarpetTISAdditionSettings;
import carpettisaddition.network.TISCMClientPacketHandler;
import carpettisaddition.network.TISCMProtocol;
import carpettisaddition.network.TISCMServerPacketHandler;
import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.class_2487;
import net.minecraft.class_9160;
import net.minecraft.class_9191;

public class ServerMsptMetricsDataSyncer {
    private static final ServerMsptMetricsDataSyncer INSTANCE = new ServerMsptMetricsDataSyncer();
    private static final class_9160 SERVER_TICK_TYPE_FALLBACK = class_9160.field_48719;
    private static final long M = 1000000L;
    private class_9191 metricsData;
    private final Set<class_9160> sentTypesThisTick = Sets.newHashSet();
    private long tickCounterThisTick = -1L;

    private ServerMsptMetricsDataSyncer() {
        this.reset();
    }

    public static ServerMsptMetricsDataSyncer getInstance() {
        return INSTANCE;
    }

    public void broadcastSample(long tickCounter, long nanosecond, class_9160 serverTickType) {
        if (tickCounter != this.tickCounterThisTick) {
            this.sentTypesThisTick.clear();
            this.tickCounterThisTick = tickCounter;
        }
        if (!this.sentTypesThisTick.add(serverTickType)) {
            return;
        }
        TISCMServerPacketHandler.getInstance().broadcast(TISCMProtocol.S2C.MSPT_METRICS_SAMPLE, nbt -> {
            nbt.method_10569("version", 2);
            nbt.method_10544("millisecond", nanosecond / 1000000L);
            nbt.method_10544("nanosecond", nanosecond);
            nbt.method_10582("type", serverTickType.toString().toLowerCase());
        });
    }

    public void broadcastSampleLegacy(long tickCounter, long millisecond) {
        this.broadcastSample(tickCounter, millisecond * 1000000L, SERVER_TICK_TYPE_FALLBACK);
    }

    public void receiveMetricData(class_2487 nbt) {
        class_9160 type;
        long nanosecond = nbt.method_10537("millisecond") * 1000000L;
        if (nbt.method_10545("nanosecond")) {
            nanosecond = nbt.method_10537("nanosecond");
        }
        try {
            type = class_9160.valueOf((String)nbt.method_10558("type").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            type = SERVER_TICK_TYPE_FALLBACK;
        }
        if (type.ordinal() == 0) {
            this.metricsData.method_53066(nanosecond);
        } else {
            this.metricsData.method_56535(nanosecond, type.ordinal());
        }
    }

    public class_9191 getMetricsData() {
        return this.metricsData;
    }

    public void reset() {
        this.metricsData = new class_9191(class_9160.values().length);
    }

    public boolean isServerSupportOk() {
        return CarpetTISAdditionSettings.syncServerMsptMetricsData && TISCMClientPacketHandler.getInstance().isProtocolEnabled();
    }

    public void clientTick() {
    }
}

