/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.helpers.carpet.protocol;

import carpettisaddition.CarpetTISAdditionMod;
import carpettisaddition.helpers.carpet.protocol.CarpetNetworkProtocolVersion;
import carpettisaddition.utils.NetworkUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

class UniversalCarpetPayload {
    private static final int V1_DATA = 1;
    private static final int V1_HI = 69;
    private static final int V1_HELLO = 420;
    private static final String V2_HI = "69";
    private static final String V2_HELLO = "420";
    public int action = -1;
    public String string = null;
    public class_2487 nbt = null;
    public CarpetNetworkProtocolVersion version = CarpetNetworkProtocolVersion.UNKNOWN;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniversalCarpetPayload(class_2540 buf) {
        int prevReaderIndex = buf.readerIndex();
        try {
            this.action = buf.method_10816();
            if (this.action == 69 || this.action == 420) {
                this.string = buf.method_10800(64);
            } else if (this.action == 1) {
                this.nbt = Objects.requireNonNull(NetworkUtil.readNbt(buf));
            } else {
                throw new Exception("unknown action " + this.action);
            }
            if (buf.readableBytes() != 0) {
                throw new Exception(String.format("too many data, action=%d remained=%d", this.action, buf.readableBytes()));
            }
            this.version = CarpetNetworkProtocolVersion.V1;
            CarpetTISAdditionMod.LOGGER.debug("UniversalCarpetPayload read V1 success, action={} str={} nbt={}", (Object)this.action, (Object)this.string, (Object)this.nbt);
            return;
        }
        catch (Exception e) {
            CarpetTISAdditionMod.LOGGER.debug("UniversalCarpetPayload read V1 failed, err={}", (Object)e.toString());
        }
        finally {
            buf.method_52988(prevReaderIndex);
        }
        prevReaderIndex = buf.readerIndex();
        try {
            this.action = -1;
            this.string = null;
            this.nbt = NetworkUtil.readNbt(buf);
            if (buf.readableBytes() != 0) {
                throw new Exception(String.format("too many data, nbt=%s remained=%d", this.nbt, buf.readableBytes()));
            }
            if (this.nbt == null) {
                this.nbt = new class_2487();
            }
            this.version = CarpetNetworkProtocolVersion.V2;
            CarpetTISAdditionMod.LOGGER.debug("UniversalCarpetPayload read V2 success, nbt={}", (Object)this.nbt);
            return;
        }
        catch (Exception e) {
            CarpetTISAdditionMod.LOGGER.debug("UniversalCarpetPayload read V2 failed, err={}", (Object)e.toString());
        }
        finally {
            buf.method_52988(prevReaderIndex);
        }
    }

    public CarpetNetworkProtocolVersion getVersion() {
        return this.version;
    }

    public void writeTo(class_2540 buf, CarpetNetworkProtocolVersion targetVersion) {
        switch (targetVersion) {
            case V1: {
                String id;
                this.assertVersion(CarpetNetworkProtocolVersion.V2);
                Objects.requireNonNull(this.nbt);
                ArrayList keys = Lists.newArrayList((Iterable)this.nbt.method_10541());
                if (keys.size() == 1 && ((id = (String)keys.get(0)).equals(V2_HI) || id.equals(V2_HELLO))) {
                    CarpetTISAdditionMod.LOGGER.debug("UniversalCarpetPayload write V1 HI / HELLO, id={}", (Object)id);
                    buf.method_10804(Integer.parseInt(id));
                    buf.method_10814(this.nbt.method_10558(id));
                    return;
                }
                CarpetTISAdditionMod.LOGGER.debug("UniversalCarpetPayload write V1 DATA, nbt={}", (Object)this.nbt);
                buf.method_10804(1);
                buf.method_10794((class_2520)this.nbt);
                break;
            }
            case V2: {
                this.assertVersion(CarpetNetworkProtocolVersion.V1);
                class_2487 tagToWrite = this.nbt;
                if (this.action == 69 || this.action == 420) {
                    tagToWrite = new class_2487();
                    tagToWrite.method_10582(String.valueOf(this.action), Objects.requireNonNull(this.string));
                }
                CarpetTISAdditionMod.LOGGER.debug("UniversalCarpetPayload write V2, action={}, tag={}", (Object)this.action, (Object)tagToWrite);
                buf.method_10794((class_2520)Objects.requireNonNull(tagToWrite));
            }
        }
    }

    private void assertVersion(CarpetNetworkProtocolVersion version) {
        if (this.version != version) {
            throw new RuntimeException(String.format("Unexpected protocol version, expected %s, found %s", new Object[]{version, this.version}));
        }
    }
}

