/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.xcounter;

import carpettisaddition.commands.common.counter.DyeCounterKey;
import carpettisaddition.commands.xcounter.XpCounterCommand;
import carpettisaddition.translations.Translator;
import carpettisaddition.utils.Messenger;
import java.util.Objects;
import net.minecraft.class_5250;

public class XpCounterKey
implements DyeCounterKey {
    private final int xpAmount;
    private static final Translator translator = XpCounterCommand.getInstance().getTranslator();

    public XpCounterKey(int xpAmount) {
        this.xpAmount = xpAmount;
    }

    public int getXpAmount() {
        return this.xpAmount;
    }

    @Override
    public class_5250 getText() {
        return Messenger.hover(Messenger.s(this.xpAmount), translator.tr("key_hover", this.xpAmount, this.getOrbSize()));
    }

    private int getOrbSize() {
        int[] THRESHOLDS = new int[]{0, 3, 7, 17, 37, 73, 149, 307, 617, 1237, 2477};
        for (int i = THRESHOLDS.length - 1; i >= 0; --i) {
            if (this.xpAmount < THRESHOLDS[i]) continue;
            return i;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XpCounterKey that = (XpCounterKey)o;
        return this.xpAmount == that.xpAmount;
    }

    public int hashCode() {
        return Objects.hashCode(this.xpAmount);
    }
}

